/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AddressBookCompanyResultData;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileio.FileIOStringField;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAddressBookCsvFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAddressBookCsvFormData.class.getName());
    private ArrayList groupList;
    private ArrayList groups;
    private ALStringField group_names;
    private ALStringField firstname;
    private ALStringField lastname;
    private ALStringField first_name_kana;
    private ALStringField last_name_kana;
    private FileIOStringField email;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField cellular_phone1;
    private ALStringField cellular_phone2;
    private ALStringField cellular_phone3;
    private FileIOStringField cellular_mail;
    private ArrayList companyList;
    private ALNumberField company_id;
    private ALStringField position_name;
    private ALStringField public_flag;
    private ALStringField note;
    private ALStringField create_user;
    private ALStringField update_user;
    private ALDateField create_date;
    private ALDateField update_date;
    private ALStringField company_name;
    private ALStringField company_name_kana;
    private FileIOStringField post_name;
    private ALStringField comp_zipcode1;
    private ALStringField comp_zipcode2;
    private FileIOStringField comp_address;
    private ALStringField comp_telephone1;
    private ALStringField comp_telephone2;
    private ALStringField comp_telephone3;
    private ALStringField comp_fax_number1;
    private ALStringField comp_fax_number2;
    private ALStringField comp_fax_number3;
    private FileIOStringField comp_url;
    private FileIOStringField telephone_full;
    private FileIOStringField cellular_phone_full;
    private FileIOStringField comp_zipcode_full;
    private FileIOStringField comp_telephone_full;
    private FileIOStringField comp_fax_number_full;
    private ALStringField username;
    private boolean same_company;
    private boolean is_company_only;
    private boolean is_new_company;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_company = rundata.getParameters().getBoolean("is_new_company");
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.groups = new ArrayList();
        this.group_names = new ALStringField();
        this.lastname = new ALStringField();
        this.lastname.setFieldName("\u540d\u524d(\u59d3)");
        this.lastname.setTrim(true);
        this.firstname = new ALStringField();
        this.firstname.setFieldName("\u540d\u524d(\u540d)");
        this.firstname.setTrim(true);
        this.last_name_kana = new ALStringField();
        this.last_name_kana.setFieldName("\u30d5\u30ea\u30ac\u30ca(\u59d3)");
        this.last_name_kana.setTrim(true);
        this.first_name_kana = new ALStringField();
        this.first_name_kana.setFieldName("\u30d5\u30ea\u30ac\u30ca(\u540d)");
        this.first_name_kana.setTrim(true);
        this.email = new FileIOStringField();
        this.email.setFieldName("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.email.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone3.setTrim(true);
        this.cellular_phone1 = new ALStringField();
        this.cellular_phone1.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone1.setTrim(true);
        this.cellular_phone2 = new ALStringField();
        this.cellular_phone2.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone2.setTrim(true);
        this.cellular_phone3 = new ALStringField();
        this.cellular_phone3.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone3.setTrim(true);
        this.cellular_mail = new FileIOStringField();
        this.cellular_mail.setFieldName("\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.cellular_mail.setTrim(true);
        this.company_id = new ALNumberField();
        this.company_id.setFieldName("\u4f1a\u793e");
        this.position_name = new ALStringField();
        this.position_name.setFieldName("\u5f79\u8077");
        this.position_name.setTrim(true);
        this.public_flag = new ALStringField();
        this.public_flag.setFieldName("\u516c\u958b\u533a\u5206");
        this.public_flag.setTrim(true);
        this.create_user = new ALStringField();
        this.create_user.setFieldName("\u4f5c\u6210\u8005");
        this.update_user = new ALStringField();
        this.update_user.setFieldName("\u66f4\u65b0\u8005");
        this.create_date = new ALDateField();
        this.create_date.setFieldName("\u4f5c\u6210\u65e5");
        this.update_date = new ALDateField();
        this.update_date.setFieldName("\u6700\u7d42\u66f4\u65b0\u65e5");
        this.company_name = new ALStringField();
        this.company_name.setFieldName("\u4f1a\u793e\u540d");
        this.company_name.setTrim(true);
        this.company_name_kana = new ALStringField();
        this.company_name_kana.setFieldName("\u4f1a\u793e\u540d(\u30d5\u30ea\u30ac\u30ca)");
        this.company_name_kana.setTrim(true);
        this.post_name = new FileIOStringField();
        this.post_name.setFieldName("\u90e8\u7f72\u540d");
        this.post_name.setTrim(true);
        this.comp_zipcode1 = new ALStringField();
        this.comp_zipcode1.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.comp_zipcode1.setTrim(true);
        this.comp_zipcode2 = new ALStringField();
        this.comp_zipcode2.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.comp_zipcode2.setTrim(true);
        this.comp_address = new FileIOStringField();
        this.comp_address.setFieldName("\u4f4f\u6240");
        this.comp_address.setTrim(true);
        this.comp_telephone1 = new ALStringField();
        this.comp_telephone1.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.comp_telephone1.setTrim(true);
        this.comp_telephone2 = new ALStringField();
        this.comp_telephone2.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.comp_telephone2.setTrim(true);
        this.comp_telephone3 = new ALStringField();
        this.comp_telephone3.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.comp_telephone3.setTrim(true);
        this.comp_fax_number1 = new ALStringField();
        this.comp_fax_number1.setFieldName("FAX\u756a\u53f7");
        this.comp_fax_number1.setTrim(true);
        this.comp_fax_number2 = new ALStringField();
        this.comp_fax_number2.setFieldName("FAX\u756a\u53f7");
        this.comp_fax_number2.setTrim(true);
        this.comp_fax_number3 = new ALStringField();
        this.comp_fax_number3.setFieldName("FAX\u756a\u53f7");
        this.comp_fax_number3.setTrim(true);
        this.comp_url = new FileIOStringField();
        this.comp_url.setFieldName("URL");
        this.comp_url.setTrim(true);
        this.telephone_full = new FileIOStringField();
        this.telephone_full.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.telephone_full.setTrim(true);
        this.cellular_phone_full = new FileIOStringField();
        this.cellular_phone_full.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone_full.setTrim(true);
        this.comp_zipcode_full = new FileIOStringField();
        this.comp_zipcode_full.setFieldName("\u90f5\u4fbf\u756a\u53f7");
        this.comp_zipcode_full.setTrim(true);
        this.comp_telephone_full = new FileIOStringField();
        this.comp_telephone_full.setFieldName("\u96fb\u8a71\u756a\u53f7");
        this.comp_telephone_full.setTrim(true);
        this.comp_fax_number_full = new FileIOStringField();
        this.comp_fax_number_full.setFieldName("FAX\u756a\u53f7");
        this.comp_fax_number_full.setTrim(true);
        this.username = new ALStringField();
        this.username.setFieldName("\u30ed\u30b0\u30a4\u30f3\u540d");
        this.username.setTrim(true);
        this.public_flag.setValue("T");
        this.setTelephone("");
        this.setCellularPhone("");
        this.email.setValue("");
        this.cellular_mail.setValue("");
        this.company_name.setValue("");
        this.company_name_kana.setValue("");
        this.setCompZipcode("");
        this.comp_address.setValue("");
        this.comp_telephone_full.setValue("");
        this.post_name.setValue("");
        this.position_name.setValue("");
        this.telephone1.setValue("");
        this.telephone2.setValue("");
        this.telephone3.setValue("");
        this.telephone_full.setValue("");
        this.comp_zipcode1.setValue("");
        this.comp_zipcode2.setValue("");
        this.comp_zipcode_full.setValue("");
        this.cellular_phone1.setValue("");
        this.cellular_phone2.setValue("");
        this.cellular_phone3.setValue("");
        this.cellular_phone_full.setValue("");
        this.comp_telephone1.setValue("");
        this.comp_telephone2.setValue("");
        this.comp_telephone3.setValue("");
        this.comp_telephone_full.setValue("");
        this.comp_fax_number1.setValue("");
        this.comp_fax_number2.setValue("");
        this.comp_fax_number3.setValue("");
        this.comp_fax_number_full.setValue("");
        this.setSameCompany(false);
        this.setIsCompanyOnly(false);
    }

    public void loadGroupList(RunData rundata, Context context) {
        this.groupList = new ArrayList();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressGroup record = (EipMAddressGroup)aList.get(i);
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId((long)record.getGroupId().intValue());
                rd.setGroupName(record.getGroupName());
                this.groupList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public void loadGroups(RunData rundata, Context context) {
        try {
            String addressid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (addressid == null || "".equals(addressid)) {
                return;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTAddressbookGroupMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"eipTAddressGroup.ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"addressId", (Object)Integer.valueOf(addressid));
            query.andQualifier(exp2);
            query.setDistinct(true);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTAddressbookGroupMap record = (EipTAddressbookGroupMap)aList.get(i);
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId((long)record.getEipTAddressGroup().getGroupId().intValue());
                rd.setGroupName(record.getEipTAddressGroup().getGroupName());
                this.groups.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public void loadCompanyList(RunData rundata, Context context) {
        this.companyList = new ArrayList();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressbookCompany.class);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressbookCompany record = (EipMAddressbookCompany)aList.get(i);
                AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
                rd.initField();
                rd.setCompanyId((long)record.getCompanyId().intValue());
                rd.setCompanyName(record.getCompanyName() + " " + record.getPostName());
                this.companyList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected void setValidator() {
        if (!this.is_company_only) {
            this.lastname.setNotNull(true);
        }
        this.lastname.limitMaxLength(50);
        if (!this.is_company_only) {
            this.firstname.setNotNull(true);
        }
        this.firstname.limitMaxLength(50);
        if (!this.is_company_only) {
            this.last_name_kana.setNotNull(true);
        }
        this.last_name_kana.limitMaxLength(50);
        if (!this.is_company_only) {
            this.first_name_kana.setNotNull(true);
        }
        this.first_name_kana.limitMaxLength(50);
        this.email.setCharacterType(19);
        this.email.limitMaxLength(50);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.cellular_phone1.setCharacterType(2);
        this.cellular_phone1.limitMaxLength(5);
        this.cellular_phone2.setCharacterType(2);
        this.cellular_phone2.limitMaxLength(4);
        this.cellular_phone3.setCharacterType(2);
        this.cellular_phone3.limitMaxLength(4);
        this.cellular_mail.setCharacterType(19);
        this.cellular_mail.limitMaxLength(50);
        this.position_name.limitMaxLength(50);
        if (this.is_company_only) {
            this.company_name.setNotNull(true);
        }
        this.company_name.limitMaxLength(50);
        if (this.is_company_only) {
            this.company_name_kana.setNotNull(true);
        }
        this.company_name.limitMaxLength(50);
        this.post_name.limitMaxLength(50);
        this.comp_zipcode1.setCharacterType(2);
        this.comp_zipcode1.limitLength(3, 3);
        this.comp_zipcode2.setCharacterType(2);
        this.comp_zipcode2.limitLength(4, 4);
        this.comp_address.limitMaxLength(50);
        this.comp_telephone1.setCharacterType(2);
        this.comp_telephone1.limitMaxLength(5);
        this.comp_telephone2.setCharacterType(2);
        this.comp_telephone2.limitMaxLength(4);
        this.comp_telephone3.setCharacterType(2);
        this.comp_telephone3.limitMaxLength(4);
        this.comp_fax_number1.setCharacterType(2);
        this.comp_fax_number1.limitMaxLength(5);
        this.comp_fax_number2.setCharacterType(2);
        this.comp_fax_number2.limitMaxLength(4);
        this.comp_fax_number3.setCharacterType(2);
        this.comp_fax_number3.limitMaxLength(4);
        this.comp_url.setCharacterType(19);
        this.comp_url.limitMaxLength(90);
        this.username.limitMaxLength(16);
        this.telephone_full.setCharacterType(19);
        this.telephone_full.limitMaxLength(15);
        this.cellular_phone_full.setCharacterType(19);
        this.cellular_phone_full.limitMaxLength(15);
        this.comp_telephone_full.setCharacterType(19);
        this.comp_telephone_full.limitMaxLength(15);
        this.comp_fax_number_full.setCharacterType(19);
        this.comp_fax_number_full.limitMaxLength(15);
        this.telephone1.setNotNull(true);
        this.telephone2.setNotNull(true);
        this.telephone3.setNotNull(true);
        this.comp_zipcode1.setNotNull(true);
        this.comp_zipcode2.setNotNull(true);
        this.cellular_phone1.setNotNull(true);
        this.cellular_phone2.setNotNull(true);
        this.cellular_phone3.setNotNull(true);
        this.comp_telephone1.setNotNull(true);
        this.comp_telephone2.setNotNull(true);
        this.comp_telephone3.setNotNull(true);
        this.comp_fax_number1.setNotNull(true);
        this.comp_fax_number2.setNotNull(true);
        this.comp_fax_number3.setNotNull(true);
    }

    protected boolean validate(ArrayList msgList) {
        ArrayList dummy = new ArrayList();
        if (!this.lastname.validate(msgList)) {
            this.firstname.setValue("");
            this.lastname.setValue("");
        }
        if (!this.firstname.validate(msgList)) {
            this.firstname.setValue("");
            this.lastname.setValue("");
        }
        this.last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.last_name_kana.toString())));
        this.first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.first_name_kana.toString())));
        if (!this.last_name_kana.validate(msgList)) {
            this.first_name_kana.setValue("");
            this.last_name_kana.setValue("");
        }
        if (!this.first_name_kana.validate(msgList)) {
            this.first_name_kana.setValue("");
            this.last_name_kana.setValue("");
        }
        if (this.email.getValue().trim().length() > 0 && !ALStringUtil.isMailAddress((String)this.email.getValue())) {
            msgList.add("\u300e <span class='em'>\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            this.email.setValidate(false);
            this.email.setValue(null);
        }
        if (!(this.telephone1.getValue().equals("") && this.telephone2.getValue().equals("") && this.telephone3.getValue().equals(""))) {
            if (!(this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy))) {
                msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                this.telephone_full.setValidate(false);
                this.telephone_full.setValue(null);
            } else {
                this.telephone_full.setValue(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            }
        }
        if (!(this.cellular_phone1.getValue().equals("") && this.cellular_phone2.getValue().equals("") && this.cellular_phone3.getValue().equals(""))) {
            if (!(this.cellular_phone1.validate(dummy) && this.cellular_phone2.validate(dummy) && this.cellular_phone3.validate(dummy))) {
                msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                this.cellular_phone_full.setValidate(true);
                this.cellular_phone_full.setValue(null);
            } else {
                this.cellular_phone_full.setValue(new StringBuffer().append(this.cellular_phone1.getValue()).append("-").append(this.cellular_phone2.getValue()).append("-").append(this.cellular_phone3.getValue()).toString());
            }
        }
        if (this.cellular_mail.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.cellular_mail.getValue())) {
            msgList.add("\u300e <span class='em'>\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            this.cellular_mail.setValidate(false);
            this.cellular_mail.setValue(null);
        }
        if (!this.position_name.validate(msgList)) {
            this.position_name.setValue(null);
        }
        if (!this.company_name.toString().equals("")) {
            EipMAddressbookCompany ecompany = this.getEipMCompany();
            if (ecompany != null) {
                this.company_id.setValue((long)ecompany.getCompanyId().intValue());
                if (!this.company_name_kana.validate(msgList) || this.company_name_kana.toString().equals("")) {
                    this.company_name_kana.setValue(ecompany.getCompanyNameKana());
                }
                if (this.is_company_only) {
                    this.setSameCompany(true);
                }
            } else {
                if (!this.company_name.validate(msgList)) {
                    this.company_name.setValue(null);
                    msgList.add("\u300e <span class='em'>\u4f1a\u793e\u540d</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                this.company_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.company_name_kana.toString())));
                if (!this.company_name_kana.validate(dummy)) {
                    this.company_name_kana.setValue(null);
                    msgList.add("\u300e <span class='em'>\u4f1a\u793e\u540d\u30d5\u30ea\u30ac\u30ca</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                if (this.company_name.getValue() != null && this.company_name_kana.getValue() != null && !this.company_name.getValue().equals("") && this.company_name_kana.getValue().equals("")) {
                    msgList.add("\u300e <span class='em'>\u4f1a\u793e\u540d\u30d5\u30ea\u30ac\u30ca</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                if (!this.post_name.validate(msgList)) {
                    this.post_name.setValue(null);
                    this.post_name.setValidate(false);
                    msgList.add("\u300e <span class='em'>\u90f5\u4fbf\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                if (!this.comp_zipcode1.getValue().equals("") || !this.comp_zipcode2.getValue().equals("")) {
                    if (!this.comp_zipcode1.validate(dummy) || !this.comp_zipcode2.validate(dummy)) {
                        msgList.add("\u300e <span class='em'>\u90f5\u4fbf\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        this.comp_zipcode_full.setValidate(false);
                        this.comp_zipcode_full.setValue(null);
                    } else {
                        this.comp_zipcode_full.setValue(new StringBuffer().append(this.comp_zipcode1.getValue()).append("-").append(this.comp_zipcode2.getValue()).toString());
                    }
                }
                if (!this.comp_address.validate(msgList)) {
                    this.comp_address.setValidate(false);
                    this.comp_address.setValue(null);
                    msgList.add("\u300e <span class='em'>\u4f4f\u6240</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
                if (!(this.comp_telephone1.getValue().equals("") && this.comp_telephone2.getValue().equals("") && this.comp_telephone3.getValue().equals(""))) {
                    if (!(this.comp_telephone1.validate(dummy) && this.comp_telephone2.validate(dummy) && this.comp_telephone3.validate(dummy))) {
                        msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        this.comp_telephone_full.setValidate(false);
                        this.comp_telephone_full.setValue(null);
                    } else {
                        this.comp_telephone_full.setValue(new StringBuffer().append(this.comp_telephone1.getValue()).append("-").append(this.comp_telephone2.getValue()).append("-").append(this.comp_telephone3.getValue()).toString());
                    }
                }
                if (!(this.comp_fax_number1.getValue().equals("") && this.comp_fax_number2.getValue().equals("") && this.comp_fax_number3.getValue().equals(""))) {
                    if (!(this.comp_fax_number1.validate(dummy) && this.comp_fax_number2.validate(dummy) && this.comp_fax_number3.validate(dummy))) {
                        msgList.add("\u300e <span class='em'>FAX\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                        this.comp_fax_number_full.setValidate(false);
                        this.comp_fax_number_full.setValue(null);
                    } else {
                        this.comp_fax_number_full.setValue(new StringBuffer().append(this.comp_fax_number1.getValue()).append("-").append(this.comp_fax_number2.getValue()).append("-").append(this.comp_fax_number3.getValue()).toString());
                    }
                }
                if (!this.comp_url.validate(msgList)) {
                    this.comp_url.setValidate(false);
                    this.comp_url.setValue(null);
                    msgList.add("\u300e <span class='em'>URL</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            }
        }
        if (this.getTurbineUser() == null) {
            this.setUserName("");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        int uid;
        ALEipUser user;
        try {
            user = ALEipUtils.getALEipUser((String)this.username.getValue());
            uid = user != null ? (int)user.getUserId().getValue() : 1;
        }
        catch (ALDBErrorException e) {
            uid = 1;
            user = null;
        }
        try {
            EipMAddressbookCompany company;
            if (!this.company_name.toString().equals("")) {
                EipMAddressbookCompany ecompany = this.getEipMCompany();
                if (ecompany == null) {
                    if (!this.insertCompanyData(rundata, context)) {
                        // empty if block
                    }
                } else if (!this.company_name_kana.toString().equals("")) {
                    this.company_id.setValue((long)ecompany.getCompanyId().intValue());
                }
            } else {
                this.company_id.setValue(1L);
            }
            boolean fullname = !this.getFirstName().toString().equals("") || !this.getLastName().toString().equals("");
            boolean fullnamekana = !this.getFirstNameKana().toString().equals("") || !this.getLastNameKana().toString().equals("");
            if (!fullname || !fullnamekana) {
                return true;
            }
            EipMAddressbook address = (EipMAddressbook)this.dataContext.createAndRegisterNewObject(EipMAddressbook.class);
            address.setLastName(this.lastname.getValue());
            address.setFirstName(this.firstname.getValue());
            address.setLastNameKana(this.last_name_kana.getValue());
            address.setFirstNameKana(this.first_name_kana.getValue());
            address.setEmail(this.email.getValue());
            address.setTelephone(this.telephone_full.getValue());
            address.setCellularPhone(this.cellular_phone_full.getValue());
            address.setCellularMail(this.cellular_mail.getValue());
            address.setPositionName(this.position_name.getValue());
            if (this.company_id.getValue() > 0L && (company = (EipMAddressbookCompany)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipMAddressbookCompany.class, (Object)((int)this.company_id.getValue()))).getCompanyId() > 0) {
                address.setEipMAddressbookCompany(company);
            }
            address.setPublicFlag(this.public_flag.getValue());
            address.setOwnerId(Integer.valueOf(uid));
            address.setCreateUserId(Integer.valueOf(uid));
            address.setUpdateUserId(Integer.valueOf(uid));
            Date now = new Date();
            address.setCreateDate(now);
            address.setUpdateDate(now);
            this.dataContext.commitChanges();
            Integer id = address.getAddressId();
            for (int i = 0; i < this.groups.size(); ++i) {
                EipTAddressbookGroupMap map = (EipTAddressbookGroupMap)this.dataContext.createAndRegisterNewObject(EipTAddressbookGroupMap.class);
                map.setAddressId(id);
                map.setEipTAddressGroup((EipMAddressGroup)this.groups.get(i));
            }
            this.dataContext.commitChanges();
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        this.groups = new ArrayList();
        if (res) {
            try {
                Object[] str = rundata.getParameters().getStrings("group_to");
                if (str == null) {
                    return res;
                }
                if (this.isEmpty((String[])str)) {
                    return res;
                }
                SelectQuery query = new SelectQuery(EipMAddressGroup.class);
                Expression exp = ExpressionFactory.inDbExp((String)"GROUP_ID", (Object[])str);
                query.setQualifier(exp);
                List list = this.dataContext.performQuery((Query)query);
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipMAddressGroup group = (EipMAddressGroup)list.get(i);
                    this.groups.add(group);
                }
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
            }
        }
        return res;
    }

    private boolean isEmpty(String[] str) {
        boolean res = true;
        for (int i = 0; i < str.length; ++i) {
            if (str[i] == null || "".equals(str[i])) continue;
            res = false;
        }
        return res;
    }

    public FileIOStringField getCellularMail() {
        return this.cellular_mail;
    }

    public ALStringField getCellularPhone1() {
        return this.cellular_phone1;
    }

    public ALStringField getCellularPhone2() {
        return this.cellular_phone2;
    }

    public ALStringField getCellularPhone3() {
        return this.cellular_phone3;
    }

    public ALNumberField getCompanyId() {
        return this.company_id;
    }

    public FileIOStringField getEmail() {
        return this.email;
    }

    public ALStringField getFirstNameKana() {
        return this.first_name_kana;
    }

    public ALStringField getFirstName() {
        return this.firstname;
    }

    public ALStringField getLastNameKana() {
        return this.last_name_kana;
    }

    public ALStringField getLastName() {
        return this.lastname;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getPositionName() {
        return this.position_name;
    }

    public ALStringField getPublicFlag() {
        return this.public_flag;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public ALDateField getCreateDate() {
        return this.create_date;
    }

    public ALDateField getUpdateDate() {
        return this.update_date;
    }

    public ALStringField getCreateUser() {
        return this.create_user;
    }

    public ArrayList getGroupList() {
        return this.groupList;
    }

    public ArrayList getCompanyList() {
        return this.companyList;
    }

    public ALStringField getUpdateUser() {
        return this.update_user;
    }

    public List getGroups() {
        return this.groups;
    }

    public ALStringField getGroupNames() {
        return this.group_names;
    }

    public void setCellularMail(FileIOStringField field) {
        this.cellular_mail = field;
    }

    public void setCompanyId(ALNumberField field) {
        this.company_id = field;
    }

    public void setEmail(FileIOStringField field) {
        this.email = field;
    }

    public void setFirstNameKana(ALStringField field) {
        this.first_name_kana = field;
    }

    public void setFirstName(ALStringField field) {
        this.firstname = field;
    }

    public void setLastNameKana(ALStringField field) {
        this.last_name_kana = field;
    }

    public void setLastName(ALStringField field) {
        this.lastname = field;
    }

    public void setNote(ALStringField field) {
        this.note = field;
    }

    public void setPositionName(ALStringField field) {
        this.position_name = field;
    }

    public void setPublicFlag(ALStringField field) {
        this.public_flag = field;
    }

    public void setCreateDate(ALDateField field) {
        this.create_date = field;
    }

    public void setUpdateDate(ALDateField field) {
        this.update_date = field;
    }

    public void setGroupNames(ALStringField field) {
        this.group_names = field;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALStringField getCompanyNameKana() {
        return this.company_name_kana;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getCompZipcode1() {
        return this.comp_zipcode1;
    }

    public ALStringField getCompZipcode2() {
        return this.comp_zipcode2;
    }

    public FileIOStringField getCompAddress() {
        return this.comp_address;
    }

    public ALStringField getCompTelephone1() {
        return this.comp_telephone1;
    }

    public ALStringField getCompTelephone2() {
        return this.comp_telephone2;
    }

    public ALStringField getCompTelephone3() {
        return this.comp_telephone3;
    }

    public ALStringField getCompFaxNumber1() {
        return this.comp_fax_number1;
    }

    public ALStringField getCompFaxNumber2() {
        return this.comp_fax_number2;
    }

    public ALStringField getCompFaxNumber3() {
        return this.comp_fax_number3;
    }

    public FileIOStringField getCompUrl() {
        return this.comp_url;
    }

    public boolean isNewCompany() {
        return this.is_new_company;
    }

    private boolean insertCompanyData(RunData rundata, Context context) {
        int uid;
        try {
            ALEipUser user = ALEipUtils.getALEipUser((String)this.username.getValue());
            uid = user != null ? (int)user.getUserId().getValue() : 1;
        }
        catch (ALDBErrorException e) {
            uid = 1;
            Object user = null;
        }
        try {
            EipMAddressbookCompany company = (EipMAddressbookCompany)this.dataContext.createAndRegisterNewObject(EipMAddressbookCompany.class);
            rundata.getParameters().setProperties((Object)company);
            company.setCompanyName(this.company_name.getValue());
            company.setCompanyNameKana(this.company_name_kana.getValue());
            company.setPostName(this.post_name.getValue());
            company.setZipcode(this.comp_zipcode_full.getValue());
            company.setAddress(this.comp_address.getValue());
            company.setTelephone(this.comp_telephone_full.getValue());
            company.setFaxNumber(this.comp_fax_number_full.getValue());
            company.setUrl(this.comp_url.getValue());
            company.setCreateUserId(Integer.valueOf(uid));
            company.setUpdateUserId(Integer.valueOf(uid));
            Date now = new Date();
            company.setCreateDate(now);
            company.setUpdateDate(now);
            this.dataContext.commitChanges();
            this.company_id.setValue(company.getCompanyId().longValue());
        }
        catch (Exception ex) {
            logger.debug((Object)"AddressBookFormData insertFormData out / false");
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public ALStringField getUserName() {
        return this.username;
    }

    public FileIOStringField getTelephone() {
        return this.telephone_full;
    }

    public FileIOStringField getCellularPhone() {
        return this.cellular_phone_full;
    }

    public FileIOStringField getCompZipcode() {
        return this.comp_zipcode_full;
    }

    public FileIOStringField getCompTelephone() {
        return this.comp_telephone_full;
    }

    public FileIOStringField getCompFaxNumber() {
        return this.comp_fax_number_full;
    }

    public boolean getSameCompany() {
        return this.same_company;
    }

    public void setTelephone(String str) {
        this.telephone_full.setValue(str);
    }

    public void setCellularPhone(String str) {
        this.cellular_phone_full.setValue(str);
    }

    public void setCompZipcode(String str) {
        this.comp_zipcode_full.setValue(str);
    }

    public void setCompTelephone(String str) {
        this.comp_telephone_full.setValue(str);
    }

    public void setCompFaxNumber(String str) {
        this.comp_fax_number_full.setValue(str);
    }

    public void setUserName(String str) {
        this.username.setValue(str);
    }

    public void setSameCompany(boolean flg) {
        this.same_company = flg;
    }

    public void setIsCompanyOnly(boolean flag) {
        this.is_company_only = flag;
    }

    public void addItemToken(String token, int i) {
        switch (i) {
            case -1: {
                break;
            }
            case 0: {
                StringTokenizer st = new StringTokenizer(token);
                if (st.hasMoreTokens()) {
                    this.lastname.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.firstname.setValue(st.nextToken());
                break;
            }
            case 1: {
                StringTokenizer st = new StringTokenizer(token);
                if (st.hasMoreTokens()) {
                    this.last_name_kana.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.first_name_kana.setValue(st.nextToken());
                break;
            }
            case 2: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.telephone1.setValue(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.telephone2.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.telephone3.setValue(st.nextToken());
                break;
            }
            case 3: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.cellular_phone1.setValue(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.cellular_phone2.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.cellular_phone3.setValue(st.nextToken());
                break;
            }
            case 4: {
                this.email.setValue(token);
                break;
            }
            case 5: {
                this.cellular_mail.setValue(token);
                break;
            }
            case 6: {
                this.company_name.setValue(token);
                break;
            }
            case 7: {
                this.company_name_kana.setValue(token);
                break;
            }
            case 8: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.comp_zipcode1.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.comp_zipcode2.setValue(st.nextToken());
                break;
            }
            case 9: {
                this.comp_address.setValue(token);
                break;
            }
            case 10: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.comp_telephone1.setValue(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.comp_telephone2.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.comp_telephone3.setValue(st.nextToken());
                break;
            }
            case 11: {
                StringTokenizer st = new StringTokenizer(token, "-");
                if (st.hasMoreTokens()) {
                    this.comp_fax_number1.setValue(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    this.comp_fax_number2.setValue(st.nextToken());
                }
                if (!st.hasMoreTokens()) break;
                this.comp_fax_number3.setValue(st.nextToken());
                break;
            }
            case 12: {
                this.post_name.setValue(token);
                break;
            }
            case 13: {
                this.position_name.setValue(token);
                break;
            }
            case 14: {
                this.username.setValue(token);
                break;
            }
            case 15: {
                this.lastname.setValue(token);
                break;
            }
            case 16: {
                this.firstname.setValue(token);
                break;
            }
            case 17: {
                this.last_name_kana.setValue(token);
                break;
            }
            case 18: {
                this.first_name_kana.setValue(token);
                break;
            }
            case 19: {
                this.comp_url.setValue(token);
                break;
            }
        }
    }

    private TurbineUser getTurbineUser() {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(TurbineUser.class);
        Expression exp = ExpressionFactory.matchExp((String)"loginName", (Object)this.username);
        query.setQualifier(exp);
        List users = dataContext.performQuery((Query)query);
        if (users == null || users.size() == 0) {
            logger.debug((Object)"[FileIOAddressBookCsvFormData] Not found ID...");
            return null;
        }
        TurbineUser tuser = (TurbineUser)users.get(0);
        return tuser;
    }

    private EipMAddressbookCompany getEipMCompany() {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMAddressbookCompany.class);
        Expression exp = ExpressionFactory.matchExp((String)"companyName", (Object)this.company_name);
        query.setQualifier(exp);
        List users = dataContext.performQuery((Query)query);
        if (users == null || users.size() == 0) {
            logger.debug((Object)"[FileIOAddressBookCsvFormData] Not found ID...");
            return null;
        }
        for (int i = 0; i < users.size(); ++i) {
            EipMAddressbookCompany com = (EipMAddressbookCompany)users.get(i);
            if (!com.getPostName().equals(this.post_name.toString())) continue;
            return com;
        }
        return null;
    }
}

