/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALCsvAbstractSelectData;
import com.aimluck.eip.common.ALCsvTokenizer;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileio.FileIOAccountCsvFormData;
import com.aimluck.eip.fileio.FileIOAccountCsvResultData;
import com.aimluck.eip.fileio.util.FileIOAccountCsvUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAccountCsvSelectData
extends ALCsvAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountCsvSelectData.class.getName());
    private boolean overMaxUser = false;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            if (this.stats == 0) {
                return this.readAccountInfoFromCsv(rundata);
            }
            if (this.stats == 1) {
                String filepath = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + File.separator + "account.csv";
                return this.readAccountInfoFromCsvPage(rundata, filepath, rundata.getParameters().getInteger("csvpage") - 1, 1000);
            }
            if (this.stats == 2) {
                if (this.error_count <= 0) {
                    return null;
                }
                String filepath = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + File.separator + "account_post_err.csv";
                return this.readAccountInfoFromCsvPage(rundata, filepath, 0, 100);
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    private List readAccountInfoFromCsv(RunData rundata) throws Exception {
        String filepath = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + File.separator + "account.csv";
        String filepath_err = FileIOAccountCsvUtils.getAccountCsvFolderName(this.getTempFolderIndex()) + File.separator + "account_post_err.csv";
        File file = new File(filepath);
        if (!file.exists()) {
            return null;
        }
        ALCsvTokenizer reader = new ALCsvTokenizer();
        if (!reader.init(filepath)) {
            return null;
        }
        ArrayList<FileIOAccountCsvResultData> list = new ArrayList<FileIOAccountCsvResultData>();
        LinkedHashMap<String, TurbineUser> existedUserMap = this.getAllUsersFromDB();
        if (existedUserMap == null) {
            existedUserMap = new LinkedHashMap<String, TurbineUser>();
        }
        int ErrCount = 0;
        ArrayList<String> usernameList = new ArrayList<String>();
        int line = 0;
        String ErrorCode = "";
        while (reader.eof != -1) {
            int j;
            ++line;
            boolean same_user = false;
            boolean b_err = false;
            ArrayList errmsg = new ArrayList();
            FileIOAccountCsvFormData formData = new FileIOAccountCsvFormData();
            formData.initField();
            String e_line = "";
            for (j = 0; j < this.sequency.size(); ++j) {
                String token = reader.nextToken();
                if (j > 0) {
                    e_line = e_line + ",";
                }
                e_line = e_line + "\"";
                e_line = e_line + this.makeOutputItem(token);
                e_line = e_line + "\"";
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            ++j;
            while (j < this.sequency.size()) {
                e_line = e_line + ",\"\"";
                ++j;
            }
            if (reader.eof == -1) break;
            if (formData.getUserName().toString().equals("\u30ed\u30b0\u30a4\u30f3\u540d")) {
                this.setLineCount(this.getLineCount() - 1);
                ErrorCode = ErrorCode + e_line;
                ErrorCode = ErrorCode + "," + Integer.toString(line) + ",false";
                ErrorCode = ErrorCode + "\n";
                continue;
            }
            if (usernameList.contains(formData.getUserName().getValue())) {
                same_user = true;
                b_err = true;
            } else {
                usernameList.add(formData.getUserName().getValue());
            }
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                b_err = true;
            }
            try {
                String username = formData.getUserName().getValue();
                FileIOAccountCsvResultData data = new FileIOAccountCsvResultData();
                TurbineUser user = new TurbineUser();
                if (existedUserMap.containsKey(username)) {
                    TurbineUser tmpuser2 = (TurbineUser)existedUserMap.get(username);
                    if ("F".equals(tmpuser2.getDisabled())) {
                        user.setLoginName(username);
                    } else {
                        user.setLoginName(null);
                        b_err = true;
                    }
                } else {
                    user.setLoginName(username);
                    TurbineUser newuser = new TurbineUser();
                    newuser.setLoginName(username);
                    newuser.setDisabled("F");
                    existedUserMap.put(username, newuser);
                }
                user.setPasswordValue(formData.getPassword().getValue());
                user.setFirstName(formData.getFirstName().getValue());
                user.setLastName(formData.getLastName().getValue());
                user.setFirstNameKana(formData.getFirstNameKana().getValue());
                user.setLastNameKana(formData.getLastNameKana().getValue());
                user.setEmail(formData.getEmail().getValue());
                user.setOutTelephone(formData.getOutTelephone().getValue());
                user.setInTelephone(formData.getInTelephone().getValue());
                user.setCellularPhone(formData.getCellularPhone().getValue());
                user.setCellularMail(formData.getCellularMail().getValue());
                data.initField();
                data.setLineCount(line);
                data.setUser(user);
                data.setPostNotFound(formData.getPostNotFound());
                ArrayList<String> postnames = new ArrayList<String>();
                String[] st = formData.getPostName().toString().split("/");
                for (int k = 0; k < st.length; ++k) {
                    postnames.add(st[k]);
                }
                data.setPostName(formData.getPostName().getValue());
                data.setPostNameList(postnames);
                data.setPositionNotFound(formData.getPositionNotFound());
                data.setPositionName(formData.getPositionName().getValue());
                data.setSameUser(same_user);
                data.setIsError(b_err);
                if (b_err) {
                    ErrorCode = ErrorCode + e_line;
                    ErrorCode = ErrorCode + "," + Integer.toString(line) + "," + Boolean.toString(same_user);
                    ErrorCode = ErrorCode + "\n";
                }
                if (ErrCount == 0) {
                    if (!b_err) {
                        if (list.size() < 1000) {
                            list.add(data);
                        }
                    } else {
                        list.add(data);
                        ++ErrCount;
                    }
                } else {
                    if (b_err) {
                        ++ErrCount;
                    }
                    list.add(data);
                }
                if (ErrCount < 100) continue;
                break;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        TurbineUser tmpuser22 = null;
        int count_legitimate_user = 0;
        Collection coll = existedUserMap.values();
        for (TurbineUser tmpuser22 : coll) {
            if (!"F".equals(tmpuser22.getDisabled())) continue;
            ++count_legitimate_user;
        }
        this.setErrorCount(ErrCount);
        if (ErrCount > 0) {
            this.outputErrorData(rundata, ErrorCode, filepath_err);
        }
        return list;
    }

    private List readAccountInfoFromCsvPage(RunData rundata, String filepath, int StartLine, int LineLimit) throws Exception {
        ALCsvTokenizer reader = new ALCsvTokenizer();
        int line_index = StartLine * 1000;
        if (!reader.setStartLine(filepath, line_index)) {
            return null;
        }
        LinkedHashMap<String, TurbineUser> existedUserMap = this.getAllUsersFromDB();
        if (existedUserMap == null) {
            existedUserMap = new LinkedHashMap<String, TurbineUser>();
        }
        ArrayList<FileIOAccountCsvResultData> list = new ArrayList<FileIOAccountCsvResultData>();
        int line = 0;
        while (reader.eof != -1) {
            String token;
            boolean iserror = false;
            boolean same_user = false;
            if (++line > LineLimit) break;
            ArrayList errmsg = new ArrayList();
            FileIOAccountCsvFormData formData = new FileIOAccountCsvFormData();
            formData.initField();
            for (int j = 0; j < this.sequency.size(); ++j) {
                token = reader.nextToken();
                int i = Integer.parseInt((String)this.sequency.get(j));
                formData.addItemToken(token, i);
                if (reader.eof == -1 || reader.line) break;
                if (j != this.sequency.size() - 1 || this.stats != 2) continue;
                token = reader.nextToken();
                line = Integer.parseInt(token);
            }
            if (this.stats == 2) {
                token = reader.nextToken();
                same_user = Boolean.parseBoolean(token);
            }
            while (!reader.line && reader.eof != -1) {
                reader.nextToken();
            }
            if (formData.getUserName().toString().equals("\u30ed\u30b0\u30a4\u30f3\u540d")) continue;
            if (reader.eof == -1) break;
            formData.setValidator();
            if (!formData.validate(errmsg)) {
                iserror = true;
            }
            if (this.stats == 2) {
                iserror = true;
            }
            try {
                String username = formData.getUserName().getValue();
                FileIOAccountCsvResultData data = new FileIOAccountCsvResultData();
                data.initField();
                TurbineUser user = new TurbineUser();
                if (existedUserMap.containsKey(username)) {
                    TurbineUser tmpuser2 = (TurbineUser)existedUserMap.get(username);
                    if ("F".equals(tmpuser2.getDisabled())) {
                        user.setLoginName(username);
                    } else {
                        user.setLoginName(null);
                        iserror = true;
                    }
                } else {
                    user.setLoginName(username);
                    TurbineUser newuser = new TurbineUser();
                    newuser.setLoginName(username);
                    newuser.setDisabled("F");
                    existedUserMap.put(username, newuser);
                }
                user.setPasswordValue(formData.getPassword().getValue());
                user.setFirstName(formData.getFirstName().getValue());
                user.setLastName(formData.getLastName().getValue());
                user.setFirstNameKana(formData.getFirstNameKana().getValue());
                user.setLastNameKana(formData.getLastNameKana().getValue());
                user.setEmail(formData.getEmail().getValue());
                user.setOutTelephone(formData.getOutTelephone().getValue());
                user.setInTelephone(formData.getInTelephone().getValue());
                user.setCellularPhone(formData.getCellularPhone().getValue());
                user.setCellularMail(formData.getCellularMail().getValue());
                data.setUser(user);
                data.setLineCount(line + line_index);
                ArrayList<String> postnames = new ArrayList<String>();
                String[] st = formData.getPostName().toString().split("/");
                for (int k = 0; k < st.length; ++k) {
                    postnames.add(st[k]);
                }
                data.setPostName(formData.getPostName().getValue());
                data.setPostNameList(postnames);
                data.setPostNotFound(formData.getPostNotFound());
                data.setPositionNotFound(formData.getPositionNotFound());
                data.setPositionName(formData.getPositionName().getValue());
                data.setSameUser(same_user);
                data.setIsError(iserror);
                list.add(data);
            }
            catch (Exception e) {
                logger.error((Object)"readError");
            }
            if (reader.eof != -1) continue;
            break;
        }
        return list;
    }

    private Map getAllUsersFromDB() {
        LinkedHashMap<String, TurbineUser> map = null;
        try {
            SelectQuery query = new SelectQuery(TurbineUser.class);
            List list = this.dataContext.performQuery((Query)query);
            map = new LinkedHashMap<String, TurbineUser>();
            TurbineUser user = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                user = (TurbineUser)list.get(i);
                map.put(user.getLoginName(), user);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[ALEipUtils]", (Throwable)ex);
        }
        return map;
    }

    protected Object getResultData(Object obj) {
        return obj;
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public boolean overMaxUser() {
        return this.overMaxUser;
    }
}

