/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileio;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.account.EipMPosition;
import com.aimluck.eip.cayenne.om.account.EipMPost;
import com.aimluck.eip.cayenne.om.account.EipTAclRole;
import com.aimluck.eip.cayenne.om.account.EipTAclUserRoleMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class FileIOAccountCsvFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileIOAccountCsvFormData.class.getName());
    public static final String DEFAULT_VIEW_PASSWORD = "*";
    private ALStringField username;
    private ALStringField password;
    private ALStringField firstname;
    private ALStringField lastname;
    private ALStringField first_name_kana;
    private ALStringField last_name_kana;
    private ALStringField email;
    private ALStringField in_telephone;
    private ALStringField out_telephone;
    private ALStringField cellular_phone;
    private ALStringField cellular_mail;
    private ALStringField post_name;
    private ArrayList post_name_list;
    private ALStringField position_name;
    private boolean post_not_found;
    private boolean position_not_found;
    private ArrayList usernameList;

    public void initField() {
        this.username = new ALStringField();
        this.username.setFieldName("\u30ed\u30b0\u30a4\u30f3\u540d");
        this.username.setTrim(true);
        this.password = new ALStringField();
        this.password.setFieldName("\u30d1\u30b9\u30ef\u30fc\u30c9");
        this.password.setTrim(true);
        this.firstname = new ALStringField();
        this.firstname.setFieldName("\u540d\u524d\uff08\u540d\uff09");
        this.firstname.setTrim(true);
        this.lastname = new ALStringField();
        this.lastname.setFieldName("\u540d\u524d\uff08\u59d3\uff09");
        this.lastname.setTrim(true);
        this.email = new ALStringField();
        this.email.setFieldName("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.email.setTrim(true);
        this.in_telephone = new ALStringField();
        this.in_telephone.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5185\u7dda\uff09");
        this.in_telephone.setTrim(true);
        this.out_telephone = new ALStringField();
        this.out_telephone.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u5916\u7dda\uff09");
        this.out_telephone.setTrim(true);
        this.cellular_phone = new ALStringField();
        this.cellular_phone.setFieldName("\u96fb\u8a71\u756a\u53f7\uff08\u643a\u5e2f\uff09");
        this.cellular_phone.setTrim(true);
        this.cellular_mail = new ALStringField();
        this.cellular_mail.setFieldName("\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.cellular_mail.setTrim(true);
        this.first_name_kana = new ALStringField();
        this.first_name_kana.setFieldName("\u540d\u524d\uff08\u30d5\u30ea\u30ac\u30ca\uff09");
        this.first_name_kana.setTrim(true);
        this.last_name_kana = new ALStringField();
        this.last_name_kana.setFieldName("\u540d\u524d\uff08\u30d5\u30ea\u30ac\u30ca\uff09");
        this.last_name_kana.setTrim(true);
        this.post_name_list = new ArrayList();
        this.post_name = new ALStringField();
        this.post_name.setFieldName("\u90e8\u7f72\u540d");
        this.post_name.setTrim(true);
        this.position_name = new ALStringField();
        this.position_name.setFieldName("\u5f79\u8077");
        this.position_name.setTrim(true);
        this.setPostNotFound(false);
        this.setPositionNotFound(false);
        this.usernameList = new ArrayList();
    }

    protected void setValidator() {
        this.username.setNotNull(true);
        this.username.setCharacterType(3);
        this.username.limitMaxLength(16);
        this.password.setNotNull(true);
        this.password.setCharacterType(3);
        this.password.limitMaxLength(16);
        this.firstname.setNotNull(true);
        this.firstname.limitMaxLength(20);
        this.lastname.setNotNull(true);
        this.lastname.limitMaxLength(20);
        this.first_name_kana.setNotNull(true);
        this.first_name_kana.limitMaxLength(20);
        this.last_name_kana.setNotNull(true);
        this.last_name_kana.limitMaxLength(20);
        this.in_telephone.setCharacterType(3);
        this.in_telephone.limitMaxLength(15);
        this.email.setCharacterType(19);
        this.email.limitMaxLength(50);
        this.out_telephone.setCharacterType(2);
        this.out_telephone.limitMaxLength(15);
        this.cellular_phone.setCharacterType(2);
        this.cellular_phone.limitMaxLength(15);
        this.cellular_mail.setCharacterType(19);
        this.cellular_mail.limitMaxLength(50);
        this.post_name.limitMaxLength(50);
        this.position_name.limitMaxLength(50);
    }

    protected boolean validate(ArrayList msgList) {
        int i;
        TurbineUser tmpuser2;
        LinkedHashMap existedUserMap;
        String usernamestr = this.username.getValue();
        if ("admin".equals(usernamestr) || "template".equals(usernamestr) || "anon".equals(usernamestr) || !this.username.validate(msgList)) {
            this.username.setValue(null);
        }
        if ((existedUserMap = this.getAllUsersFromDB()) == null) {
            existedUserMap = new LinkedHashMap();
        }
        if (existedUserMap.containsKey(usernamestr) && !"F".equals((tmpuser2 = (TurbineUser)existedUserMap.get(usernamestr)).getDisabled())) {
            msgList.add("<span class='em'>\u4e00\u5ea6\u524a\u9664\u3057\u305f\u30e6\u30fc\u30b6\u30fc\u540d\u306f\u8907\u6570\u767b\u9332\u3067\u304d\u307e\u305b\u3093</span>");
            this.username.setValue(null);
        }
        if (!this.password.getValue().equals(DEFAULT_VIEW_PASSWORD) && !this.password.validate(msgList)) {
            this.password.setValue(null);
        }
        if (!this.firstname.validate(msgList)) {
            this.firstname.setValue(null);
            this.lastname.setValue(null);
        }
        if (!this.lastname.validate(msgList)) {
            this.firstname.setValue(null);
            this.lastname.setValue(null);
        }
        this.first_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.first_name_kana.toString())));
        this.last_name_kana.setValue(ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.last_name_kana.toString())));
        if (!this.first_name_kana.validate(msgList)) {
            this.first_name_kana.setValue(null);
            this.last_name_kana.setValue(null);
        }
        if (!this.last_name_kana.validate(msgList)) {
            this.first_name_kana.setValue(null);
            this.last_name_kana.setValue(null);
        }
        if (this.email.getValue() != null && !this.email.getValue().equals("")) {
            if (!this.email.validate(msgList) || this.email.getValue() != null && this.email.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.email.getValue())) {
                this.email.setValue(null);
                msgList.add("\u300e <span class='em'>\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            this.email.setValue("");
        }
        ALNumberField tel = new ALNumberField();
        ArrayList errmsg = new ArrayList();
        boolean isNumber = true;
        if (this.out_telephone.getValue() != null && !this.out_telephone.getValue().equals("")) {
            String[] out_tels = this.out_telephone.getValue().split("-");
            if (out_tels.length == 3) {
                for (i = 0; i < 3; ++i) {
                    tel.setValue(out_tels[i]);
                    isNumber &= tel.validate(errmsg);
                }
                if (!isNumber || out_tels[0].length() > 5 || out_tels[1].length() > 4 || out_tels[2].length() > 4) {
                    this.out_telephone.setValue(null);
                    msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            } else {
                this.out_telephone.setValue(null);
                msgList.add("\u300e <span class='em'>\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            this.out_telephone.setValue("");
        }
        if (this.in_telephone.getValue() != null && !this.in_telephone.getValue().equals("")) {
            if (!this.in_telephone.validate(msgList)) {
                this.in_telephone.setValue(null);
                msgList.add("\u300e <span class='em'>\u5185\u7dda\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            this.in_telephone.setValue("");
        }
        isNumber = true;
        if (this.cellular_phone.getValue() != null && !this.cellular_phone.getValue().equals("")) {
            String[] cell_tels = this.cellular_phone.getValue().split("-");
            if (cell_tels.length == 3) {
                for (i = 0; i < 3; ++i) {
                    tel.setValue(cell_tels[i]);
                    isNumber &= tel.validate(errmsg);
                }
                if (!isNumber || cell_tels[0].length() > 5 || cell_tels[1].length() > 4 || cell_tels[2].length() > 4) {
                    this.cellular_phone.setValue(null);
                    msgList.add("\u300e <span class='em'>\u643a\u5e2f\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                }
            } else {
                this.cellular_phone.setValue(null);
                msgList.add("\u300e <span class='em'>\u643a\u5e2f\u96fb\u8a71\u756a\u53f7</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            this.cellular_phone.setValue("");
        }
        if (this.cellular_mail.getValue() != null && !this.cellular_mail.getValue().equals("")) {
            if (!this.cellular_mail.validate(msgList)) {
                this.cellular_mail.setValue(null);
                msgList.add("\u300e <span class='em'>\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else if (this.cellular_mail.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.cellular_mail.getValue())) {
                this.cellular_mail.setValue(null);
                msgList.add("\u300e <span class='em'>\u643a\u5e2f\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else {
            this.cellular_mail.setValue("");
        }
        if (this.post_name.getValue() != null && !this.post_name.getValue().equals("")) {
            String[] st = this.post_name.toString().split("/");
            ArrayList<String> postCollection = new ArrayList<String>();
            for (int k = 0; k < st.length; ++k) {
                ALStringField post = new ALStringField(st[k]);
                if (!postCollection.contains(post.toString())) {
                    postCollection.add(post.toString());
                }
                if (post.validate(msgList)) {
                    if (st[k].equals("") || this.getEipMPost(post) != null) continue;
                    this.setPostNotFound(true);
                    msgList.add("<span class='em'>\u90e8\u7f72\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002</span>");
                    continue;
                }
                msgList.add("\u300e <span class='em'>\u90e8\u7f72\u540d</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
                this.post_name.setValue(null);
                break;
            }
            if (!this.post_name.toString().equals("") && this.post_name.toString() != null) {
                StringBuffer sb = new StringBuffer();
                for (int k = 0; k < postCollection.size(); ++k) {
                    if (k != 0) {
                        sb.append("/");
                    }
                    sb.append((String)postCollection.get(k));
                }
                this.post_name.setValue(sb.toString());
            }
        } else {
            this.post_name.setValue("");
        }
        if (this.position_name.getValue() != null && !this.position_name.getValue().equals("")) {
            if (!this.position_name.validate(msgList)) {
                this.position_name.setValue(null);
                msgList.add("\u300e <span class='em'>\u5f79\u8077\u540d</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            } else if (!this.position_name.toString().equals("") && this.getEipMPosition() == null) {
                this.setPositionNotFound(true);
                msgList.add("<span class='em'>\u5f79\u8077\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002</span>");
            }
        } else {
            this.position_name.setValue("");
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        boolean res = true;
        try {
            EipMPosition position;
            boolean isNewUser = false;
            ALBaseUser user = null;
            try {
                user = (ALBaseUser)JetspeedSecurity.getUser((String)this.getUserName().getValue());
                user.setUserName(JetspeedSecurity.convertUserName((String)this.username.getValue()));
                if (!this.password.getValue().equals(DEFAULT_VIEW_PASSWORD)) {
                    JetspeedSecurity.forcePassword((JetspeedUser)user, (String)this.password.getValue());
                }
                isNewUser = false;
            }
            catch (Exception e) {
                user = (ALBaseUser)JetspeedSecurity.getUserInstance();
                rundata.getParameters().setProperties((Object)user);
                user.setUserName(JetspeedSecurity.convertUserName((String)this.getUserName().getValue()));
                user.setPassword(this.password.getValue());
                isNewUser = true;
            }
            Date now = new Date();
            user.setCreated(now);
            user.setModified(now);
            user.setLastLogin(now);
            user.setCreatedUserId(ALEipUtils.getUserId((RunData)rundata));
            user.setUpdatedUserId(ALEipUtils.getUserId((RunData)rundata));
            user.setConfirmed("CONFIRMED");
            user.setDisabled(false);
            user.setPasswordChanged(now);
            user.setInTelephone(this.in_telephone.getValue());
            user.setOutTelephone(this.out_telephone.getValue());
            user.setCellularPhone(this.cellular_phone.getValue());
            user.setCellularMail(this.cellular_mail.getValue());
            user.setCompanyId(1);
            user.setPositionId(0);
            user.setPostId(0);
            user.setFirstName(this.getFirstName().getValue());
            user.setLastName(this.getLastName().getValue());
            user.setFirstNameKana(this.first_name_kana.getValue());
            user.setLastNameKana(this.last_name_kana.getValue());
            user.setEmail(this.getEmail().getValue());
            if (!this.position_name.getValue().equals("") && (position = this.getEipMPosition()) != null) {
                user.setPositionId(position.getPositionId().intValue());
            }
            if (!isNewUser) {
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery query2 = new SelectQuery(TurbineUserGroupRole.class);
                Expression exp2 = ExpressionFactory.matchExp((String)"turbineUser", (Object)user.getUserId());
                Expression exp3 = ExpressionFactory.noMatchExp((String)"turbineGroup", (Object)2);
                query2.setQualifier(exp2);
                query2.andQualifier(exp3);
                List list = dataContext.performQuery((Query)query2);
                TurbineUserGroupRole ugr = null;
                for (int i = 0; i < list.size(); ++i) {
                    ugr = (TurbineUserGroupRole)list.get(i);
                    dataContext.deleteObject((Persistent)ugr);
                }
                if (!this.post_name.toString().equals("") && this.post_name.toString() != null) {
                    String[] postnames = this.post_name.toString().split("/");
                    for (int i = 0; i < postnames.length; ++i) {
                        SelectQuery query = new SelectQuery(TurbineGroup.class);
                        Expression exp = ExpressionFactory.matchExp((String)"groupAliasName", (Object)postnames[i]);
                        query.setQualifier(exp);
                        List alist = dataContext.performQuery((Query)query);
                        JetspeedSecurity.joinGroup((String)user.getUserName(), (String)((TurbineGroup)alist.get(0)).getName());
                    }
                }
                JetspeedSecurity.saveUser((JetspeedUser)user);
            } else {
                SelectQuery query;
                int postid = 0;
                EipMPost post = this.getEipMPost(this.post_name);
                if (post != null) {
                    postid = post.getPostId();
                    user.setPostId(postid);
                }
                JetspeedSecurity.addUser((JetspeedUser)user);
                if (!this.post_name.toString().equals("") && this.post_name.toString() != null) {
                    String[] postnames = this.post_name.toString().split("/");
                    DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                    for (int i = 0; i < postnames.length; ++i) {
                        query = new SelectQuery(TurbineGroup.class);
                        Expression exp = ExpressionFactory.matchExp((String)"groupAliasName", (Object)postnames[i]);
                        query.setQualifier(exp);
                        List alist = dataContext.performQuery((Query)query);
                        JetspeedSecurity.joinGroup((String)user.getUserName(), (String)((TurbineGroup)alist.get(0)).getName());
                    }
                }
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                int userid = Integer.parseInt(user.getUserId());
                TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)dataContext, TurbineUser.class, (Object)userid);
                query = new SelectQuery(EipTAclRole.class);
                ArrayList<Integer> integerList = new ArrayList<Integer>(25);
                for (int i = 1; i < 26; ++i) {
                    integerList.add(i);
                }
                Expression exp = ExpressionFactory.inDbExp((String)"ROLE_ID", integerList);
                query.setQualifier(exp);
                List list = dataContext.performQuery((Query)query);
                for (int i = 0; i < 25; ++i) {
                    EipTAclUserRoleMap map = (EipTAclUserRoleMap)dataContext.createAndRegisterNewObject(EipTAclUserRoleMap.class);
                    map.setEipTAclRole((EipTAclRole)list.get(i));
                    map.setTurbineUser(tuser);
                }
                dataContext.commitChanges();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            res = false;
        }
        return res;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public ALStringField getCellularMail() {
        return this.cellular_mail;
    }

    public ALStringField getEmail() {
        return this.email;
    }

    public ALStringField getFirstNameKana() {
        return this.first_name_kana;
    }

    public ALStringField getFirstName() {
        return this.firstname;
    }

    public ALStringField getInTelephone() {
        return this.in_telephone;
    }

    public ALStringField getLastNameKana() {
        return this.last_name_kana;
    }

    public ALStringField getLastName() {
        return this.lastname;
    }

    public ALStringField getCellularPhone() {
        return this.cellular_phone;
    }

    public ALStringField getOutTelephone() {
        return this.out_telephone;
    }

    public ALStringField getPassword() {
        return this.password;
    }

    public ALStringField getUserName() {
        return this.username;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ArrayList getPostNameList() {
        return this.post_name_list;
    }

    public ALStringField getPositionName() {
        return this.position_name;
    }

    public boolean getPostNotFound() {
        return this.post_not_found;
    }

    public boolean getPositionNotFound() {
        return this.position_not_found;
    }

    public void setCellularMail(String str) {
        this.cellular_mail.setValue(str);
    }

    public void setEmail(String str) {
        this.email.setValue(str);
    }

    public void setFirstNameKana(String str) {
        this.first_name_kana.setValue(str);
    }

    public void setFirstName(String str) {
        this.firstname.setValue(str);
    }

    public void setLastNameKana(String str) {
        this.last_name_kana.setValue(str);
    }

    public void setLastName(String str) {
        this.lastname.setValue(str);
    }

    public void setCellularPhone(String str) {
        this.cellular_phone.setValue(str);
    }

    public void setPassword(String str) {
        this.password.setValue(str);
    }

    public void setUserName(String str) {
        this.username.setValue(str);
    }

    public void setPostName(String str) {
        this.post_name.setValue(str);
    }

    public void setPostNameList(ArrayList list) {
        this.post_name_list.addAll(list);
    }

    public void setPositionName(String str) {
        this.position_name.setValue(str);
    }

    public void setOutTelephone(String str) {
        this.out_telephone.setValue(str);
    }

    public void setInTelephone(String str) {
        this.in_telephone.setValue(str);
    }

    public void setPostNotFound(boolean flg) {
        this.post_not_found = flg;
    }

    public void setPositionNotFound(boolean flg) {
        this.position_not_found = flg;
    }

    private EipMPost getEipMPost(ALStringField post_name) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMPost.class);
        Expression exp = ExpressionFactory.matchExp((String)"postName", (Object)post_name);
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        EipMPost post = (EipMPost)list.get(0);
        return post;
    }

    private EipMPosition getEipMPosition() {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipMPosition.class);
        Expression exp = ExpressionFactory.matchExp((String)"positionName", (Object)this.position_name);
        query.setQualifier(exp);
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        EipMPosition position = (EipMPosition)list.get(0);
        return position;
    }

    public void addItemToken(String token, int i) {
        switch (i) {
            case -1: {
                break;
            }
            case 0: {
                try {
                    this.setUserName(token);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                this.setPassword(token);
                break;
            }
            case 2: {
                this.setLastName(token);
                break;
            }
            case 3: {
                this.setFirstName(token);
                break;
            }
            case 4: {
                this.setLastNameKana(token);
                break;
            }
            case 5: {
                this.setFirstNameKana(token);
                break;
            }
            case 6: {
                this.setEmail(token);
                break;
            }
            case 7: {
                this.setOutTelephone(token);
                break;
            }
            case 8: {
                this.setInTelephone(token);
                break;
            }
            case 9: {
                this.setCellularPhone(token);
                break;
            }
            case 10: {
                this.setCellularMail(token);
                break;
            }
            case 11: {
                this.setPostName(token);
                break;
            }
            case 12: {
                this.setPositionName(token);
                break;
            }
        }
    }

    private Map getAllUsersFromDB() {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        LinkedHashMap<String, TurbineUser> map = null;
        try {
            SelectQuery query = new SelectQuery(TurbineUser.class);
            List list = dataContext.performQuery((Query)query);
            map = new LinkedHashMap<String, TurbineUser>();
            TurbineUser user = null;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                user = (TurbineUser)list.get(i);
                map.put(user.getLoginName(), user);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[ALEipUtils]", (Throwable)ex);
        }
        return map;
    }
}

