/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.news;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.account.AipoLicense;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.license.util.LicenseUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NewsFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NewsFormData.class.getName());
    private ALStringField company_name;
    private ALStringField post_name;
    private ALStringField customer_name;
    private ALStringField email;
    private ALStringField email_confirm;
    private ALStringField content;
    private ALStringField key;
    private ALStringField user_num;
    private String aipo_version;
    private String latest_version;
    private String encoding = ALEipConstants.DEF_CONTENT_ENCODING;

    public void initField() {
        this.company_name = new ALStringField();
        this.company_name.setFieldName("\u5fa1\u793e\u540d");
        this.post_name = new ALStringField();
        this.post_name.setFieldName("\u90e8\u7f72\u540d");
        this.customer_name = new ALStringField();
        this.customer_name.setFieldName("\u3054\u62c5\u5f53\u8005\u540d");
        this.email = new ALStringField();
        this.email.setFieldName("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.email_confirm = new ALStringField();
        this.email_confirm.setFieldName("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\uff08\u78ba\u8a8d\u7528\uff09");
        this.content = new ALStringField();
        this.content.setFieldName("\u304a\u554f\u3044\u5408\u308f\u305b\u5185\u5bb9");
        this.key = new ALStringField();
        this.user_num = new ALStringField();
        this.aipo_version = "";
        this.latest_version = "";
        this.equalsVersion();
    }

    protected void setValidator() {
        this.company_name.limitMaxLength(200);
        this.post_name.limitMaxLength(200);
        this.customer_name.setNotNull(true);
        this.customer_name.limitMaxLength(200);
        this.email.setNotNull(true);
        this.email.setCharacterType(19);
        this.email.limitMaxLength(200);
        this.email_confirm.setNotNull(true);
        this.email_confirm.setCharacterType(19);
        this.email_confirm.limitMaxLength(200);
        this.content.setNotNull(true);
        this.content.limitMaxLength(400);
    }

    protected boolean validate(ArrayList msgList) {
        if (!this.company_name.validate(msgList)) {
            this.company_name.setValue(null);
        }
        if (!this.post_name.validate(msgList)) {
            this.post_name.setValue(null);
        }
        if (!this.customer_name.validate(msgList)) {
            this.customer_name.setValue(null);
        }
        if (!this.email.validate(msgList)) {
            this.email.setValue(null);
        }
        if (!this.email_confirm.validate(msgList)) {
            this.email_confirm.setValue(null);
        }
        if (!this.content.validate(msgList)) {
            this.content.setValue(null);
        }
        if (!this.email.toString().equals(this.email_confirm.toString())) {
            msgList.add("\u300e <span class='em'>\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3068\u300e <span class='em'>\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\uff08\u78ba\u8a8d\u7528\uff09</span> \u300f\u306b\u306f\u540c\u3058\u3082\u306e\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            this.email.setValue(null);
            this.email_confirm.setValue(null);
        } else if (!ALStringUtil.isCellPhoneMailAddress((String)this.email.toString())) {
            msgList.add("\u300e <span class='em'>\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9</span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        return msgList.size() == 0;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insertFormData(RunData rundata, Context context, ArrayList msglist) {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        BufferedWriter writer = null;
        boolean success = false;
        try {
            String inquire_url = "http://aipostyle.com/inquiry_support/form.cgi";
            URL url = new URL(inquire_url);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.connect();
            writer = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), this.encoding));
            StringBuffer sb = new StringBuffer();
            sb.append("company=" + this.company_name.toString() + "&");
            sb.append("position=" + this.post_name.toString() + "&");
            sb.append("realname=" + this.customer_name.toString() + "&");
            sb.append("email=" + this.email.toString() + "&");
            sb.append("email_confirm=" + this.email.toString() + "&");
            sb.append("licensekey=" + this.key.toString() + "&");
            sb.append("tel=00-0000-0000&");
            sb.append("user=" + this.user_num.toString() + "&");
            sb.append("contents=" + this.content.toString() + "&");
            sb.append("kind=index&");
            sb.append("action=thanks&");
            sb.append("Submit=\u9001\u4fe1\u3059\u308b");
            writer.write(sb.toString());
            writer.flush();
            writer.close();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), this.encoding));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!"success".equals(line)) continue;
                success = true;
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
            catch (IOException e) {
                logger.error((Object)"Exception", (Throwable)e);
                return false;
            }
        }
        return success;
    }

    private void equalsVersion() {
        String line = "";
        try {
            String url_str = JetspeedResources.getString((String)"aipo.version_url", (String)"");
            this.latest_version = this.aipo_version = JetspeedResources.getString((String)"aipo.version", (String)"");
            URL url = new URL(url_str);
            InputStream is = url.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader bur = new BufferedReader(isr);
            line = bur.readLine();
            if (line != null) {
                this.latest_version = line;
            }
            bur.close();
            isr.close();
            is.close();
        }
        catch (MalformedURLException e) {
            logger.error((Object)e);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e);
        }
        catch (SocketException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getLicense(RunData rundata, Context context) {
        AipoLicense al = LicenseUtils.getAipoLicense((RunData)rundata, (Context)context);
        if (al != null) {
            context.put("Key", (Object)al.getLicense());
        }
        SelectQuery query = new SelectQuery(TurbineUser.class);
        DataContext datacontext = DatabaseOrmService.getInstance().getDataContext();
        Expression exp = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.setQualifier(exp);
        List list = datacontext.performQuery((Query)query);
        context.put("UserNum", (Object)String.valueOf(list.size() - 2));
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALStringField getPostName() {
        return this.post_name;
    }

    public ALStringField getCustomerName() {
        return this.customer_name;
    }

    public ALStringField getEmail() {
        return this.email;
    }

    public ALStringField getEmailConfirm() {
        return this.email_confirm;
    }

    public ALStringField getContent() {
        return this.content;
    }

    public String getAipoVersion() {
        return this.aipo_version;
    }

    public String getLatestVersion() {
        return this.latest_version;
    }
}

