/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.fulcrum.util.parser.BaseValueParser;
import org.apache.fulcrum.util.parser.ValueParser;
import org.apache.log4j.Category;

public abstract class DataStreamParser
implements Iterator {
    private static final boolean DEBUG = false;
    private List columnNames;
    private StreamTokenizer tokenizer;
    private ValueParser lineValues;
    private boolean neverRead = true;
    private String characterEncoding;
    Category category = Category.getInstance((String)this.getClass().getName());

    public DataStreamParser(Reader reader, List list, String string) {
        this.columnNames = list;
        this.characterEncoding = string;
        if (this.characterEncoding == null) {
            this.characterEncoding = "US-ASCII";
            try {
                this.characterEncoding = ((InputStreamReader)reader).getEncoding();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.tokenizer = new StreamTokenizer(new BufferedReader(reader));
        this.initTokenizer(this.tokenizer);
    }

    protected abstract void initTokenizer(StreamTokenizer var1);

    public void setColumnNames(List list) {
        this.columnNames = list;
    }

    public void readColumnNames() throws IOException {
        this.columnNames = new ArrayList();
        this.neverRead = false;
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34) {
            this.columnNames.add(this.tokenizer.sval);
            this.tokenizer.nextToken();
        }
    }

    public boolean hasNextRow() throws IOException {
        if (this.neverRead || this.tokenizer.ttype == 10) {
            this.tokenizer.nextToken();
            this.tokenizer.pushBack();
            this.neverRead = false;
        }
        return this.tokenizer.ttype != -1;
    }

    public ValueParser nextRow() throws IOException, NoSuchElementException {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException();
        }
        if (this.lineValues == null) {
            this.lineValues = new BaseValueParser(this.characterEncoding);
        } else {
            this.lineValues.clear();
        }
        Iterator iterator = this.columnNames.iterator();
        this.tokenizer.nextToken();
        while (this.tokenizer.ttype == -3 || this.tokenizer.ttype == 34) {
            if (iterator.hasNext()) {
                String string = iterator.next().toString();
                String string2 = this.tokenizer.sval;
                this.lineValues.add(string, string2);
            }
            this.tokenizer.nextToken();
        }
        return this.lineValues;
    }

    public boolean hasNext() {
        boolean bl = false;
        try {
            bl = this.hasNextRow();
        }
        catch (IOException iOException) {
            this.category.error((Object)"IOException in CSVParser.hasNext", (Throwable)iOException);
        }
        return bl;
    }

    public Object next() throws NoSuchElementException {
        ValueParser valueParser = null;
        try {
            valueParser = this.nextRow();
        }
        catch (IOException iOException) {
            this.category.error((Object)"IOException in CSVParser.next", (Throwable)iOException);
            throw new NoSuchElementException();
        }
        return valueParser;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

