/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.pool.RecyclableSupport;
import org.apache.fulcrum.util.parser.ValueParser;

public class BaseValueParser
extends RecyclableSupport
implements ValueParser,
Recyclable {
    protected Hashtable parameters = new Hashtable();
    private String characterEncoding = "US-ASCII";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public String convertAndTrim(String string) {
        return this.convertAndTrim(string, "lower");
    }

    public String convertAndTrim(String string, String string2) {
        String string3 = string.trim();
        if ("lower".equals(string2)) {
            string3 = string3.toLowerCase();
        } else if ("upper".equals(string2)) {
            string3 = string3.toUpperCase();
        }
        return string3;
    }

    public BaseValueParser() {
    }

    public BaseValueParser(String string) {
        this.recycle(string);
    }

    public void recycle() {
        this.recycle("US-ASCII");
    }

    public void recycle(String string) {
        this.setCharacterEncoding(string);
        if (!this.isDisposed()) {
            super.recycle();
        }
    }

    public void dispose() {
        this.clear();
        super.dispose();
    }

    public void clear() {
        this.parameters.clear();
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void add(String string, double d) {
        this.add(string, Double.toString(d));
    }

    public void add(String string, int n) {
        this.add(string, Integer.toString(n));
    }

    public void add(String string, Integer n) {
        this.add(string, n.toString());
    }

    public void add(String string, long l) {
        this.add(string, Long.toString(l));
    }

    public void add(String string, String string2) {
        this.append(string, string2);
    }

    public void append(String string, String string2) {
        String[] stringArray = this.getStrings(string);
        if (stringArray == null) {
            stringArray = new String[]{string2};
            this.parameters.put(this.convert(string), stringArray);
        } else {
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string2;
            this.parameters.put(this.convert(string), stringArray2);
        }
    }

    public Object remove(String string) {
        return this.parameters.remove(this.convert(string));
    }

    public String convert(String string) {
        return this.convertAndTrim(string);
    }

    public boolean containsKey(Object object) {
        return this.parameters.containsKey(this.convert((String)object));
    }

    public Enumeration keys() {
        return this.parameters.keys();
    }

    public Object[] getKeys() {
        return this.parameters.keySet().toArray();
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        Object v = this.parameters.get(this.convert(string));
        if (v != null) {
            String string2 = this.getString(string);
            if (string2.equalsIgnoreCase("1") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on")) {
                bl2 = true;
            }
            if (string2.equalsIgnoreCase("0") || string2.equalsIgnoreCase("false") || string2.equalsIgnoreCase("off")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public Boolean getBool(String string, boolean bl) {
        return new Boolean(this.getBoolean(string, bl));
    }

    public Boolean getBool(String string) {
        return new Boolean(this.getBoolean(string, false));
    }

    public double getDouble(String string, double d) {
        double d2 = d;
        try {
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                d2 = Double.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d2;
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public float getFloat(String string, float f) {
        float f2 = f;
        try {
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                f2 = Float.valueOf(((String[])v)[0]).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f2;
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        try {
            String string2;
            Object v = this.parameters.get(this.convert(string));
            if (v != null && (string2 = ((String[])v)[0]).length() > 0) {
                bigDecimal2 = new BigDecimal(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bigDecimal2;
    }

    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(string, new BigDecimal(0.0));
    }

    public BigDecimal[] getBigDecimals(String string) {
        BigDecimal[] bigDecimalArray = null;
        String[] stringArray = this.getStrings(this.convert(string));
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            bigDecimalArray = new BigDecimal[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                bigDecimalArray[n] = new BigDecimal(stringArray2[n]);
                ++n;
            }
        }
        return bigDecimalArray;
    }

    public int getInt(String string, int n) {
        int n2 = n;
        try {
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                n2 = Integer.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public Integer getInteger(String string, int n) {
        return new Integer(this.getInt(string, n));
    }

    public Integer getInteger(String string, Integer n) {
        return new Integer(this.getInt(string, n));
    }

    public Integer getInteger(String string) {
        return new Integer(this.getInt(string, 0));
    }

    public int[] getInts(String string) {
        int[] nArray = null;
        String[] stringArray = this.getStrings(this.convert(string));
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            nArray = new int[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                nArray[n] = Integer.parseInt(stringArray2[n]);
                ++n;
            }
        }
        return nArray;
    }

    public Integer[] getIntegers(String string) {
        Integer[] integerArray = null;
        String[] stringArray = this.getStrings(this.convert(string));
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            integerArray = new Integer[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                integerArray[n] = Integer.valueOf(stringArray2[n]);
                ++n;
            }
        }
        return integerArray;
    }

    public long getLong(String string, long l) {
        long l2 = l;
        try {
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                l2 = Long.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public long[] getLongs(String string) {
        long[] lArray = null;
        String[] stringArray = this.getStrings(this.convert(string));
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            lArray = new long[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                lArray[n] = Long.parseLong(stringArray2[n]);
                ++n;
            }
        }
        return lArray;
    }

    public Long[] getLongObjects(String string) {
        Long[] longArray = null;
        String[] stringArray = this.getStrings(this.convert(string));
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            longArray = new Long[stringArray2.length];
            int n = 0;
            while (n < stringArray2.length) {
                longArray[n] = Long.valueOf(stringArray2[n]);
                ++n;
            }
        }
        return longArray;
    }

    public byte getByte(String string, byte by) {
        byte by2 = by;
        try {
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                by2 = Byte.valueOf(((String[])v)[0]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return by2;
    }

    public byte getByte(String string) {
        return this.getByte(string, (byte)0);
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        String string2 = this.getString(string);
        if (string2 != null) {
            return string2.getBytes(this.characterEncoding);
        }
        return null;
    }

    public String getString(String string) {
        try {
            String string2 = null;
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                string2 = ((String[])v)[0];
            }
            if (string2 == null || string2.equals("null")) {
                return null;
            }
            return string2;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public String get(String string) {
        return this.getString(string);
    }

    public String getString(String string, String string2) {
        String string3 = this.getString(string);
        if (string3 == null || string3.length() == 0 || string3.equals("null")) {
            return string2;
        }
        return string3;
    }

    public void setString(String string, String string2) {
        if (string2 != null) {
            this.parameters.put(this.convert(string), new String[]{string2});
        }
    }

    public String[] getStrings(String string) {
        String[] stringArray = null;
        Object v = this.parameters.get(this.convert(string));
        if (v != null) {
            stringArray = (String[])v;
        }
        return stringArray;
    }

    public String[] getStrings(String string, String[] stringArray) {
        String[] stringArray2 = this.getStrings(string);
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        return stringArray2;
    }

    public void setStrings(String string, String[] stringArray) {
        if (stringArray != null) {
            this.parameters.put(this.convert(string), stringArray);
        }
    }

    public Object getObject(String string) {
        try {
            Object object = null;
            Object v = this.parameters.get(this.convert(string));
            if (v != null) {
                object = ((Object[])v)[0];
            }
            return object;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Object[] getObjects(String string) {
        try {
            return (Object[])this.parameters.get(this.convert(string));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public Date getDate(String string, DateFormat dateFormat, Date date) {
        Date date2 = null;
        if (this.containsKey(string)) {
            try {
                dateFormat.setLenient(false);
                date2 = dateFormat.parse(this.getString(string));
            }
            catch (ParseException parseException) {
                date2 = date;
            }
        } else {
            date2 = date;
        }
        return date2;
    }

    public Date getDate(String string, DateFormat dateFormat) {
        return this.getDate(string, dateFormat, null);
    }

    public Date getDate(String string) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        return this.getDate(string, dateFormat, null);
    }

    public void setProperties(Object object) throws Exception {
        Class<?> clazz = object.getClass();
        PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        int n = 0;
        while (n < propertyDescriptorArray.length) {
            String string = propertyDescriptorArray[n].getName();
            Method method = propertyDescriptorArray[n].getWriteMethod();
            if (method != null && this.containsKey(string)) {
                this.setProperty(object, propertyDescriptorArray[n]);
            }
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.parameters.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                stringBuffer.append('{');
                stringBuffer.append(string);
                stringBuffer.append('=');
                String[] stringArray = this.getStrings(string);
                if (stringArray.length <= 1) {
                    stringBuffer.append(stringArray[0]);
                } else {
                    int n = 0;
                    while (n < stringArray.length) {
                        if (n != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append('[').append(stringArray[n]).append(']');
                        ++n;
                    }
                }
                stringBuffer.append("}\n");
            }
            catch (Exception exception) {
                try {
                    stringBuffer.append('{');
                    stringBuffer.append(string);
                    stringBuffer.append('=');
                    stringBuffer.append("ERROR?");
                    stringBuffer.append("}\n");
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return stringBuffer.toString();
    }

    private void setProperty(Object object, PropertyDescriptor propertyDescriptor) throws Exception {
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            throw new Exception(propertyDescriptor.getName() + " is an indexed property (not supported)");
        }
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new Exception(propertyDescriptor.getName() + " is a read only property");
        }
        Class<?> clazz = propertyDescriptor.getPropertyType();
        Object[] objectArray = new Object[]{null};
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = BaseValueParser.class$("java.lang.String")) : class$java$lang$String)) {
            objectArray[0] = this.getString(propertyDescriptor.getName());
        } else if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = BaseValueParser.class$("java.lang.Integer")) : class$java$lang$Integer) || clazz == Integer.TYPE) {
            objectArray[0] = this.getInteger(propertyDescriptor.getName());
        } else if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = BaseValueParser.class$("java.lang.Long")) : class$java$lang$Long) || clazz == Long.TYPE) {
            objectArray[0] = new Long(this.getLong(propertyDescriptor.getName()));
        } else if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BaseValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean) || clazz == Boolean.TYPE) {
            objectArray[0] = this.getBool(propertyDescriptor.getName());
        } else if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = BaseValueParser.class$("java.lang.Double")) : class$java$lang$Double) || clazz == Double.TYPE) {
            objectArray[0] = new Double(this.getDouble(propertyDescriptor.getName()));
        } else if (clazz == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BaseValueParser.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            objectArray[0] = this.getBigDecimal(propertyDescriptor.getName());
        } else if (clazz == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = BaseValueParser.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            objectArray[0] = this.getStrings(propertyDescriptor.getName());
        } else if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = BaseValueParser.class$("java.lang.Object")) : class$java$lang$Object)) {
            objectArray[0] = this.getObject(propertyDescriptor.getName());
        } else if (clazz == (array$I == null ? (array$I = BaseValueParser.class$("[I")) : array$I)) {
            objectArray[0] = this.getInts(propertyDescriptor.getName());
        } else if (clazz == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = BaseValueParser.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer)) {
            objectArray[0] = this.getIntegers(propertyDescriptor.getName());
        } else if (clazz == (class$java$util$Date == null ? (class$java$util$Date = BaseValueParser.class$("java.util.Date")) : class$java$util$Date)) {
            objectArray[0] = this.getDate(propertyDescriptor.getName());
        } else {
            throw new Exception("property " + propertyDescriptor.getName() + " is of unsupported type " + clazz.toString());
        }
        method.invoke(object, objectArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

