/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.xmlmodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.xml.sax.Attributes;

public class XmlGroup
implements Serializable {
    private List fields = new ArrayList();
    private List mapToObjects = new ArrayList(2);
    private String defaultMapToObject;
    private AppData parent;
    private String groupName;
    private String key;
    private String poolCapacity;

    public void loadFromXML(Attributes attributes) {
        this.groupName = attributes.getValue("name");
        this.key = attributes.getValue("key");
        this.poolCapacity = attributes.getValue("pool-capacity");
        String string = attributes.getValue("mapToObject");
        if (string != null && string.length() != 0) {
            this.defaultMapToObject = string;
        }
    }

    public String getName() {
        return this.groupName;
    }

    public void setName(String string) {
        this.groupName = string;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getPoolCapacity() {
        if (this.poolCapacity == null) {
            return "128";
        }
        return this.poolCapacity;
    }

    public XmlField addField(Attributes attributes) {
        XmlField xmlField = new XmlField();
        xmlField.loadFromXML(attributes);
        this.addField(xmlField);
        return xmlField;
    }

    public void addField(XmlField xmlField) {
        xmlField.setGroup(this);
        if (xmlField.getMapToObject() != null) {
            boolean bl = true;
            int n = 0;
            while (n < this.mapToObjects.size()) {
                if (this.mapToObjects.get(n).equals(xmlField.getMapToObject())) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.mapToObjects.add(xmlField.getMapToObject());
            }
        } else if (xmlField.getMapToProperty() != null && !"".equals(xmlField.getMapToProperty()) && this.defaultMapToObject != null) {
            xmlField.setMapToObject(this.defaultMapToObject);
        }
        this.fields.add(xmlField);
    }

    public List getFields() {
        return this.fields;
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public XmlField getField(String string) {
        Iterator iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            XmlField xmlField = (XmlField)iterator.next();
            String string2 = xmlField.getRawName();
            if (!string2.equals(string)) continue;
            return xmlField;
        }
        return null;
    }

    public boolean containsField(XmlField xmlField) {
        return this.fields.contains(xmlField);
    }

    public boolean containsField(String string) {
        return this.getField(string) != null;
    }

    public List getMapToObjects() {
        return this.mapToObjects;
    }

    public void setAppData(AppData appData) {
        this.parent = appData;
        if (this.defaultMapToObject != null) {
            this.defaultMapToObject = appData.getBasePackage() + this.defaultMapToObject;
            this.mapToObjects.add(this.defaultMapToObject);
        }
    }

    public AppData getAppData() {
        return this.parent;
    }

    public String getVariable() {
        String string = this.getName().substring(0, 1).toLowerCase();
        return string + this.getName().substring(1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<group name=\"").append(this.getName());
        stringBuffer.append(" key=\"" + this.key + "\"");
        stringBuffer.append(">\n");
        if (this.fields != null) {
            Iterator iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
        }
        stringBuffer.append("</group>\n");
        return stringBuffer.toString();
    }
}

