/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class TurbineGlobalCacheService
extends BaseService
implements GlobalCacheService,
Runnable {
    protected Hashtable cache = null;
    private static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    private long cacheCheckFrequency;

    public void init() throws InitializationException {
        this.cacheCheckFrequency = this.getConfiguration().getLong("cacheCheckFrequency", 5000L);
        try {
            this.cache = new Hashtable(20);
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
            this.setInit(true);
        }
        catch (Exception exception) {
            throw new InitializationException("TurbineGlobalCacheService failed to initialize", exception);
        }
    }

    public CachedObject getObject(String string) throws ObjectExpiredException {
        CachedObject cachedObject = null;
        boolean bl = false;
        cachedObject = (CachedObject)this.cache.get(string);
        if (cachedObject == null) {
            throw new ObjectExpiredException();
        }
        if (cachedObject.isStale()) {
            throw new ObjectExpiredException();
        }
        if (cachedObject instanceof RefreshableCachedObject) {
            RefreshableCachedObject refreshableCachedObject = (RefreshableCachedObject)cachedObject;
            refreshableCachedObject.touch();
        }
        return cachedObject;
    }

    public void addObject(String string, CachedObject cachedObject) {
        if (this.cache.containsKey(string)) {
            this.cache.remove(string);
        }
        this.cache.put(string, cachedObject);
    }

    public void removeObject(String string) {
        this.cache.remove(string);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.cacheCheckFrequency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.clearCache();
        }
    }

    public void clearCache() {
        RefreshableCachedObject refreshableCachedObject;
        CachedObject cachedObject;
        String string;
        Enumeration<Object> enumeration;
        Vector<String> vector = new Vector<String>(20);
        TurbineGlobalCacheService turbineGlobalCacheService = this;
        synchronized (turbineGlobalCacheService) {
            enumeration = this.cache.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                cachedObject = (CachedObject)this.cache.get(string);
                if (cachedObject instanceof RefreshableCachedObject) {
                    refreshableCachedObject = (RefreshableCachedObject)cachedObject;
                    if (refreshableCachedObject.isUntouched()) {
                        this.cache.remove(string);
                        continue;
                    }
                    if (!refreshableCachedObject.isStale()) continue;
                    vector.addElement(string);
                    continue;
                }
                if (!cachedObject.isStale()) continue;
                this.cache.remove(string);
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            cachedObject = (CachedObject)this.cache.get(string);
            refreshableCachedObject = (RefreshableCachedObject)cachedObject;
            refreshableCachedObject.refresh();
        }
    }

    public int getNumberOfObjects() {
        return this.cache.size();
    }

    public int getCacheSize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(this.cache);
        objectOutputStream.flush();
        int n = byteArrayOutputStream.toByteArray().length - 4;
        return n;
    }
}

