/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.util;

import java.util.Arrays;
import java.util.List;
import org.objectstyle.ashwood.function.DoubleFunction;

public class MedianUtils {
    private MedianUtils() {
    }

    public static double weightedMedianValue(Object object, Object object2, DoubleFunction doubleFunction) {
        return (doubleFunction.doubleValue(object) + doubleFunction.doubleValue(object2)) / 2.0;
    }

    public static double weightedMedianValue(List list, DoubleFunction doubleFunction) {
        double d;
        int n = list.size();
        switch (n) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return doubleFunction.doubleValue(list.get(0));
            }
            case 2: {
                return MedianUtils.weightedMedianValue(list.get(0), list.get(1), doubleFunction);
            }
        }
        int n2 = n / 2;
        double d2 = doubleFunction.doubleValue(list.get(n2));
        if (n % 2 == 1) {
            return d2;
        }
        int n3 = n2 - 1;
        double d3 = doubleFunction.doubleValue(list.get(n3));
        double d4 = doubleFunction.doubleValue(list.get(n - 1)) - d2;
        if (Math.abs(d4 - (d = d3 - doubleFunction.doubleValue(list.get(0)))) < 1.0E-6) {
            return (d3 + d2) / 2.0;
        }
        return (d3 * d4 + d2 * d) / (d + d4);
    }

    public static double weightedMedianValue(Object[] objectArray, DoubleFunction doubleFunction) {
        return MedianUtils.weightedMedianValue(Arrays.asList(objectArray), doubleFunction);
    }

    public static double weightedMedianValue(double[] dArray) {
        int n = dArray.length;
        switch (n) {
            case 0: {
                return Double.NaN;
            }
            case 1: {
                return dArray[0];
            }
            case 2: {
                return (dArray[0] + dArray[1]) / 2.0;
            }
        }
        int n2 = n / 2;
        double d = dArray[n2];
        if (n % 2 == 1) {
            return d;
        }
        double d2 = dArray[n - 1] - d;
        int n3 = n2 - 1;
        double d3 = dArray[n3];
        double d4 = d3 - dArray[0];
        if (Math.abs(d2 - d4) < 1.0E-6) {
            return (d3 + d) / 2.0;
        }
        return (d3 * d2 + d * d4) / (d4 + d2);
    }
}

