/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.util;

public final class IntPartition {
    private int[] partition;
    private int setCount;

    public IntPartition(int n) {
        this.partition = new int[n];
        this.reset();
    }

    public final int joinSets(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException("setId1=" + n + ", setId2=" + n2);
        }
        if (n == n2) {
            return n;
        }
        int n3 = this.partition[n];
        int n4 = this.partition[n2];
        --this.setCount;
        if (n4 < n3) {
            this.partition[n] = n2;
            return n2;
        }
        if (n4 == n3) {
            int n5 = n;
            this.partition[n5] = this.partition[n5] - 1;
        }
        this.partition[n2] = n;
        return n;
    }

    public final int findSetId(int n) {
        if (this.partition[n] < 0) {
            return n;
        }
        this.partition[n] = this.findSetId(this.partition[n]);
        return this.partition[n];
    }

    public final int size() {
        return this.partition.length;
    }

    public final int getSetCount() {
        return this.setCount;
    }

    public final void reset() {
        int n = 0;
        while (n < this.partition.length) {
            this.partition[n] = -1;
            ++n;
        }
        this.setCount = this.size();
    }

    public final boolean isSetId(int n) {
        return this.partition[n] < 0;
    }
}

