/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.ashwood.graph.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.objectstyle.ashwood.graph.layout.LayerVertex;

public class Layer
extends ArrayList {
    private int rank;

    public int getRank() {
        return this.rank;
    }

    public void setRank(int n) {
        this.rank = n;
    }

    public LayerVertex getVertex(int n) {
        return (LayerVertex)this.get(n);
    }

    public Object getUserVertex(int n) {
        return this.getVertex(n).getUserVertex();
    }

    public void sort() {
        Collections.sort(this, LayerVertex.LAYER_INDEX_COMPARATOR);
        boolean bl = this.checkIndices();
        if (!bl) {
            System.out.println("indices failed: rank=" + this.rank);
            int n = 0;
            while (n < this.size()) {
                LayerVertex layerVertex = this.getVertex(n);
                String string = layerVertex.getParentSubgraph() != null ? layerVertex.getParentSubgraph().getLabel() : "?";
                System.out.print(string + "." + layerVertex + "{" + layerVertex.getIndexInLayer() + "}, ");
                ++n;
            }
            System.out.println();
        }
    }

    public void sort(Comparator comparator) {
        Collections.sort(this, comparator);
        this.refreshIndices();
    }

    public void refreshIndices() {
        int n = 0;
        while (n < this.size()) {
            this.getVertex(n).setIndexInLayer(n);
            ++n;
        }
    }

    public boolean checkIndices() {
        int n = 0;
        while (n < this.size()) {
            if (this.getVertex(n).getIndexInLayer() != n) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean add(LayerVertex layerVertex) {
        layerVertex.setIndexInLayer(this.size());
        layerVertex.setRank(this.rank);
        return super.add(layerVertex);
    }

    public boolean add(Object object) {
        return this.add((LayerVertex)object);
    }

    public LayerVertex getLeft(LayerVertex layerVertex) {
        int n = layerVertex.getIndexInLayer();
        return n > 0 ? this.getVertex(n - 1) : null;
    }

    public LayerVertex getRight(LayerVertex layerVertex) {
        int n = layerVertex.getIndexInLayer();
        return n < this.size() - 1 ? this.getVertex(n + 1) : null;
    }

    public boolean isFirst(LayerVertex layerVertex) {
        return layerVertex.getIndexInLayer() == 0;
    }

    public boolean isLast(LayerVertex layerVertex) {
        return layerVertex.getIndexInLayer() == this.size() - 1;
    }
}

