/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataWrapper;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;

public class QueryChain
implements Query {
    protected Collection chain;
    protected String name;

    public QueryChain() {
    }

    public QueryChain(Query[] queries) {
        if (queries != null && queries.length > 0) {
            this.chain = new ArrayList<Query>(Arrays.asList(queries));
        }
    }

    public QueryChain(Collection queries) {
        if (queries != null && !queries.isEmpty()) {
            this.chain = new ArrayList(queries);
        }
    }

    public void addQuery(Query query) {
        if (this.chain == null) {
            this.chain = new ArrayList();
        }
        this.chain.add(query);
    }

    public boolean removeQuery(Query query) {
        return this.chain != null ? this.chain.remove(query) : false;
    }

    public boolean isEmpty() {
        return this.chain == null || this.chain.isEmpty();
    }

    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        if (this.chain != null && !this.chain.isEmpty()) {
            Iterator it = this.chain.iterator();
            while (it.hasNext()) {
                Query q = (Query)it.next();
                q.route(router, resolver, substitutedQuery);
            }
        }
    }

    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        throw new CayenneRuntimeException("Chain doesn't support its own execution and should've been split into separate queries during routing phase.");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        QueryMetadataWrapper wrapper = new QueryMetadataWrapper(DefaultQueryMetadata.defaultMetadata);
        wrapper.override("cayenne.GenericSelectQuery.fetchingDataRows", Boolean.TRUE);
        return wrapper;
    }

    public Object getRoot() {
        throw new CayenneRuntimeException("This deprecated method is not implemented");
    }

    public void setRoot(Object root) {
        throw new CayenneRuntimeException("This deprecated method is not implemented");
    }
}

