/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BaseQueryMetadata;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryMetadataWrapper;
import org.apache.cayenne.util.Util;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class NamedQuery
extends IndirectQuery {
    protected Map parameters;
    protected boolean forceNoCache;
    protected BaseQueryMetadata overrideMetadata;
    transient int hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NamedQuery(String name) {
        this(name, null);
    }

    public NamedQuery(String name, Map parameters) {
        this.name = name;
        if (parameters != null && !parameters.isEmpty()) {
            this.parameters = new HashMap(parameters);
        }
    }

    public NamedQuery(String name, String[] keys, Object[] values) {
        this.name = name;
        this.parameters = Util.toMap(keys, values);
    }

    public QueryMetadata getMetaData(EntityResolver resolver) {
        QueryMetadata base = this.overrideMetadata != null ? this.overrideMetadata : super.getMetaData(resolver);
        QueryMetadataWrapper wrapper = new QueryMetadataWrapper(base);
        if (this.forceNoCache) {
            String policy = base.getCachePolicy();
            if ("localcache".equals(policy)) {
                wrapper.override("cayenne.GenericSelectQuery.cachePolicy", "localcache_refresh");
            } else if ("sharedcache".equals(policy)) {
                wrapper.override("cayenne.GenericSelectQuery.cachePolicy", "sharedcache_refresh");
            }
        }
        if (this.parameters != null && !this.parameters.isEmpty() && this.replacementQuery instanceof NamedQuery && base.getCacheKey() != null) {
            StringBuffer buffer = new StringBuffer(this.name);
            if (this.parameters != null && !this.parameters.isEmpty()) {
                buffer.append(((Object)this.parameters).hashCode());
            }
            wrapper.override("QueryMetadataWrapper.CacheKey", buffer.toString());
        }
        return wrapper;
    }

    protected Query createReplacementQuery(EntityResolver resolver) {
        Query query = this.resolveQuery(resolver);
        if (query instanceof ParameterizedQuery) {
            query = ((ParameterizedQuery)query).createQuery(this.normalizedParameters());
        }
        return query;
    }

    Map normalizedParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap substitutes = new HashMap(this.parameters);
        Iterator it = this.parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value instanceof Persistent && !(value instanceof DataObject)) {
                value = ((Persistent)value).getObjectId();
            }
            substitutes.put(entry.getKey(), value);
        }
        return substitutes;
    }

    protected Query resolveQuery(EntityResolver resolver) {
        Query query = resolver.lookupQuery(this.getName());
        if (query == null) {
            throw new CayenneRuntimeException("Can't find named query for name '" + this.getName() + "'");
        }
        if (query == this) {
            throw new CayenneRuntimeException("Named query resolves to self: '" + this.getName() + "'");
        }
        return query;
    }

    public String toString() {
        return StringUtils.substringAfterLast(this.getClass().getName(), ".") + ":" + this.getName();
    }

    public void initMetadata(QueryMetadata metadata) {
        if (metadata != null) {
            this.overrideMetadata = new BaseQueryMetadata();
            this.overrideMetadata.copyFromInfo(metadata);
        } else {
            this.overrideMetadata = null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NamedQuery)) {
            return false;
        }
        NamedQuery query = (NamedQuery)object;
        if (!Util.nullSafeEquals(this.name, query.getName())) {
            return false;
        }
        if (query.parameters == null && this.parameters == null) {
            return true;
        }
        if (query.parameters == null || this.parameters == null) {
            return false;
        }
        if (query.parameters.size() != this.parameters.size()) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Iterator entries = this.parameters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Object entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (entryValue == null) {
                if (query.parameters.get(entryKey) == null && query.parameters.containsKey(entryKey)) continue;
                return false;
            }
            builder.append(entryValue, query.parameters.get(entryKey));
            if (builder.isEquals()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            HashCodeBuilder builder = new HashCodeBuilder(13, 17);
            if (this.name != null) {
                builder.append(this.name.hashCode());
            }
            if (this.parameters != null) {
                Object[] keys = this.parameters.keySet().toArray();
                Arrays.sort(keys);
                for (int i = 0; i < keys.length; ++i) {
                    builder.append(keys[i]).append(this.parameters.get(keys[i]));
                }
            }
            this.hashCode = builder.toHashCode();
            if (!$assertionsDisabled && this.hashCode == 0) {
                throw new AssertionError((Object)"Generated zero hashCode");
            }
        }
        return this.hashCode;
    }

    public boolean isForceNoCache() {
        return this.forceNoCache;
    }

    public void setForceNoCache(boolean forcingNoCache) {
        this.forceNoCache = forcingNoCache;
    }

    static {
        $assertionsDisabled = !NamedQuery.class.desiredAssertionStatus();
    }
}

