/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.property;

import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyAccessException;
import org.apache.cayenne.property.PropertyAccessor;
import org.apache.cayenne.property.PropertyVisitor;

public class SimpleProperty
implements Property {
    protected ClassDescriptor owner;
    protected PropertyAccessor accessor;
    final String name;

    public SimpleProperty(ClassDescriptor owner, PropertyAccessor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException("Null accessor");
        }
        this.accessor = accessor;
        this.owner = owner;
        this.name = accessor.getName();
    }

    public Object readProperty(Object object) throws PropertyAccessException {
        return this.readPropertyDirectly(object);
    }

    public void writeProperty(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        this.writePropertyDirectly(object, oldValue, newValue);
    }

    public String getName() {
        return this.name;
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitProperty(this);
    }

    public void injectValueHolder(Object object) throws PropertyAccessException {
    }

    public void shallowMerge(Object from, Object to) throws PropertyAccessException {
        this.writePropertyDirectly(to, this.accessor.readPropertyDirectly(to), this.accessor.readPropertyDirectly(from));
    }

    public Object readPropertyDirectly(Object object) throws PropertyAccessException {
        return this.accessor.readPropertyDirectly(object);
    }

    public void writePropertyDirectly(Object object, Object oldValue, Object newValue) throws PropertyAccessException {
        this.accessor.writePropertyDirectly(object, oldValue, newValue);
    }
}

