/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.property;

import org.apache.cayenne.property.ArcProperty;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyAccessor;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.cayenne.property.SimpleProperty;
import org.apache.cayenne.property.SingleObjectArcProperty;

public abstract class AbstractSingleObjectArcProperty
extends SimpleProperty
implements SingleObjectArcProperty {
    protected String complimentaryReverseArcName;
    protected ClassDescriptor targetDescriptor;

    public AbstractSingleObjectArcProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, PropertyAccessor accessor, String reverseName) {
        super(owner, accessor);
        this.targetDescriptor = targetDescriptor;
        this.complimentaryReverseArcName = reverseName;
    }

    public void setTarget(Object source, Object target, boolean setReverse) {
        Object oldTarget = this.readProperty(source);
        if (oldTarget == target) {
            return;
        }
        if (setReverse) {
            this.setReverse(source, oldTarget, target);
        }
        this.writeProperty(source, oldTarget, target);
    }

    protected void setReverse(final Object source, final Object oldTarget, final Object newTarget) {
        ArcProperty reverseArc = this.getComplimentaryReverseArc();
        if (reverseArc != null) {
            PropertyVisitor visitor;
            if (oldTarget != null) {
                visitor = new PropertyVisitor(){

                    public boolean visitCollectionArc(CollectionProperty property) {
                        property.removeTarget(oldTarget, source, false);
                        return false;
                    }

                    public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                        property.setTarget(oldTarget, null, false);
                        return false;
                    }

                    public boolean visitProperty(Property property) {
                        return false;
                    }
                };
                reverseArc.visit(visitor);
            }
            if (newTarget != null) {
                visitor = new PropertyVisitor(){

                    public boolean visitCollectionArc(CollectionProperty property) {
                        property.addTarget(newTarget, source, false);
                        return false;
                    }

                    public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                        property.setTarget(newTarget, source, false);
                        return false;
                    }

                    public boolean visitProperty(Property property) {
                        return false;
                    }
                };
                reverseArc.visit(visitor);
            }
        }
    }

    public boolean visit(PropertyVisitor visitor) {
        return visitor.visitSingleObjectArc(this);
    }

    public ArcProperty getComplimentaryReverseArc() {
        return (ArcProperty)this.targetDescriptor.getProperty(this.complimentaryReverseArcName);
    }

    public ClassDescriptor getTargetDescriptor() {
        return this.targetDescriptor;
    }

    public abstract boolean isFault(Object var1);
}

