/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.conf.ConfigStatus;
import org.apache.cayenne.project.ApplicationProject;
import org.apache.cayenne.project.DataMapProject;
import org.apache.cayenne.project.FlatProjectView;
import org.apache.cayenne.project.ProjectException;
import org.apache.cayenne.project.ProjectFile;
import org.apache.cayenne.project.ProjectPath;
import org.apache.cayenne.project.validator.Validator;
import org.apache.log4j.Logger;

public abstract class Project {
    private static final Logger logObj = Logger.getLogger(Project.class);
    public static final String CURRENT_PROJECT_VERSION = "2.0";
    static final int UPGRADE_STATUS_OLD = -1;
    static final int UPGRADE_STATUS_CURRENT = 0;
    static final int UPGRADE_STATUS_NEW = 1;
    protected File projectDir;
    protected List files = new ArrayList();
    protected int upgradeStatus;
    protected List upgradeMessages;
    protected boolean modified;

    public static Project createProject(File projectFile) {
        logObj.debug("createProject: " + projectFile);
        String fileName = projectFile.getName();
        if (fileName.endsWith("cayenne.xml")) {
            return new ApplicationProject(projectFile);
        }
        if (fileName.endsWith(".map.xml")) {
            return new DataMapProject(projectFile);
        }
        throw new ProjectException("Unsupported project file: " + projectFile);
    }

    protected Project() {
    }

    public Project(File projectFile) {
        this.initialize(projectFile);
        this.postInitialize(projectFile);
    }

    protected void initialize(File projectFile) {
        if (projectFile != null) {
            File parent = projectFile.getParentFile();
            if (parent == null) {
                parent = new File(System.getProperty("user.dir"));
            }
            if (!parent.isDirectory()) {
                throw new ProjectException("Project directory does not exist or is not a directory: " + parent);
            }
            try {
                this.projectDir = parent.getCanonicalFile();
            }
            catch (IOException e) {
                throw new ProjectException("Error creating project.", e);
            }
        }
    }

    protected void postInitialize(File projectFile) {
        logObj.debug("postInitialize with: " + projectFile);
        this.files = Collections.synchronizedList(this.buildFileList());
        this.upgradeMessages = Collections.synchronizedList(new ArrayList());
        this.checkForUpgrades();
    }

    public boolean isLocationUndefined() {
        return this.getMainFile() == null;
    }

    public boolean isUpgradeNeeded() {
        return this.upgradeStatus < 0;
    }

    public int getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public List getUpgradeMessages() {
        return this.upgradeMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRenamedFiles() {
        if (this.files == null) {
            return false;
        }
        List list = this.files;
        synchronized (list) {
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                if (!((ProjectFile)it.next()).isRenamed()) continue;
                return true;
            }
        }
        return false;
    }

    public List buildFileList() {
        ArrayList<ProjectFile> projectFiles = new ArrayList<ProjectFile>();
        Iterator nodes = this.treeNodes();
        while (nodes.hasNext()) {
            ProjectPath nodePath = (ProjectPath)nodes.next();
            Object obj = nodePath.getObject();
            ProjectFile f = this.projectFileForObject(obj);
            if (f == null) continue;
            projectFiles.add(f);
        }
        return projectFiles;
    }

    public Validator getValidator() {
        return new Validator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectFile findFile(Object obj) {
        if (obj == null) {
            return null;
        }
        List list = this.files;
        synchronized (list) {
            Iterator it = this.files.iterator();
            while (it.hasNext()) {
                ProjectFile file = (ProjectFile)it.next();
                if (file.getObject() != obj) continue;
                return file;
            }
        }
        return null;
    }

    public File resolveFile(String symbolicName) {
        try {
            if (File.separatorChar != '/') {
                symbolicName = symbolicName.replace('/', File.separatorChar);
            }
            return new File(this.projectDir, symbolicName).getCanonicalFile();
        }
        catch (IOException e) {
            logObj.info("Can't convert to canonical form.", e);
            return null;
        }
    }

    public String resolveSymbolicName(File file) {
        String symbolicName = null;
        try {
            String otherPath = file.getCanonicalFile().getPath();
            String thisPath = this.projectDir.getPath();
            if (otherPath.length() + 1 <= thisPath.length() || !otherPath.startsWith(thisPath)) {
                return null;
            }
            symbolicName = otherPath.substring(thisPath.length() + 1);
            if (symbolicName != null && File.separatorChar != '/') {
                symbolicName = symbolicName.replace(File.separatorChar, '/');
            }
            return symbolicName;
        }
        catch (IOException e) {
            logObj.info("Can't convert to canonical form.", e);
            return null;
        }
    }

    public File getProjectDirectory() {
        return this.projectDir;
    }

    public void setProjectDirectory(File dir) {
        this.projectDir = dir;
    }

    public File getMainFile() {
        if (this.projectDir == null) {
            return null;
        }
        ProjectFile f = this.projectFileForObject(this);
        return f != null ? this.resolveFile(f.getLocation()) : null;
    }

    public abstract ConfigStatus getLoadStatus();

    public abstract ProjectFile projectFileForObject(Object var1);

    public abstract List getChildren();

    public abstract void checkForUpgrades();

    public Iterator treeNodes() {
        return FlatProjectView.getInstance().flattenProjectTree(this).iterator();
    }

    public abstract void upgrade() throws ProjectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws ProjectException {
        if (this.isLocationUndefined()) {
            throw new ProjectException("Project location is undefined.");
        }
        ArrayList filesToSave = new ArrayList();
        ArrayList wrappedObjects = new ArrayList();
        this.prepareSave(filesToSave, wrappedObjects);
        this.processSave(filesToSave);
        ArrayList<File> savedFiles = new ArrayList<File>();
        Iterator saved = filesToSave.iterator();
        while (saved.hasNext()) {
            ProjectFile f = (ProjectFile)saved.next();
            savedFiles.add(f.saveCommit());
        }
        this.processDelete(wrappedObjects, savedFiles);
        List freshList = this.buildFileList();
        Iterator it = freshList.iterator();
        while (it.hasNext()) {
            ((ProjectFile)it.next()).synchronizeLocation();
        }
        this.files = freshList;
        List list = this.upgradeMessages;
        synchronized (list) {
            this.upgradeMessages.clear();
        }
        this.setModified(false);
    }

    protected void prepareSave(List filesToSave, List wrappedObjects) throws ProjectException {
        Iterator nodes = this.treeNodes();
        while (nodes.hasNext()) {
            ProjectPath nodePath = (ProjectPath)nodes.next();
            Object obj = nodePath.getObject();
            ProjectFile existingFile = this.findFile(obj);
            if (existingFile == null) {
                ProjectFile newFile = this.projectFileForObject(obj);
                if (newFile == null) continue;
                filesToSave.add(newFile);
                continue;
            }
            if (!existingFile.canHandleObject()) continue;
            wrappedObjects.add(existingFile.getObject());
            filesToSave.add(existingFile);
        }
    }

    protected void processSave(List modifiedFiles) throws ProjectException {
        Iterator willSave = modifiedFiles.iterator();
        while (willSave.hasNext()) {
            ProjectFile f = (ProjectFile)willSave.next();
            f.willSave();
        }
        try {
            Iterator modified = modifiedFiles.iterator();
            while (modified.hasNext()) {
                ProjectFile f = (ProjectFile)modified.next();
                if (logObj.isDebugEnabled()) {
                    logObj.info("Saving file " + f.resolveFile());
                }
                f.saveTemp();
            }
        }
        catch (Exception ex) {
            logObj.info("*** Project save failed, reverting.", ex);
            Iterator modified = modifiedFiles.iterator();
            while (modified.hasNext()) {
                ProjectFile f = (ProjectFile)modified.next();
                f.saveUndo();
            }
            throw new ProjectException("Project save failed and was canceled.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelete(List existingObjects, List savedFiles) {
        List list = this.files;
        synchronized (list) {
            Iterator oldFiles = this.files.iterator();
            while (oldFiles.hasNext()) {
                ProjectFile f = (ProjectFile)oldFiles.next();
                File file = f.resolveOldFile();
                if (file == null || savedFiles.contains(file)) continue;
                boolean delete = false;
                if (f.isRenamed()) {
                    delete = true;
                    logObj.info("File renamed, deleting old version: " + file);
                } else if (f.getObject() == null) {
                    delete = true;
                    logObj.info("Null internal object, deleting file: " + file);
                } else if (!existingObjects.contains(f.getObject())) {
                    delete = true;
                    logObj.info("Object deleted from the project, deleting file: " + file);
                } else if (!f.canHandleObject()) {
                    delete = true;
                    logObj.info("Can no longer handle the object, deleting file: " + file);
                }
                if (!delete || this.deleteFile(file)) continue;
                logObj.info("*** Failed to delete file, ignoring.");
            }
        }
    }

    protected boolean deleteFile(File f) {
        return f.exists() ? f.delete() : true;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

