/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.map.EntityDescriptor;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.ClassDescriptorFactory;

public class EntityDescriptorFactory
implements ClassDescriptorFactory {
    protected EntityResolver resolver;
    protected Map classDescriptors;

    public EntityDescriptorFactory(EntityResolver resolver) {
        this.resolver = resolver;
    }

    public ClassDescriptor getDescriptor(String entityName) {
        if (this.classDescriptors == null) {
            this.classDescriptors = new HashMap();
        } else {
            ClassDescriptor descriptor = (ClassDescriptor)this.classDescriptors.get(entityName);
            if (descriptor != null) {
                return descriptor;
            }
        }
        EntityDescriptor entityDescriptor = this.createDescriptor(entityName);
        if (entityDescriptor == null) {
            return null;
        }
        this.classDescriptors.put(entityName, entityDescriptor);
        entityDescriptor.compile(this.resolver);
        return entityDescriptor;
    }

    protected EntityDescriptor createDescriptor(String entityName) {
        ObjEntity entity = this.resolver.getObjEntity(entityName);
        if (entity == null) {
            return null;
        }
        String superEntityName = entity.getSuperEntityName();
        ClassDescriptor superDescriptor = superEntityName != null ? this.resolver.getClassDescriptor(superEntityName) : null;
        return new EntityDescriptor(entity, superDescriptor);
    }
}

