/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.property.ArcProperty;
import org.apache.cayenne.property.ClassDescriptor;
import org.apache.cayenne.property.CollectionProperty;
import org.apache.cayenne.property.Property;
import org.apache.cayenne.property.PropertyVisitor;
import org.apache.cayenne.property.SingleObjectArcProperty;

class CayenneContextGraphAction {
    CayenneContext context;
    ThreadLocal arcChangeInProcess;

    CayenneContextGraphAction(CayenneContext context) {
        this.context = context;
        this.arcChangeInProcess = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePropertyChange(Persistent object, String propertyName, Object oldValue, Object newValue) {
        ClassDescriptor descriptor = this.context.getEntityResolver().getClassDescriptor(object.getObjectId().getEntityName());
        Property property = descriptor.getProperty(propertyName);
        if (property instanceof ArcProperty) {
            try {
                this.handleArcPropertyChange(object, (ArcProperty)property, oldValue, newValue);
            }
            finally {
                this.setArcChangeInProcess(false);
            }
        } else {
            this.handleSimplePropertyChange(object, propertyName, oldValue, newValue);
        }
    }

    void handleArcPropertyChange(Persistent object, ArcProperty property, Object oldValue, Object newValue) {
        boolean arcChangeInProcess = this.isArchChangeInProcess();
        this.setArcChangeInProcess(true);
        if (oldValue instanceof Persistent) {
            this.context.getGraphManager().arcDeleted(object.getObjectId(), ((Persistent)oldValue).getObjectId(), property.getName());
            if (!arcChangeInProcess) {
                this.unsetReverse(property, object, (Persistent)oldValue);
            }
            this.markAsDirty(object);
        }
        if (newValue instanceof Persistent) {
            this.context.getGraphManager().arcCreated(object.getObjectId(), ((Persistent)newValue).getObjectId(), property.getName());
            if (!arcChangeInProcess) {
                this.setReverse(property, object, (Persistent)newValue);
            }
            this.markAsDirty(object);
        }
    }

    void handleSimplePropertyChange(Persistent object, String propertyName, Object oldValue, Object newValue) {
        this.context.getGraphManager().nodePropertyChanged(object.getObjectId(), propertyName, oldValue, newValue);
        this.markAsDirty(object);
    }

    boolean isArchChangeInProcess() {
        return this.arcChangeInProcess.get() != null;
    }

    void setArcChangeInProcess(boolean flag) {
        this.arcChangeInProcess.set(flag ? Boolean.TRUE : null);
    }

    private void markAsDirty(Persistent object) {
        if (object.getPersistenceState() == 3) {
            object.setPersistenceState(4);
        }
    }

    private void setReverse(ArcProperty property, final Persistent sourceObject, final Persistent targetObject) {
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.visit(new PropertyVisitor(){

                public boolean visitCollectionArc(CollectionProperty property) {
                    property.addTarget(targetObject, sourceObject, false);
                    return false;
                }

                public boolean visitSingleObjectArc(SingleObjectArcProperty property) {
                    property.setTarget(targetObject, sourceObject, false);
                    return false;
                }

                public boolean visitProperty(Property property) {
                    return false;
                }
            });
            this.context.getGraphManager().arcCreated(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            this.markAsDirty(targetObject);
        }
    }

    private void unsetReverse(ArcProperty property, Persistent sourceObject, Persistent targetObject) {
        ArcProperty reverseArc = property.getComplimentaryReverseArc();
        if (reverseArc != null) {
            reverseArc.writePropertyDirectly(targetObject, sourceObject, null);
            this.context.getGraphManager().arcDeleted(targetObject.getObjectId(), sourceObject.getObjectId(), reverseArc.getName());
            this.markAsDirty(targetObject);
        }
    }
}

