/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.io;

import com.sk_jp.io.UnicodeCorrector;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class UnicodeCorrectWriter
extends FilterWriter {
    private UnicodeCorrector corrector;

    public UnicodeCorrectWriter(Writer writer, String string) throws UnsupportedEncodingException {
        super(writer);
        this.corrector = UnicodeCorrector.getInstance(string);
    }

    public UnicodeCorrectWriter(Writer writer) {
        super(writer);
        try {
            this.corrector = UnicodeCorrector.getInstance(System.getProperty("file.encoding"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public void write(int n) throws IOException {
        char[] cArray = new char[]{(char)n};
        this.write(cArray, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        char[] cArray2 = this.corrector.correct(cArray, n, n2);
        super.write(cArray2, 0, cArray2.length);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }
}

