/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.category.util;

import com.aimluck.eip.category.beans.CommonCategoryLiteBean;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CommonCategoryUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CommonCategoryUtils.class.getName());

    public static EipTCommonCategory getEipTCommonCategory(DataContext dataContext, Long category_id) {
        try {
            SelectQuery query = new SelectQuery(EipTCommonCategory.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"COMMON_CATEGORY_ID", (Object)category_id);
            query.setQualifier(exp);
            List result = dataContext.performQuery((Query)query);
            if (result == null || result.size() == 0) {
                logger.debug((Object)"[CommonCategoryUtils] Not found ID...");
                return null;
            }
            return (EipTCommonCategory)result.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTCommonCategory getEipTCommonCategory(RunData rundata, Context context) {
        String category_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (category_id == null || Integer.valueOf(category_id) == null) {
                logger.debug((Object)"[CommonCategoryUtils] Empty ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            return CommonCategoryUtils.getEipTCommonCategory(dataContext, Long.valueOf(category_id));
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getCommonCategoryLiteBeans(RunData rundata) {
        ArrayList<CommonCategoryLiteBean> list = new ArrayList<CommonCategoryLiteBean>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTCommonCategory.class);
            Expression exp = ExpressionFactory.noMatchDbExp((String)"COMMON_CATEGORY_ID", (Object)1);
            query.setQualifier(exp);
            query.addOrdering("name", true);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTCommonCategory record = (EipTCommonCategory)aList.get(i);
                CommonCategoryLiteBean bean = new CommonCategoryLiteBean();
                bean.initField();
                bean.setCategoryId(record.getCommonCategoryId().longValue());
                bean.setCategoryName(record.getName());
                list.add(bean);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return list;
    }

    public static boolean CheckPermission(RunData rundata, Context context, int defineAclType, String pfeature) {
        if (defineAclType == 0) {
            return true;
        }
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        return hasAuthority;
    }
}

