/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.category;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.category.CommonCategoryResultData;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CommonCategorySelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CommonCategorySelectData.class.getName());
    private int uid;
    private boolean authority_edit;
    private boolean authority_delete;
    private boolean authority_list;
    private boolean authority_detail;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.authority_list = CommonCategoryUtils.CheckPermission(rundata, context, 1, "manhour_common_category_other");
        this.authority_detail = CommonCategoryUtils.CheckPermission(rundata, context, 2, "manhour_common_category_other");
        this.authority_edit = CommonCategoryUtils.CheckPermission(rundata, context, 8, "manhour_common_category_other");
        this.authority_delete = CommonCategoryUtils.CheckPermission(rundata, context, 16, "manhour_common_category_other");
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTCommonCategory.class);
        Expression exp = ExpressionFactory.noMatchDbExp((String)"COMMON_CATEGORY_ID", (Object)1);
        query.setQualifier(exp);
        if (!this.authority_list) {
            Expression exp2 = ExpressionFactory.matchExp((String)"createUserId", (Object)this.uid);
            query.andQualifier(exp2);
        }
        return query;
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return CommonCategoryUtils.getEipTCommonCategory(rundata, context);
    }

    protected Object getResultData(Object obj) {
        EipTCommonCategory record = (EipTCommonCategory)obj;
        CommonCategoryResultData rd = new CommonCategoryResultData();
        rd.initField();
        rd.setCommonCategoryId(record.getCommonCategoryId().longValue());
        rd.setName(ALCommonUtils.compressString((String)record.getName(), (int)this.getStrLength()));
        rd.setCreateUserId(record.getCreateUserId().longValue());
        return rd;
    }

    protected Object getResultDataDetail(Object obj) {
        EipTCommonCategory record = (EipTCommonCategory)obj;
        CommonCategoryResultData rd = new CommonCategoryResultData();
        rd.initField();
        rd.setCommonCategoryId(record.getCommonCategoryId().longValue());
        rd.setName(record.getName());
        rd.setNote(record.getNote());
        rd.setCreateUserId(record.getCreateUserId().intValue());
        rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
        return rd;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("name", "name");
        return map;
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public boolean getAuthorityEdit() {
        return this.authority_edit;
    }

    public boolean getAuthorityDelete() {
        return this.authority_delete;
    }

    public boolean getAuthorityList() {
        return this.authority_list;
    }

    public boolean getAuthorityDetail() {
        return this.authority_detail;
    }

    public String getAclPortletFeature() {
        return "manhour_common_category";
    }
}

