/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.category;

import com.aimluck.eip.category.CommonCategorySelectData;
import com.aimluck.eip.category.util.CommonCategoryUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTCommonCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTScheduleMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class CommonCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)CommonCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            int loginuserid = ALEipUtils.getUserId((RunData)rundata);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            boolean hasAuthorityOtherDelete = aclhandler.hasAuthority(loginuserid, "manhour_common_category_other", 16);
            SelectQuery query = new SelectQuery(EipTCommonCategory.class);
            if (!hasAuthorityOtherDelete) {
                Expression exp1 = ExpressionFactory.matchExp((String)"createUserId", (Object)loginuserid);
                query.setQualifier(exp1);
            }
            Expression exp2 = ExpressionFactory.inDbExp((String)"COMMON_CATEGORY_ID", (Collection)values);
            query.andQualifier(exp2);
            List categorylist = dataContext.performQuery((Query)query);
            if (categorylist == null || categorylist.size() == 0) {
                return false;
            }
            EipTCommonCategory tmpCategory = CommonCategoryUtils.getEipTCommonCategory(dataContext, 1L);
            EipTScheduleMap record = null;
            EipTCommonCategory category = null;
            int size = categorylist.size();
            for (int i = 0; i < size; ++i) {
                category = (EipTCommonCategory)categorylist.get(i);
                List result = ALEipUtils.getObjectModels((DataContext)dataContext, EipTScheduleMap.class, (String)"commonCategoryId", (Integer)category.getCommonCategoryId(), (boolean)false);
                if (result == null || result.size() <= 0) continue;
                int size2 = result.size();
                for (int j = 0; j < size2; ++j) {
                    record = (EipTScheduleMap)result.get(j);
                    record.setEipTCommonCategory(tmpCategory);
                }
            }
            dataContext.deleteObjects((Collection)categorylist);
            dataContext.commitChanges();
            String filtername = CommonCategorySelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "manhour_common_category";
    }
}

