/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.user.util;

import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALEipGroup;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipPost;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.user.beans.UserEmailLiteBean;
import com.aimluck.eip.user.beans.UserGroupLiteBean;
import com.aimluck.eip.user.beans.UserLiteBean;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class UserUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)UserUtils.class.getName());

    public static List getUserLiteBeansFromGroup(RunData rundata, String groupname, boolean includeLoginuser) {
        ArrayList<UserLiteBean> list = new ArrayList<UserLiteBean>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        if (!includeLoginuser) {
            statement.append(" AND B.USER_ID <> " + ALEipUtils.getUserId((RunData)rundata));
        }
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
        rawSelect.setFetchingDataRows(true);
        List ulist = dataContext.performQuery((Query)rawSelect);
        int recNum = ulist.size();
        for (int j = 0; j < recNum; ++j) {
            DataRow dataRow = (DataRow)ulist.get(j);
            UserLiteBean user = new UserLiteBean();
            user.initField();
            user.setUserId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"USER_ID"));
            user.setName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LOGIN_NAME"));
            user.setAliasName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"));
            list.add(user);
        }
        return list;
    }

    public static List getUserEmailLiteBeansFromGroup(RunData rundata, String groupname, boolean includeLoginuser) {
        ArrayList<UserEmailLiteBean> list = new ArrayList<UserEmailLiteBean>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT DISTINCT ");
        statement.append("  B.USER_ID, B.LOGIN_NAME, B.FIRST_NAME, B.LAST_NAME, B.EMAIL, D.POSITION ");
        statement.append("FROM TURBINE_USER_GROUP_ROLE as A ");
        statement.append("LEFT JOIN TURBINE_USER as B ");
        statement.append("  on A.USER_ID = B.USER_ID ");
        statement.append("LEFT JOIN TURBINE_GROUP as C ");
        statement.append("  on A.GROUP_ID = C.GROUP_ID ");
        statement.append("LEFT JOIN EIP_M_USER_POSITION as D ");
        statement.append("  on A.USER_ID = D.USER_ID ");
        statement.append("WHERE B.USER_ID > 3 AND B.DISABLED = 'F'");
        if (!includeLoginuser) {
            statement.append(" AND B.USER_ID <> " + ALEipUtils.getUserId((RunData)rundata));
        }
        statement.append(" AND C.GROUP_NAME = '").append(groupname).append("' ");
        statement.append("ORDER BY D.POSITION");
        String query = statement.toString();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SQLTemplate rawSelect = new SQLTemplate(TurbineUser.class, query, true);
        rawSelect.setFetchingDataRows(true);
        List ulist = dataContext.performQuery((Query)rawSelect);
        int recNum = ulist.size();
        for (int j = 0; j < recNum; ++j) {
            DataRow dataRow = (DataRow)ulist.get(j);
            UserEmailLiteBean user = new UserEmailLiteBean();
            user.initField();
            user.setUserId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"USER_ID"));
            user.setName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LOGIN_NAME"));
            user.setAliasName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"));
            user.setEmail((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"EMAIL"));
            list.add(user);
        }
        return list;
    }

    public static List getUserGroupLiteBeans(RunData rundata, boolean isMygroup, boolean isPost) {
        ArrayList<UserGroupLiteBean> list = new ArrayList<UserGroupLiteBean>();
        try {
            UserGroupLiteBean bean;
            if (isMygroup) {
                List mygroup = ALEipUtils.getMyGroups((RunData)rundata);
                int size1 = mygroup.size();
                for (int i = 0; i < size1; ++i) {
                    ALEipGroup group = (ALEipGroup)mygroup.get(i);
                    bean = new UserGroupLiteBean();
                    bean.initField();
                    bean.setGroupId(group.getName().getValue());
                    bean.setName(group.getAliasName().getValue());
                    list.add(bean);
                }
            }
            if (isPost) {
                Map postmap = ALEipManager.getInstance().getPostMap();
                for (ALEipPost post : postmap.values()) {
                    bean = new UserGroupLiteBean();
                    bean.initField();
                    bean.setGroupId(post.getGroupName().getValue());
                    bean.setName(post.getPostName().getValue());
                    list.add(bean);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"[UserUtils]", (Throwable)e);
        }
        return list;
    }
}

