/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard.util;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.msgboard.MsgboardCategoryResultData;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardUtils.class.getName());
    public static final String OWNER_ID = "ownerid";
    private static final String FOLDER_FILEDIR_MSGBOARD = JetspeedResources.getString((String)"aipo.filedir", (String)"");
    public static final int ACCESS_PUBLIC_ALL = 0;
    public static final int ACCESS_PUBLIC_MEMBER = 1;
    public static final int ACCESS_SEACRET_MEMBER = 2;
    public static final int ACCESS_SEACRET_SELF = 3;
    public static final String PUBLIC_FLG_VALUE_PUBLIC = "T";
    public static final String PUBLIC_FLG_VALUE_NONPUBLIC = "F";
    public static final String STAT_VALUE_OWNER = "O";
    public static final String STAT_VALUE_SHARE = "S";
    public static final String STAT_VALUE_ALL = "A";

    public static EipTMsgboardTopic getEipTMsgboardParentTopic(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
            query.andQualifier(exp2);
            Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp13 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.userId", (Object)userid);
            query.andQualifier(exp11.orExp(exp12.andExp(exp13)));
            query.setDistinct(true);
            List topics = dataContext.performQuery((Query)query);
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            EipTMsgboardTopic topic = (EipTMsgboardTopic)topics.get(0);
            return topic;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTMsgboardTopic getEipTMsgboardTopicReply(RunData rundata, Context context, String topicid, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List topics = dataContext.performQuery((Query)query);
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMsgboardTopic)topics.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTMsgboardFile getEipTMsgboardFile(RunData rundata) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int attachmentIndex = rundata.getParameters().getInt("attachmentIndex", -1);
            if (attachmentIndex < 0) {
                logger.debug((Object)"[MsgboardUtils] Empty ID...");
                throw new ALPageNotFoundException();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardFile.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"FILE_ID", (Object)attachmentIndex);
            query.andQualifier(exp);
            List files = dataContext.performQuery((Query)query);
            if (files == null || files.size() == 0) {
                logger.debug((Object)"[MsgboardUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMsgboardFile)files.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List getEipTMsgboardTopicList(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
            Expression exp001 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(topicid));
            Expression exp01 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp21 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp22 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp01.andExp(exp11.orExp(exp21.andExp(exp22))).orExp(exp001));
            query.setDistinct(true);
            List topics = dataContext.performQuery((Query)query);
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List getEipTMsgboardTopicListToDeleteTopic(RunData rundata, Context context, boolean isJoin) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (topicid == null || Integer.valueOf(topicid) == null) {
                logger.debug((Object)"[MsgboardTopic] Empty ID...");
                throw new ALPageNotFoundException();
            }
            int userid = ALEipUtils.getUserId((RunData)rundata);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
            Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)userid);
            Expression exp02 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(topicid));
            Expression exp03 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(topicid));
            query.andQualifier(exp01.andExp(exp02).orExp(exp03));
            List topics = dataContext.performQuery((Query)query);
            if (topics == null || topics.size() == 0) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            boolean isdelete = false;
            int size = topics.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardTopic topic = (EipTMsgboardTopic)topics.get(i);
                if (topic.getOwnerId() != userid) continue;
                isdelete = true;
                break;
            }
            if (!isdelete) {
                logger.debug((Object)"[MsgboardTopic] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return topics;
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static EipTMsgboardCategory getEipTMsgboardCategory(RunData rundata, Context context, boolean ownerOnly) throws ALPageNotFoundException, ALDBErrorException {
        String categoryid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (categoryid == null || Integer.valueOf(categoryid) == null) {
                logger.debug((Object)"[MsgboardCategory] Empty ID...");
                throw new ALPageNotFoundException();
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardCategory.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"CATEGORY_ID", (Object)Integer.valueOf(categoryid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.noMatchDbExp((String)"turbineUser.USER_ID", (Object)0);
            query.andQualifier(exp2);
            if (ownerOnly) {
                // empty if block
            }
            int loginUserId = ALEipUtils.getUserId((RunData)rundata);
            ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
            ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
            boolean hasAclviewOther = aclhandler.hasAuthority(loginUserId, "msgboard_category_other", 1);
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp02 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_OWNER);
            Expression exp03 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_ALL);
            Expression exp11 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.userId", (Object)loginUserId);
            if (!hasAclviewOther) {
                query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
            } else {
                query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp02.orExp(exp03))));
            }
            query.setDistinct(true);
            List categories = dataContext.performQuery((Query)query);
            if (categories == null || categories.size() == 0) {
                logger.debug((Object)"[MsgboardUtils] Not found ID...");
                throw new ALPageNotFoundException();
            }
            return (EipTMsgboardCategory)categories.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public static List getWhatsNewInsertList(RunData rundata, int categoryid, String is_public) throws ALPageNotFoundException, ALDBErrorException {
        int userid = ALEipUtils.getUserId((RunData)rundata);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        ArrayList<ALEipUser> result = new ArrayList<ALEipUser>();
        if (PUBLIC_FLG_VALUE_NONPUBLIC.equals(is_public)) {
            try {
                SelectQuery query = new SelectQuery(EipTMsgboardCategoryMap.class);
                query.addCustomDbAttribute("USER_ID");
                Expression exp1 = ExpressionFactory.matchExp((String)"categoryId", (Object)categoryid);
                query.setQualifier(exp1);
                Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
                Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
                Expression exp13 = ExpressionFactory.matchExp((String)"status", (Object)STAT_VALUE_SHARE);
                query.andQualifier(exp11.orExp(exp12.andExp(exp13)));
                query.setDistinct(true);
                List uids = dataContext.performQuery((Query)query);
                if (uids != null && uids.size() != 0) {
                    int size = uids.size();
                    for (int i = 0; i < size; ++i) {
                        DataRow uid = (DataRow)uids.get(i);
                        Integer id = (Integer)ALEipUtils.getObjFromDataRow((DataRow)uid, (String)"USER_ID");
                        if (id == userid) continue;
                        result.add(ALEipUtils.getALEipUser((int)id));
                    }
                }
                ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
                ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
                List userIds = aclhandler.getAcceptUserIdsInListExceptLoginUser(dataContext, ALEipUtils.getUserId((RunData)rundata), "msgboard_topic", 2, result);
                return userIds;
            }
            catch (Exception ex) {
                logger.error((Object)"[MsgboardUtils]", (Throwable)ex);
                throw new ALDBErrorException();
            }
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        List userIds = aclhandler.getAcceptUserIdsExceptLoginUser(dataContext, ALEipUtils.getUserId((RunData)rundata), "msgboard_topic", 2);
        return userIds;
    }

    public static ArrayList loadCategoryList(RunData rundata) {
        ArrayList<MsgboardCategoryResultData> categoryList = new ArrayList<MsgboardCategoryResultData>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardCategory.class);
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_PUBLIC);
            Expression exp02 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_OWNER);
            Expression exp03 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.status", (Object)STAT_VALUE_ALL);
            Expression exp11 = ExpressionFactory.matchExp((String)"publicFlag", (Object)PUBLIC_FLG_VALUE_NONPUBLIC);
            Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategoryMaps.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
            query.setDistinct(true);
            MsgboardCategoryResultData otherRd = null;
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardCategory record = (EipTMsgboardCategory)aList.get(i);
                MsgboardCategoryResultData rd = new MsgboardCategoryResultData();
                rd.initField();
                rd.setCategoryId(record.getCategoryId().longValue());
                rd.setCategoryName(record.getCategoryName());
                if (record.getCategoryId().longValue() == 1L) {
                    otherRd = rd;
                    continue;
                }
                categoryList.add(rd);
            }
            if (otherRd != null) {
                categoryList.add(otherRd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return categoryList;
    }

    public static boolean insertFileDataDelegate(RunData rundata, Context context, EipTMsgboardTopic topic, List fileuploadList, String folderName, ArrayList msgList) {
        if (fileuploadList == null || fileuploadList.size() <= 0) {
            return true;
        }
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        int uid = ALEipUtils.getUserId((RunData)rundata);
        String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        try {
            FileuploadLiteBean filebean = null;
            int size = fileuploadList.size();
            for (int i = 0; i < size; ++i) {
                filebean = (FileuploadLiteBean)fileuploadList.get(i);
                String[] acceptExts = ImageIO.getWriterFormatNames();
                byte[] fileThumbnail = FileuploadUtils.getBytesShrinkFilebean((String)org_id, (String)folderName, (int)uid, (FileuploadLiteBean)filebean, (String[])acceptExts, (int)86, (int)86, (ArrayList)msgList);
                String filename = FileuploadUtils.getNewFileName((String)MsgboardUtils.getSaveDirPath(org_id, uid));
                EipTMsgboardFile file = (EipTMsgboardFile)dataContext.createAndRegisterNewObject(EipTMsgboardFile.class);
                file.setOwnerId(Integer.valueOf(uid));
                file.setEipTMsgboardTopic(topic);
                file.setFileName(filebean.getFileName());
                file.setFilePath(MsgboardUtils.getRelativePath(filename));
                if (fileThumbnail != null) {
                    file.setFileThumbnail(fileThumbnail);
                }
                file.setCreateDate(Calendar.getInstance().getTime());
                file.setUpdateDate(Calendar.getInstance().getTime());
                File srcFile = FileuploadUtils.getAbsolutePath((String)org_id, (int)uid, (String)folderName, (int)filebean.getFileId());
                File destFile = new File(MsgboardUtils.getAbsolutePath(org_id, uid, filename));
                FileuploadUtils.copyFile((File)srcFile, (File)destFile);
                srcFile = null;
                destFile = null;
            }
            File folder = FileuploadUtils.getFolder((String)org_id, (int)uid, (String)folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getSaveDirPath(String orgId, int uid) {
        return FOLDER_FILEDIR_MSGBOARD + File.separator + orgId + File.separator + "msgboard" + File.separator + uid;
    }

    public static String getRelativePath(String fileName) {
        return new StringBuffer().append("/").append(fileName).toString();
    }

    public static String getAbsolutePath(String orgId, int uid, String fileName) {
        StringBuffer sb = new StringBuffer().append(FOLDER_FILEDIR_MSGBOARD).append(File.separator).append(orgId).append(File.separator).append("msgboard").append(File.separator).append(uid);
        File f = new File(sb.toString());
        if (!f.exists()) {
            f.mkdirs();
        }
        return sb.append(File.separator).append(fileName).toString();
    }

    public static void shiftWhatsNewReadFlag(RunData rundata, int entityid) {
        int uid = ALEipUtils.getUserId((RunData)rundata);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
        Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)entityid);
        query.setQualifier(exp);
        query.addCustomDbAttribute("TOPIC_ID");
        query.setDistinct(true);
        List topics = dataContext.performQuery((Query)query);
        if (topics != null) {
            int size = topics.size();
            DataRow dataRow = null;
            Integer _id = null;
            for (int i = 0; i < size; ++i) {
                dataRow = (DataRow)topics.get(i);
                _id = (Integer)dataRow.get((Object)"TOPIC_ID");
                WhatsNewUtils.shiftWhatsNewReadFlag((int)4, (int)_id, (int)uid);
            }
        }
        WhatsNewUtils.shiftWhatsNewReadFlag((int)4, (int)entityid, (int)uid);
    }

    public static boolean CheckPermission(RunData rundata, Context context, int defineAclType, String pfeature) {
        if (defineAclType == 0) {
            return true;
        }
        if (pfeature == null || "".equals(pfeature)) {
            return true;
        }
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        boolean hasAuthority = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), pfeature, defineAclType);
        return hasAuthority;
    }
}

