/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.msgboard.MsgboardTopicResultData;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicSelectData.class.getName());
    private ArrayList categoryList;
    private int topicSum;
    private Object parentTopic;
    private List coTopicList;
    private int uid;
    private boolean showReplyForm = false;
    private boolean hasAclCategoryList;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            String sortStr = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort");
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sortStr);
            if ("update_date".equals(sortStr)) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
            }
            logger.debug((Object)("[MsgboardTopicSelectData] Init Parameter. : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort")));
        }
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclCategoryList = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "msgboard_category", 1);
        try {
            VelocityPortlet portlet;
            String categoryId;
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if (filter == null && (categoryId = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3a-category")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)categoryId);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"category");
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Exception", (Throwable)ex);
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = MsgboardUtils.loadCategoryList(rundata);
    }

    public List selectList(RunData rundata, Context context) {
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = this.dataContext.performQuery((Query)query);
            this.topicSum = list.size();
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"parentId", (Object)0);
        query.setQualifier(exp1);
        Expression exp01 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)"T");
        Expression exp02 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.status", (Object)"O");
        Expression exp03 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.status", (Object)"A");
        Expression exp11 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.publicFlag", (Object)"F");
        Expression exp12 = ExpressionFactory.matchExp((String)"eipTMsgboardCategory.eipTMsgboardCategoryMaps.userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.andQualifier(exp01.andExp(exp02.orExp(exp03)).orExp(exp11.andExp(exp12)));
        query.setDistinct(true);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipTMsgboardTopic record = (EipTMsgboardTopic)obj;
            MsgboardTopicResultData rd = new MsgboardTopicResultData();
            rd.initField();
            rd.setTopicId(record.getTopicId().longValue());
            rd.setTopicName(ALCommonUtils.compressString((String)record.getTopicName(), (int)this.getStrLength()));
            rd.setCategoryId(record.getEipTMsgboardCategory().getCategoryId().longValue());
            rd.setCategoryName(ALCommonUtils.compressString((String)record.getEipTMsgboardCategory().getCategoryName(), (int)this.getStrLength()));
            rd.setPublicFlag("T".equals(record.getEipTMsgboardCategory().getPublicFlag()));
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setOwnerName(ALEipUtils.getUserFullName((int)record.getOwnerId()));
            rd.setUpdateUser(ALEipUtils.getUserFullName((int)record.getUpdateUserId()));
            rd.setUpdateDate(record.getUpdateDate());
            Date date = record.getUpdateDate();
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            rd.setNewTopicFlag(date.after(now.getTime()));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public boolean doViewDetail(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 2);
            action.setMode("detail");
            List aList = this.selectDetailList(rundata, context);
            if (aList != null) {
                this.coTopicList = new ArrayList();
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    this.coTopicList.add(this.getResultDataDetail(aList.get(i)));
                }
            }
            action.setResultData((Object)this);
            action.putData(rundata, context);
            return true;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public List selectDetailList(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String topicid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            MsgboardUtils.shiftWhatsNewReadFlag(rundata, Integer.parseInt(topicid));
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardTopicSelectData]", (Throwable)e);
        }
        if (topicid == null || Integer.valueOf(topicid) == null) {
            logger.debug((Object)"[MsgboardTopic] Empty ID...");
            throw new ALPageNotFoundException();
        }
        String cotopicsort = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2b-sort");
        try {
            this.parentTopic = this.getResultDataDetail(MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false));
            SelectQuery query = this.getSelectQueryForCotopic(rundata, context, topicid, cotopicsort);
            this.buildSelectQueryForListView(query);
            if ("response_new".equals(cotopicsort)) {
                query.addOrdering("createDate", false);
            } else {
                query.addOrdering("createDate", true);
            }
            return this.dataContext.performQuery((Query)query);
        }
        catch (Exception ex) {
            logger.error((Object)"[MsgboardTopicSelectData]", (Throwable)ex);
            throw new ALDBErrorException();
        }
    }

    public Object selectDetail(RunData rundata, Context context) {
        ALEipUtils.redirectPageNotFound((RunData)rundata);
        return null;
    }

    private SelectQuery getSelectQueryForCotopic(RunData rundata, Context context, String topicid, String cotopicsort) {
        SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
        Expression exp = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(topicid));
        query.setQualifier(exp);
        query.setDistinct(true);
        return query;
    }

    private SelectQuery getSelectQueryForFiles(int topicid) {
        SelectQuery query = new SelectQuery(EipTMsgboardFile.class);
        Expression exp = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)topicid);
        query.setQualifier(exp);
        return query;
    }

    protected Object getResultDataDetail(Object obj) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMsgboardTopic record = (EipTMsgboardTopic)obj;
            if (record.getParentId() == 0) {
                EipTMsgboardCategory category = record.getEipTMsgboardCategory();
                if ("T".equals(category.getPublicFlag())) {
                    List categoryMap = category.getEipTMsgboardCategoryMaps();
                    int mapsize = categoryMap.size();
                    for (int i = 0; i < mapsize; ++i) {
                        EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)categoryMap.get(i);
                        if ("A".equals(map.getStatus())) {
                            this.showReplyForm = true;
                            continue;
                        }
                        if (map.getUserId() != this.uid) continue;
                        this.showReplyForm = true;
                        break;
                    }
                } else {
                    this.showReplyForm = true;
                }
            }
            MsgboardTopicResultData rd = new MsgboardTopicResultData();
            rd.initField();
            rd.setTopicId(record.getTopicId().longValue());
            rd.setTopicName(record.getTopicName());
            rd.setParentId(record.getParentId().longValue());
            rd.setCategoryId(record.getEipTMsgboardCategory().getCategoryId().longValue());
            rd.setCategoryName(record.getEipTMsgboardCategory().getCategoryName());
            rd.setPublicFlag("T".equals(record.getEipTMsgboardCategory().getPublicFlag()));
            rd.setOwnerId(record.getOwnerId().longValue());
            rd.setOwnerName(ALEipUtils.getUserFullName((int)record.getOwnerId()));
            rd.setNote(record.getNote());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            List list = this.dataContext.performQuery((Query)this.getSelectQueryForFiles(record.getTopicId()));
            if (list != null && list.size() > 0) {
                ArrayList<FileuploadBean> attachmentFileList = new ArrayList<FileuploadBean>();
                FileuploadBean filebean = null;
                EipTMsgboardFile file = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    file = (EipTMsgboardFile)list.get(i);
                    String realname = file.getFileName();
                    DataHandler hData = new DataHandler((DataSource)new FileDataSource(realname));
                    filebean = new FileuploadBean();
                    filebean.setFileId(file.getFileId().intValue());
                    filebean.setFileName(realname);
                    if (hData != null) {
                        filebean.setContentType(hData.getContentType());
                    }
                    filebean.setIsImage(FileuploadUtils.isImage((String)realname));
                    attachmentFileList.add(filebean);
                }
                rd.setAttachmentFiles(attachmentFileList);
            }
            return rd;
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardTopicSelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
    }

    public ArrayList getCategoryList() {
        if (this.hasAclCategoryList) {
            return this.categoryList;
        }
        return new ArrayList();
    }

    public int getTopicSum() {
        return this.topicSum;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("topic_name", "topicName");
        map.putValue("update_date", "updateDate");
        map.putValue("category", "CATEGORY_ID");
        map.putValue("category_name", "eipTMsgboardCategory.categoryName");
        map.putValue("owner_name", "ownerId");
        map.putValue("update_user", "updateUserId");
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public List getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Object getParentTopic() {
        return this.parentTopic;
    }

    public List getCoTopicList() {
        return this.coTopicList;
    }

    public int getUserId() {
        return this.uid;
    }

    public boolean showReplyForm() {
        return this.showReplyForm;
    }

    public String getAclPortletFeature() {
        return "msgboard_topic";
    }
}

