/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.msgboard.MsgboardAction;
import com.aimluck.eip.modules.screens.MsgboardTopicDetailScreen;
import com.aimluck.eip.modules.screens.MsgboardTopicFormJSONScreen;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicReplyFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicReplyFormData.class.getName());
    private ALStringField topic_name;
    private ALStringField note;
    private ALStringField attachment = null;
    private List fileuploadList = null;
    private String folderName = null;
    private int uid;
    private String org_id;
    private DataContext dataContext;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        if (this.dataContext == null) {
            this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        }
        this.folderName = rundata.getParameters().getString("folderName");
    }

    public void initField() {
        this.topic_name = new ALStringField();
        this.topic_name.setFieldName("\u30bf\u30a4\u30c8\u30eb");
        this.topic_name.setTrim(true);
        this.note = new ALStringField();
        this.note.setFieldName("\u5185\u5bb9");
        this.note.setTrim(false);
        this.attachment = new ALStringField();
        this.attachment.setFieldName("\u6dfb\u4ed8\u30d5\u30a1\u30a4\u30eb");
        this.attachment.setTrim(true);
        this.fileuploadList = new ArrayList();
    }

    protected void setValidator() {
        this.topic_name.setNotNull(true);
        this.topic_name.limitMaxLength(50);
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
    }

    protected boolean validate(ArrayList msgList) {
        this.topic_name.validate(msgList);
        this.note.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            String topicid = rundata.getParameters().getString("topic_reply_id");
            EipTMsgboardTopic topic = MsgboardUtils.getEipTMsgboardTopicReply(rundata, context, topicid, false);
            if (topic == null) {
                logger.debug((Object)"[MsgboardTopicReplyFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            ArrayList<String> fpaths = new ArrayList<String>();
            List files = topic.getEipTMsgboardFileArray();
            if (files != null && files.size() > 0) {
                int fsize = files.size();
                for (int i = 0; i < fsize; ++i) {
                    fpaths.add(((EipTMsgboardFile)files.get(i)).getFilePath());
                }
            }
            this.dataContext.deleteObject((Persistent)topic);
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            if (fpaths.size() > 0) {
                File file = null;
                int fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    file = new File(MsgboardUtils.getSaveDirPath(this.org_id, this.uid) + (String)fpaths.get(i));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardTopicReplyFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTMsgboardTopic parenttopic = MsgboardUtils.getEipTMsgboardParentTopic(rundata, context, false);
            if (parenttopic == null) {
                logger.debug((Object)"[MsgboardTopicReplyFormData] Not found ID...");
                throw new ALPageNotFoundException();
            }
            Date updateDate = Calendar.getInstance().getTime();
            EipTMsgboardTopic topic = (EipTMsgboardTopic)this.dataContext.createAndRegisterNewObject(EipTMsgboardTopic.class);
            topic.setTopicName(this.topic_name.getValue());
            topic.setEipTMsgboardCategory(parenttopic.getEipTMsgboardCategory());
            topic.setParentId(parenttopic.getTopicId());
            topic.setOwnerId(Integer.valueOf(this.uid));
            topic.setNote(this.note.getValue());
            topic.setCreateUserId(Integer.valueOf(this.uid));
            topic.setUpdateUserId(Integer.valueOf(this.uid));
            topic.setCreateDate(Calendar.getInstance().getTime());
            topic.setUpdateDate(updateDate);
            parenttopic.setUpdateUserId(Integer.valueOf(this.uid));
            parenttopic.setUpdateDate(updateDate);
            if (!MsgboardUtils.insertFileDataDelegate(rundata, context, topic, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            EipTMsgboardCategory category = parenttopic.getEipTMsgboardCategory();
            List userIds = MsgboardUtils.getWhatsNewInsertList(rundata, category.getCategoryId(), category.getPublicFlag());
            int u_size = userIds.size();
            for (int i = 0; i < u_size; ++i) {
                Integer _id = (Integer)userIds.get(i);
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)4, (int)topic.getTopicId(), (int)_id);
            }
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)this.uid, (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardTopicReplyFormData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    public boolean doInsert(ALAction action, RunData rundata, Context context) {
        try {
            boolean res;
            this.init(action, rundata, context);
            this.doCheckAclPermission(rundata, context, 4);
            action.setMode("insert");
            ArrayList msgList = new ArrayList();
            this.setValidator();
            boolean bl = res = this.setFormData(rundata, context, msgList) && this.validate(msgList) && this.insertFormData(rundata, context, msgList);
            if (!res) {
                action.setMode("new_form");
                this.setMode(action.getMode());
            }
            if (action instanceof MsgboardTopicFormJSONScreen) {
                action.setResultData((Object)this);
                action.addErrorMessages(msgList);
                action.putData(rundata, context);
            } else {
                MsgboardAction msgboardAction = (MsgboardAction)action;
                msgboardAction.setResultDataOnTopicDetail((Object)this);
                msgboardAction.addErrorMessagesOnTopicDetail(msgList);
                msgboardAction.putDataOnTopicDetail(rundata, context);
            }
            return res;
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    public boolean doViewForm(ALAction action, RunData rundata, Context context) {
        try {
            this.init(action, rundata, context);
            ArrayList msgList = new ArrayList();
            boolean res = this.setFormData(rundata, context, msgList);
            if (action instanceof MsgboardTopicDetailScreen) {
                MsgboardTopicDetailScreen msgboardAction = (MsgboardTopicDetailScreen)action;
                msgboardAction.setResultDataOnTopicDetail((Object)this);
                msgboardAction.addErrorMessagesOnTopicDetail(msgList);
                msgboardAction.putDataOnTopicDetail(rundata, context);
            } else {
                MsgboardAction msgboardAction = (MsgboardAction)action;
                msgboardAction.setResultDataOnTopicDetail((Object)this);
                msgboardAction.addErrorMessagesOnTopicDetail(msgList);
                msgboardAction.putDataOnTopicDetail(rundata, context);
            }
            return res;
        }
        catch (ALPageNotFoundException e) {
            ALEipUtils.redirectPageNotFound((RunData)rundata);
            return false;
        }
        catch (ALDBErrorException e) {
            ALEipUtils.redirectDBError((RunData)rundata);
            return false;
        }
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return res;
    }

    public void setAclPortletFeature(String featureName) {
        this.aclPortletFeature = featureName;
    }

    public ALStringField getTopicName() {
        return this.topic_name;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public List getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getAclPortletFeature() {
        if (this.aclPortletFeature == null || "".equals(this.aclPortletFeature)) {
            return "msgboard_topic_reply";
        }
        return this.aclPortletFeature;
    }
}

