/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            int ownerid_int = ALEipUtils.getUserId((RunData)rundata);
            Integer ownerid = ownerid_int;
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
            for (int i = 0; i < values.size(); ++i) {
                String id = (String)values.get(i);
                Expression exp01 = ExpressionFactory.matchDbExp((String)"OWNER_ID", (Object)ownerid);
                Expression exp02 = ExpressionFactory.matchDbExp((String)"TOPIC_ID", (Object)Integer.valueOf(id));
                Expression exp03 = ExpressionFactory.matchExp((String)"parentId", (Object)Integer.valueOf(id));
                query.orQualifier(exp01.andExp(exp02).orExp(exp03));
            }
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"[MsgboardMultiDelete] Empty TopicIDs...");
                return false;
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardTopic topic = (EipTMsgboardTopic)list.get(i);
                dataContext.deleteObject((Persistent)topic);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            }
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "msgboard_topic";
    }
}

