/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.common.ALPermissionException;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.msgboard.util.MsgboardUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardTopicFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardTopicFormData.class.getName());
    private ALStringField topic_name;
    private ALNumberField category_id;
    private ALStringField category_name;
    private ALStringField note;
    private ArrayList categoryList;
    private boolean is_new_category;
    private FileuploadLiteBean filebean = null;
    private List fileuploadList = null;
    private String folderName = null;
    private int uid;
    private EipTMsgboardCategory category;
    private DataContext dataContext;
    private String org_id;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.is_new_category = rundata.getParameters().getBoolean("is_new_category");
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.folderName = rundata.getParameters().getString("folderName");
    }

    public void initField() {
        this.topic_name = new ALStringField();
        this.topic_name.setFieldName("\u30bf\u30a4\u30c8\u30eb");
        this.topic_name.setTrim(true);
        this.category_id = new ALNumberField();
        this.category_id.setFieldName("\u30ab\u30c6\u30b4\u30ea");
        this.category_name = new ALStringField();
        this.category_name.setFieldName("\u30ab\u30c6\u30b4\u30ea\u540d");
        this.note = new ALStringField();
        this.note.setFieldName("\u5185\u5bb9");
        this.note.setTrim(false);
        this.fileuploadList = new ArrayList();
        this.aclPortletFeature = "msgboard_topic";
    }

    public void loadCategoryList(RunData rundata, Context context) {
        this.categoryList = MsgboardUtils.loadCategoryList(rundata);
    }

    protected void setValidator() {
        this.topic_name.setNotNull(true);
        this.topic_name.limitMaxLength(50);
        this.note.setNotNull(true);
        this.note.limitMaxLength(10000);
        if (this.is_new_category) {
            this.category_name.setNotNull(true);
            this.category_name.limitMaxLength(50);
        }
    }

    protected boolean validate(ArrayList msgList) {
        this.topic_name.validate(msgList);
        this.note.validate(msgList);
        if (this.is_new_category) {
            this.category_name.validate(msgList);
        }
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            int parentid = Integer.parseInt(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid"));
            EipTMsgboardTopic parent = (EipTMsgboardTopic)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTMsgboardTopic.class, (Object)parentid);
            List list = MsgboardUtils.getEipTMsgboardTopicListToDeleteTopic(rundata, context, false);
            if (list == null) {
                logger.debug((Object)"[MsgboardTopicFormData] Not found List...");
                throw new ALPageNotFoundException();
            }
            ArrayList<Integer> topicIdList = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardTopic topic = (EipTMsgboardTopic)list.get(i);
                topicIdList.add(topic.getTopicId());
            }
            SelectQuery query = new SelectQuery(EipTMsgboardTopic.class);
            Expression exp = ExpressionFactory.inDbExp((String)"TOPIC_ID", topicIdList);
            query.setQualifier(exp);
            List topics = this.dataContext.performQuery((Query)query);
            ArrayList<String> fpaths = new ArrayList<String>();
            if (topics.size() > 0) {
                int tsize = topics.size();
                for (int i = 0; i < tsize; ++i) {
                    List files = ((EipTMsgboardTopic)topics.get(i)).getEipTMsgboardFileArray();
                    if (files == null || files.size() <= 0) continue;
                    int fsize = files.size();
                    for (int j = 0; j < fsize; ++j) {
                        fpaths.add(((EipTMsgboardFile)files.get(j)).getFilePath());
                    }
                }
            }
            this.dataContext.deleteObjects((Collection)topics);
            this.dataContext.commitChanges();
            if (fpaths.size() > 0) {
                File file = null;
                int fsize = fpaths.size();
                for (int i = 0; i < fsize; ++i) {
                    file = new File(MsgboardUtils.getSaveDirPath(this.org_id, this.uid) + (String)fpaths.get(i));
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(parent.getTopicId().intValue(), 180, parent.getTopicName());
        }
        catch (Exception e) {
            logger.error((Object)"[MsgboardCategorySelectData]", (Throwable)e);
            throw new ALDBErrorException();
        }
        return true;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            if (this.is_new_category) {
                if (!this.insertCategoryData(rundata, context)) {
                    // empty if block
                }
            } else {
                this.category = (EipTMsgboardCategory)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, EipTMsgboardCategory.class, (Object)((int)this.category_id.getValue()));
            }
            EipTMsgboardTopic topic = (EipTMsgboardTopic)this.dataContext.createAndRegisterNewObject(EipTMsgboardTopic.class);
            topic.setTopicName(this.topic_name.getValue());
            topic.setParentId(Integer.valueOf(0));
            topic.setEipTMsgboardCategory(this.category);
            topic.setOwnerId(Integer.valueOf(this.uid));
            topic.setNote(this.note.getValue());
            topic.setCreateUserId(Integer.valueOf(this.uid));
            topic.setUpdateUserId(Integer.valueOf(this.uid));
            topic.setCreateDate(Calendar.getInstance().getTime());
            topic.setUpdateDate(Calendar.getInstance().getTime());
            if (!MsgboardUtils.insertFileDataDelegate(rundata, context, topic, this.fileuploadList, this.folderName, msgList)) {
                return false;
            }
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(topic.getTopicId().intValue(), 180, topic.getTopicName());
            List userIds = MsgboardUtils.getWhatsNewInsertList(rundata, this.category.getCategoryId(), this.category.getPublicFlag());
            int u_size = userIds.size();
            for (int i = 0; i < u_size; ++i) {
                Integer _id = (Integer)userIds.get(i);
                WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)4, (int)topic.getTopicId(), (int)_id);
            }
            File folder = FileuploadUtils.getFolder((String)this.org_id, (int)this.uid, (String)this.folderName);
            FileuploadUtils.deleteFolder((File)folder);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean insertCategoryData(RunData rundata, Context context) {
        try {
            this.setAclPortletFeature("msgboard_category");
            this.doCheckAclPermission(rundata, context, 4);
            this.setAclPortletFeature("msgboard_topic");
            int userid = ALEipUtils.getUserId((RunData)rundata);
            TurbineUser tuser = (TurbineUser)DataObjectUtils.objectForPK((ObjectContext)this.dataContext, TurbineUser.class, (Object)userid);
            this.category = (EipTMsgboardCategory)this.dataContext.createAndRegisterNewObject(EipTMsgboardCategory.class);
            this.category.setCategoryName(this.category_name.getValue());
            this.category.setPublicFlag("T");
            this.category.setNote("");
            this.category.setTurbineUser(tuser);
            this.category.setCreateDate(Calendar.getInstance().getTime());
            this.category.setUpdateDate(Calendar.getInstance().getTime());
            EipTMsgboardCategoryMap map = (EipTMsgboardCategoryMap)this.dataContext.createAndRegisterNewObject(EipTMsgboardCategoryMap.class);
            map.setEipTMsgboardCategory(this.category);
            map.setUserId(Integer.valueOf(userid));
            map.setStatus("O");
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(this.category.getCategoryId().intValue(), 181, this.category.getCategoryName());
        }
        catch (ALPermissionException e) {
            ALEipUtils.redirectPermissionError((RunData)rundata);
            return false;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean res = super.setFormData(rundata, context, msgList);
        try {
            this.fileuploadList = FileuploadUtils.getFileuploadList((RunData)rundata);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
        return res;
    }

    public ALNumberField getCategoryId() {
        return this.category_id;
    }

    public ALStringField getNote() {
        return this.note;
    }

    public ALStringField getTopicName() {
        return this.topic_name;
    }

    public ArrayList getCategoryList() {
        return this.categoryList;
    }

    public boolean isNewCategory() {
        return this.is_new_category;
    }

    public void setIsNewCategory(boolean bool) {
        this.is_new_category = bool;
    }

    public ALStringField getCategoryName() {
        return this.category_name;
    }

    public List getAttachmentFileNameList() {
        return this.fileuploadList;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public void setAclPortletFeature(String aclPortletFeature) {
        this.aclPortletFeature = aclPortletFeature;
    }
}

