/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.msgboard;

import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.msgboard.MsgboardTopicSelectData;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class MsgboardCategoryMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)MsgboardCategoryMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, values);
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"[MsgboardMultiDelete] Empty TopicIDs...");
                return false;
            }
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTMsgboardCategory category = (EipTMsgboardCategory)list.get(i);
                dataContext.deleteObject((Persistent)category);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(category.getCategoryId().intValue(), 181, category.getCategoryName());
            }
            dataContext.commitChanges();
            String filtername = MsgboardTopicSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    private SelectQuery getSelectQuery(RunData rundata, ArrayList values) {
        SelectQuery query = new SelectQuery(EipTMsgboardCategory.class);
        Expression exp = ExpressionFactory.inDbExp((String)"CATEGORY_ID", (Collection)values);
        query.setQualifier(exp);
        return query;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "msgboard_category";
    }
}

