/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbookuser.util;

import com.aimluck.eip.addressbookuser.beans.AddressBookUserEmailLiteBean;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserGroupLiteBean;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserLiteBean;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

public class AddressBookUserUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookUserUtils.class.getName());

    public static List getAddressBookUserLiteBeansFromGroup(String groupid, int loginuserid) {
        ArrayList<AddressBookUserLiteBean> list = new ArrayList<AddressBookUserLiteBean>();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        try {
            SelectQuery query = new SelectQuery(EipMAddressbook.class);
            query.addCustomDbAttribute("ADDRESS_ID");
            query.addCustomDbAttribute("LAST_NAME");
            query.addCustomDbAttribute("FIRST_NAME");
            Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)loginuserid);
            Expression exp23 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.setQualifier(exp21.orExp(exp22.andExp(exp23)));
            if (groupid != null && !"".equals(groupid) && !"all".equals(groupid)) {
                Expression exp31 = ExpressionFactory.matchDbExp((String)"eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID", (Object)groupid);
                query.andQualifier(exp31);
            }
            List alist = dataContext.performQuery((Query)query);
            AddressBookUserLiteBean address = null;
            int size = alist.size();
            for (int i = 0; i < size; ++i) {
                DataRow dataRow = (DataRow)alist.get(i);
                address = new AddressBookUserLiteBean();
                address.initField();
                address.setAddressId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"ADDRESS_ID"));
                address.setFullName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"));
                list.add(address);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[AddressBookUserUtils]", (Throwable)e);
        }
        return list;
    }

    public static List getAddressBookUserGroupLiteBeans(RunData rundata) {
        ArrayList<AddressBookUserGroupLiteBean> list = new ArrayList<AddressBookUserGroupLiteBean>();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            query.addCustomDbAttribute("GROUP_ID");
            query.addCustomDbAttribute("GROUP_NAME");
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List glist = dataContext.performQuery((Query)query);
            AddressBookUserGroupLiteBean bean = null;
            int size = glist.size();
            for (int i = 0; i < size; ++i) {
                DataRow dataRow = (DataRow)glist.get(i);
                bean = new AddressBookUserGroupLiteBean();
                bean.initField();
                bean.setGroupId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"GROUP_ID"));
                bean.setName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"GROUP_NAME"));
                list.add(bean);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[AddressBookUserUtils]", (Throwable)e);
        }
        return list;
    }

    public static List getAddressBookUserEmailLiteBeansFromGroup(String groupid, int loginuserid) {
        ArrayList<AddressBookUserEmailLiteBean> list = new ArrayList<AddressBookUserEmailLiteBean>();
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        try {
            SelectQuery query = new SelectQuery(EipMAddressbook.class);
            query.addCustomDbAttribute("ADDRESS_ID");
            query.addCustomDbAttribute("LAST_NAME");
            query.addCustomDbAttribute("FIRST_NAME");
            query.addCustomDbAttribute("EMAIL");
            Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)loginuserid);
            Expression exp23 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.setQualifier(exp21.orExp(exp22.andExp(exp23)));
            if (groupid != null && !"".equals(groupid) && !"all".equals(groupid)) {
                Expression exp31 = ExpressionFactory.matchDbExp((String)"eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID", (Object)groupid);
                query.andQualifier(exp31);
            }
            List alist = dataContext.performQuery((Query)query);
            AddressBookUserEmailLiteBean address = null;
            int size = alist.size();
            for (int i = 0; i < size; ++i) {
                DataRow dataRow = (DataRow)alist.get(i);
                address = new AddressBookUserEmailLiteBean();
                address.initField();
                address.setAddressId((Integer)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"ADDRESS_ID"));
                address.setFullName((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME"), (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"));
                address.setEmail((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"EMAIL"));
                list.add(address);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[AddressBookUserUtils]", (Throwable)e);
        }
        return list;
    }
}

