/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecardSettings;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.timecard.util.TimecardUtils;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.cayenne.access.DataContext;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimecardSettingsFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimecardSettingsFormData.class.getName());
    private ALNumberField start_time_hour;
    private ALNumberField start_time_minute;
    private ALNumberField end_time_hour;
    private ALNumberField end_time_minute;
    private ALNumberField worktime_in;
    private ALNumberField resttime_in;
    private ALNumberField worktime_out;
    private ALNumberField resttime_out;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    public void initField() {
        this.start_time_hour = new ALNumberField();
        this.start_time_minute = new ALNumberField();
        this.end_time_hour = new ALNumberField();
        this.end_time_minute = new ALNumberField();
        this.worktime_in = new ALNumberField();
        this.worktime_in.setFieldName("\u52e4\u52d9\u6642\u9593\u5185\u306e\u52e4\u52d9\u6642\u9593");
        this.worktime_in.setNotNull(true);
        this.worktime_in.limitMinValue(0L);
        this.resttime_in = new ALNumberField();
        this.resttime_in.setFieldName("\u52e4\u52d9\u6642\u9593\u5185\u306e\u4f11\u61a9\u6642\u9593");
        this.resttime_in.setNotNull(true);
        this.resttime_in.limitValue(0L, 360L);
        this.worktime_out = new ALNumberField();
        this.worktime_out.setFieldName("\u52e4\u52d9\u6642\u9593\u5916\u306e\u52e4\u52d9\u6642\u9593");
        this.worktime_out.setNotNull(true);
        this.worktime_out.limitMinValue(0L);
        this.resttime_out = new ALNumberField();
        this.resttime_out.setFieldName("\u52e4\u52d9\u6642\u9593\u5916\u306e\u4f11\u61a9\u6642\u9593");
        this.resttime_out.setNotNull(true);
        this.resttime_out.limitValue(0L, 360L);
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTTimecardSettings record = TimecardUtils.getEipTTimecardSettings(rundata, context);
            if (record == null) {
                return false;
            }
            this.start_time_hour = new ALNumberField((long)record.getStartHour().intValue());
            this.start_time_minute = new ALNumberField((long)record.getStartMinute().intValue());
            this.end_time_hour = new ALNumberField((long)record.getEndHour().intValue());
            this.end_time_minute = new ALNumberField((long)record.getEndMinute().intValue());
            this.worktime_in.setValue((long)record.getWorktimeIn().intValue());
            this.resttime_in.setValue((long)record.getResttimeIn().intValue());
            this.worktime_out.setValue((long)record.getWorktimeOut().intValue());
            this.resttime_out.setValue((long)record.getResttimeOut().intValue());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        try {
            EipTTimecardSettings record = TimecardUtils.getEipTTimecardSettings(rundata, context);
            if (record == null) {
                return false;
            }
            record.setStartHour(Integer.valueOf((int)this.start_time_hour.getValue()));
            record.setStartMinute(Integer.valueOf((int)this.start_time_minute.getValue()));
            record.setEndHour(Integer.valueOf((int)this.end_time_hour.getValue()));
            record.setEndMinute(Integer.valueOf((int)this.end_time_minute.getValue()));
            record.setWorktimeIn(Integer.valueOf((int)this.worktime_in.getValue()));
            record.setResttimeIn(Integer.valueOf((int)this.resttime_in.getValue()));
            record.setWorktimeOut(Integer.valueOf((int)this.worktime_out.getValue()));
            record.setResttimeOut(Integer.valueOf((int)this.resttime_out.getValue()));
            record.setUpdateDate(Calendar.getInstance().getTime());
            this.dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        return false;
    }

    protected void setValidator() throws ALPageNotFoundException, ALDBErrorException {
        this.start_time_hour.limitValue(0L, 23L);
        this.start_time_minute.limitValue(0L, 59L);
        this.end_time_hour.limitValue(0L, 23L);
        this.end_time_minute.limitValue(0L, 59L);
        this.worktime_in.limitValue(0L, 480L);
        this.worktime_out.limitValue(0L, 480L);
        this.resttime_in.limitValue(0L, 480L);
        this.resttime_out.limitValue(0L, 480L);
    }

    protected boolean validate(ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        this.worktime_in.validate(msgList);
        this.resttime_in.validate(msgList);
        this.worktime_out.validate(msgList);
        this.resttime_out.validate(msgList);
        return msgList.size() == 0;
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        return null;
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        return super.setFormData(rundata, context, msgList);
    }

    public ALNumberField getStartTimeHour() {
        return this.start_time_hour;
    }

    public ALNumberField getStartTimeMinute() {
        return this.start_time_minute;
    }

    public ALNumberField getEndTimeHour() {
        return this.end_time_hour;
    }

    public ALNumberField getEndTimeMinute() {
        return this.end_time_minute;
    }

    public ALNumberField getWorktimeIn() {
        return this.worktime_in;
    }

    public ALNumberField getWorktimeOut() {
        return this.worktime_out;
    }

    public ALNumberField getResttimeIn() {
        return this.resttime_in;
    }

    public ALNumberField getResttimeOut() {
        return this.resttime_out;
    }
}

