/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.timecard;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecard;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.timecard.TimecardListResultData;
import com.aimluck.eip.timecard.TimecardResultData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class TimecardSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)TimecardSelectData.class.getName());
    private String target_group_name;
    private String target_user_id;
    private List myGroupList = null;
    private List userList = null;
    private String userid;
    private ALDateTimeField view_date;
    private String nowtime;
    private Map datemap;
    private String aclPortletFeature = null;
    private boolean hasAclSummaryOther;
    private boolean hasAclXlsExport;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        Calendar cal = Calendar.getInstance();
        this.view_date = new ALDateTimeField("yyyy-MM-dd");
        if (rundata.getParameters().containsKey((Object)"view_date_year") && rundata.getParameters().containsKey((Object)"view_date_month")) {
            int tmpViewDate_year = Integer.parseInt(rundata.getParameters().getString("view_date_year"));
            int tmpViewDate_month = Integer.parseInt(rundata.getParameters().getString("view_date_month"));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(1, tmpViewDate_year);
            cal.set(2, tmpViewDate_month - 1);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
        }
        cal.set(5, 1);
        this.view_date.setValue(cal.getTime());
        this.userid = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add(myGroups.get(i));
        }
        this.setupLists(rundata, context);
        this.aclPortletFeature = this.target_user_id == null || "".equals(this.target_user_id) || this.userid.equals(this.target_user_id) ? "timecard_timecard_self" : "timecard_timecard_other";
        ALAccessControlFactoryService aclservice = (ALAccessControlFactoryService)((TurbineServices)TurbineServices.getInstance()).getService("ALAccessControlFactoryService");
        ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
        this.hasAclSummaryOther = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), "timecard_timecard_other", 1);
        if (!this.hasAclSummaryOther) {
            this.target_user_id = this.userid;
            this.aclPortletFeature = "timecard_timecard_self";
        }
        this.hasAclXlsExport = aclhandler.hasAuthority(ALEipUtils.getUserId((RunData)rundata), this.aclPortletFeature, 32);
        this.datemap = new LinkedHashMap();
        super.init(action, rundata, context);
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTTimecard.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(this.target_user_id));
        query.setQualifier(exp1);
        Calendar cal = Calendar.getInstance();
        Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)"workDate", (Object)this.view_date.getValue());
        cal.setTime(this.view_date.getValue());
        cal.add(2, 1);
        ALDateTimeField view_date_add_month = new ALDateTimeField("yyyy-MM-dd");
        view_date_add_month.setValue(cal.getTime());
        Expression exp12 = ExpressionFactory.lessOrEqualExp((String)"workDate", (Object)view_date_add_month.getValue());
        query.andQualifier(exp11.andExp(exp12));
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public List selectList(RunData rundata, Context context) {
        try {
            if (!"".equals(this.target_user_id)) {
                DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
                SelectQuery query = this.getSelectQuery(rundata, context);
                this.buildSelectQueryForListView(query);
                query.addOrdering("workDate", true);
                List list = dataContext.performQuery((Query)query);
                return this.buildPaginatedList(list);
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(Object obj) {
        try {
            TimecardListResultData listrd;
            EipTTimecard record = (EipTTimecard)obj;
            Date date = record.getWorkDate();
            String checkdate = ALDateUtil.format((Date)date, (String)"yyyyMMdd");
            Object value = this.datemap.get(checkdate);
            if (value == null) {
                listrd = new TimecardListResultData();
                listrd.initField();
                listrd.setDate(date);
                this.datemap.put(checkdate, listrd);
            }
            listrd = (TimecardListResultData)this.datemap.get(checkdate);
            TimecardResultData rd = new TimecardResultData();
            rd.initField();
            rd.setWorkFlag(record.getWorkFlag());
            rd.setWorkDate(record.getWorkDate());
            rd.setRefixFlag(record.getCreateDate(), record.getUpdateDate());
            rd.setTimecardId(record.getTimecardId().longValue());
            rd.setReason(record.getReason());
            if (rd.getStartWorkDate() == null) {
                Date workdate = record.getWorkDate();
                workdate.setTime(0L);
                rd.setStartWorkDate(workdate);
            }
            listrd.addTimecardResultData(rd);
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private boolean sameDay(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int date1Year = cal1.get(1);
        int date1Month = cal1.get(2) + 1;
        int date1Day = cal1.get(5);
        int date2Year = cal2.get(1);
        int date2Month = cal2.get(2) + 1;
        int date2Day = cal2.get(5);
        return date1Year == date2Year && date1Month == date2Month && date1Day == date2Day;
    }

    private SelectQuery getSelectQueryDetail(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTTimecard.class);
        Expression exp = ExpressionFactory.matchExp((String)"userId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp);
        return query;
    }

    public Object selectDetail(RunData rundata, Context context) {
        try {
            Calendar cal = Calendar.getInstance();
            this.nowtime = cal.get(11) + "\u6642" + cal.get(12) + "\u5206";
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQueryDetail(rundata, context);
            query.addOrdering("workDate", false);
            List list = dataContext.performQuery((Query)query);
            if (list != null && list.size() > 0) {
                return list.get(0);
            }
            return null;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            EipTTimecard record = (EipTTimecard)obj;
            TimecardResultData rd = new TimecardResultData();
            rd.initField();
            rd.setWorkFlag(record.getWorkFlag());
            rd.setWorkDate(record.getWorkDate());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    private void setupLists(RunData rundata, Context context) {
        this.target_group_name = this.getTargetGroupName(rundata, context);
        this.userList = this.target_group_name != null && !this.target_group_name.equals("") && !this.target_group_name.equals("all") ? ALEipUtils.getUsers((String)this.target_group_name) : ALEipUtils.getUsers((String)"LoginUser");
        if (this.userList == null || this.userList.size() == 0) {
            this.target_user_id = "";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
            return;
        }
        this.target_user_id = this.getTargetUserId(rundata, context);
    }

    private String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_group_name");
        }
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_group_name");
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_group_name", (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    private String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = null;
        if (ALEipUtils.isMatch((RunData)rundata, (Context)context)) {
            idParam = rundata.getParameters().getString("target_user_id");
        }
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
            target_user_id = this.userid;
        } else if (idParam != null) {
            if (idParam.equals("none")) {
                ALEipUser eipUser = null;
                boolean found = false;
                int length = this.userList.size();
                for (int i = 0; i < length; ++i) {
                    eipUser = (ALEipUser)this.userList.get(i);
                    String eipUserId = eipUser.getUserId().getValueAsString();
                    if (!this.userid.equals(eipUserId)) continue;
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)this.userid);
                    target_user_id = this.userid;
                    found = true;
                    break;
                }
                if (!found) {
                    eipUser = (ALEipUser)this.userList.get(0);
                    String userId = eipUser.getUserId().getValueAsString();
                    ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)userId);
                    target_user_id = userId;
                }
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"target_user_id", (String)idParam);
                target_user_id = idParam;
            }
        }
        return target_user_id;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public List getUsers() {
        if (this.hasAclSummaryOther) {
            return this.userList;
        }
        try {
            ArrayList<ALEipUser> users = new ArrayList<ALEipUser>();
            users.add(ALEipUtils.getALEipUser((int)Integer.parseInt(this.userid)));
            return users;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Map getPostMap() {
        if (this.hasAclSummaryOther) {
            return ALEipManager.getInstance().getPostMap();
        }
        return null;
    }

    public List getMyGroupList() {
        if (this.hasAclSummaryOther) {
            return this.myGroupList;
        }
        return null;
    }

    public String getUserId() {
        return this.userid;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        return map;
    }

    public boolean isMatch(int id1, long id2) {
        return id1 == (int)id2;
    }

    public ALDateTimeField getViewDate() {
        return this.view_date;
    }

    public String getNowTime() {
        return this.nowtime;
    }

    public List getDateListKeys() {
        try {
            ArrayList list = new ArrayList();
            Set set = this.datemap.keySet();
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            if (list.size() > 1) {
                for (int i = 0; i < list.size() - 1; ++i) {
                    TimecardListResultData listrd1 = (TimecardListResultData)this.datemap.get(list.get(i));
                    TimecardListResultData listrd2 = (TimecardListResultData)this.datemap.get(list.get(i + 1));
                    int listrd1_size = listrd1.getList().size();
                    if (listrd1_size <= 0) continue;
                    TimecardResultData listrd1_lastrd = (TimecardResultData)listrd1.getList().get(listrd1_size - 1);
                    TimecardResultData listrd2_firstrd = (TimecardResultData)listrd2.getList().get(0);
                    if (!"0".equals(listrd2_firstrd.getWorkFlag().getValue()) || !"1".equals(listrd1_lastrd.getWorkFlag().getValue()) || this.sameDay(listrd1_lastrd.getWorkDate().getValue(), listrd2_firstrd.getWorkDate().getValue())) continue;
                    Date d = listrd2_firstrd.getWorkDate().getValue();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(d);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    TimecardResultData dummyrd = new TimecardResultData();
                    dummyrd.initField();
                    dummyrd.setWorkFlag("-1");
                    dummyrd.setWorkDate(cal.getTime());
                    listrd1.addTimecardResultData(dummyrd);
                }
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public TimecardListResultData getDateListValue(String date_str) {
        return (TimecardListResultData)this.datemap.get(date_str);
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }

    public boolean hasAclXlsExport() {
        return this.hasAclXlsExport;
    }
}

