/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.mail.MailSession;
import com.sk_jp.mail.MultipartUtility;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;

public class Retriever {
    private MailSession mailSession;
    private Store store;
    private Folder currentFolder = null;
    private boolean writable = false;

    Retriever(MailSession mailSession, Store store) {
        this.mailSession = mailSession;
        this.store = store;
    }

    public String getHost() {
        return this.mailSession.getStoreHost();
    }

    public String getUser() {
        return this.mailSession.getStoreUser();
    }

    public synchronized void connect() throws MessagingException {
        this.store.connect(null, -1, null, this.mailSession.getStorePassword());
    }

    public synchronized boolean isConnected() {
        return this.store.isConnected();
    }

    public synchronized boolean isOpen() {
        return this.currentFolder != null && this.currentFolder.isOpen();
    }

    public synchronized void disconnect() {
        this.disconnect(true);
    }

    public synchronized void disconnect(boolean bl) {
        try {
            this.close(bl);
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
        try {
            this.store.close();
        }
        catch (MessagingException messagingException) {
            messagingException.printStackTrace();
        }
    }

    public synchronized void setWritable(boolean bl) {
        this.writable = bl;
    }

    public synchronized void open(String string) throws MessagingException {
        this.close(true);
        this.currentFolder = this.store.getFolder(string);
        if (this.currentFolder == null) {
            throw new FolderNotFoundException();
        }
        if (this.writable) {
            this.currentFolder.open(2);
        } else {
            this.currentFolder.open(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean bl) throws MessagingException {
        try {
            if (this.currentFolder != null && this.currentFolder.isOpen()) {
                this.currentFolder.close(bl);
            }
        }
        finally {
            this.currentFolder = null;
        }
    }

    public synchronized MimeMessage[] get() throws MessagingException {
        if (this.currentFolder == null) {
            this.open("INBOX");
        }
        Message[] messageArray = this.currentFolder.getMessages();
        MimeMessage[] mimeMessageArray = new MimeMessage[messageArray.length];
        for (int i = 0; i < messageArray.length; ++i) {
            mimeMessageArray[i] = (MimeMessage)messageArray[i];
        }
        return mimeMessageArray;
    }

    public synchronized MimeMessage get(int n) throws MessagingException {
        if (this.currentFolder == null) {
            this.open("INBOX");
        }
        try {
            MimeMessage mimeMessage = (MimeMessage)this.currentFolder.getMessage(n);
            mimeMessage.getContent();
            return mimeMessage;
        }
        catch (IOException iOException) {
            throw new MessagingException("get Exception", (Exception)iOException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new MessagingException("Message number out of bounds", (Exception)indexOutOfBoundsException);
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        int n = 0;
        if (stringArray.length > 3) {
            n = Integer.parseInt(stringArray[3]);
        }
        MailSession mailSession = new MailSession(string2);
        mailSession.setStoreAccount(string, null, -1, null, string3);
        Retriever retriever = mailSession.getRetriever();
        retriever.connect();
        if (n > 0) {
            MimeMessage mimeMessage = retriever.get(n);
            mimeMessage.writeTo((OutputStream)System.out);
            retriever.disconnect();
            retriever.connect();
            mimeMessage = retriever.get(n);
            mimeMessage.writeTo((OutputStream)System.out);
        } else {
            MimeMessage[] mimeMessageArray = retriever.get();
            System.out.println("******************* Recieved: " + mimeMessageArray.length);
            for (int i = 0; i < mimeMessageArray.length; ++i) {
                mimeMessageArray[i].writeTo((OutputStream)System.out);
                System.out.println("*******************");
                MultipartUtility.dump((Part)mimeMessageArray[i]);
            }
        }
        retriever.disconnect();
    }
}

