/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import com.sk_jp.Debug;
import com.sk_jp.Log;
import com.sk_jp.mail.AttachmentsExtractor;
import com.sk_jp.mail.MailUtility;
import com.sk_jp.mail.MultipartUtility;
import com.sk_jp.mail.SKMessage;
import com.sk_jp.util.StringValues;
import com.sk_jp.xml.DOMUtility;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MapByMessage
implements Map,
Serializable {
    private transient MimeMessage message;
    private Map map;
    protected static Map getters = new HashMap();

    public MapByMessage(MimeMessage mimeMessage) {
        this(mimeMessage, false);
    }

    public MapByMessage(MimeMessage mimeMessage, boolean bl) {
        this.message = mimeMessage;
        if (bl) {
            this.map = new HashMap();
        }
    }

    public Object put(Object object, Object object2) {
        if (this.map == null) {
            throw new UnsupportedOperationException("put is unsupported.");
        }
        return this.map.put(object, object2);
    }

    public Object get(Object object) {
        Object object2;
        boolean bl = false;
        if (object instanceof String && ((String)(object2 = (String)object)).startsWith("normalized")) {
            bl = true;
            object = ((String)object2).substring(10);
        }
        if (this.map != null && (object2 = this.map.get(object)) != null) {
            if (bl && object2 instanceof String) {
                return DOMUtility.normalize((String)object2);
            }
            return object2;
        }
        try {
            Getter getter = (Getter)getters.get(object);
            if (getter != null) {
                object2 = getter.get(this.message);
                if (bl && object2 instanceof String) {
                    return DOMUtility.normalize((String)((String)object2));
                }
                return object2;
            }
            String[] stringArray = this.message.getHeader(((String)object).replace('_', '-'));
            if (stringArray == null) {
                return null;
            }
            StringValues stringValues = new StringValues();
            for (int i = 0; i < stringArray.length; ++i) {
                stringValues.add(MailUtility.decodeText(stringArray[i]));
            }
            if (bl) {
                return DOMUtility.normalize((String)stringValues.getString());
            }
            return stringValues.getString();
        }
        catch (MessagingException messagingException) {
            Log.log((Throwable)messagingException, (int)3);
            if (messagingException.getNextException() != null) {
                Log.log((Throwable)messagingException.getNextException(), (int)3);
            }
            return messagingException;
        }
        catch (Exception exception) {
            Log.log((Throwable)exception, (int)3);
            return exception;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.message != null) {
            Iterator iterator = getters.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (this.map.containsKey(k)) continue;
                try {
                    this.map.put(k, ((Getter)getters.get(k)).get(this.message));
                }
                catch (MessagingException messagingException) {
                }
                catch (Exception exception) {}
            }
        }
        objectOutputStream.defaultWriteObject();
    }

    public int size() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public boolean containsKey(Object object) {
        throw new UnsupportedOperationException("not implemented.");
    }

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException("not implemented.");
    }

    public Object remove(Object object) {
        throw new UnsupportedOperationException("not implemented.");
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException("not implemented.");
    }

    public void clear() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public Set keySet() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public Collection values() {
        throw new UnsupportedOperationException("not implemented.");
    }

    public static void addGetter(String string, Getter getter) {
        getters.put(string, getter);
    }

    public static void main(String[] stringArray) throws Exception {
        SKMessage sKMessage = new SKMessage(System.in);
        MapByMessage mapByMessage = new MapByMessage(sKMessage);
        System.out.println("From   : " + mapByMessage.get("htmlfrom"));
        System.out.println("To     : " + mapByMessage.get("htmlto"));
        System.out.println("Subject: " + mapByMessage.get("subject"));
        System.out.println("************** attachments");
        System.out.println(Debug.arrayToString(mapByMessage.get("attachmentnames")));
        System.out.println("************** plain/text contents");
        System.out.println(mapByMessage.get("content"));
        System.out.println("************** first body contents");
        System.out.println(sKMessage.getContent());
        System.out.println("************** raw data");
        sKMessage.writeTo(System.out);
    }

    static {
        getters.put("content", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MultipartUtility.getPlainText((Part)mimeMessage);
            }
        });
        getters.put("attachmentnames", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                AttachmentsExtractor attachmentsExtractor = new AttachmentsExtractor();
                MultipartUtility.process((Part)mimeMessage, attachmentsExtractor);
                return attachmentsExtractor.getFileNames();
            }
        });
        getters.put("subject", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.decodeText(MailUtility.unfold(mimeMessage.getHeader("Subject", null)));
            }
        });
        getters.put("from", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getMailAddresses((InternetAddress[])mimeMessage.getFrom());
            }
        });
        getters.put("fromname", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                String string = MailUtility.getPersonalNames((InternetAddress[])mimeMessage.getFrom());
                if (string != null) {
                    return string;
                }
                return new StringValues((Object[])mimeMessage.getFrom()).getString();
            }
        });
        getters.put("htmlfrom", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getAddressesHTML((InternetAddress[])mimeMessage.getFrom());
            }
        });
        getters.put("to", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getMailAddresses((InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.TO));
            }
        });
        getters.put("toname", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getPersonalNames((InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.TO));
            }
        });
        getters.put("htmlto", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getAddressesHTML((InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.TO));
            }
        });
        getters.put("cc", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getMailAddresses((InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.CC));
            }
        });
        getters.put("ccname", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getPersonalNames((InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.CC));
            }
        });
        getters.put("htmlcc", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return MailUtility.getAddressesHTML((InternetAddress[])mimeMessage.getRecipients(Message.RecipientType.CC));
            }
        });
        getters.put("localizeddate", new Getter(){
            DateFormat dateFormat = DateFormat.getDateTimeInstance();

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                String string = mimeMessage.getHeader("Date", null);
                if (string == null) {
                    return null;
                }
                return this.dateFormat.format(MailUtility.parseDate(string));
            }
        });
        getters.put("japanizeddate", new Getter(){
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.JAPAN);

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                String string = mimeMessage.getHeader("Date", null);
                if (string == null) {
                    return null;
                }
                return this.dateFormat.format(MailUtility.parseDate(string));
            }
        });
        getters.put("size", new Getter(){

            public Object get(MimeMessage mimeMessage) throws MessagingException {
                return new Integer(mimeMessage.getSize());
            }
        });
    }

    public static interface Getter {
        public Object get(MimeMessage var1) throws MessagingException;
    }
}

