/*
 * Decompiled with CFR 0.152.
 */
package com.sk_jp.mail;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class MXManager {
    private String[] nameServers;
    private Map cache = new WeakHashMap();

    public MXManager(String[] stringArray) {
        this.nameServers = stringArray;
    }

    public void connect(Transport transport, String string) throws NamingException, IOException {
        String[] stringArray = this.getMX(string);
        if (stringArray == null) {
            throw new NamingException("MX record not found : " + string);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            try {
                if (Boolean.getBoolean("debug")) {
                    System.out.println("connect to " + stringArray[i] + " for " + string);
                }
                transport.connect(stringArray[i], null, null);
                return;
            }
            catch (MessagingException messagingException) {
                stringArray[i] = null;
                System.err.println((Object)messagingException);
            }
        }
        throw new IOException("Cannot connect to all MX hosts. first = " + stringArray[0]);
    }

    public String[] getMX(String string) {
        String[] stringArray = (String[])this.cache.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        for (int i = 0; i < this.nameServers.length; ++i) {
            try {
                stringArray = MXManager.getMX(this.nameServers[i], string);
                this.cache.put(string, stringArray);
                return stringArray;
            }
            catch (NamingException namingException) {
                continue;
            }
        }
        return null;
    }

    public static String[] getMX(String string, String string2) throws NamingException {
        InitialDirContext initialDirContext = new InitialDirContext();
        Attributes attributes = initialDirContext.getAttributes("dns://" + string + '/' + string2, new String[]{"MX"});
        if (attributes.size() != 1) {
            throw new NamingException("Attributes must have 1 entry. :" + attributes + " searching " + string2 + " by " + string);
        }
        Attribute attribute = attributes.getAll().next();
        String[] stringArray = new String[attribute.size()];
        int n = 0;
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            stringArray[n] = (String)namingEnumeration.next();
            stringArray[n] = stringArray[n].substring(stringArray[n].indexOf(32) + 1);
            ++n;
        }
        return stringArray;
    }
}

