/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook.util;

import com.aimluck.eip.addressbook.AddressBookGroup;
import com.aimluck.eip.addressbookuser.beans.AddressBookUserGroupLiteBean;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUserGroupRole;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookUtils.class.getName());

    public static EipMAddressGroup getEipMAddressGroup(RunData rundata, Context context) {
        String groupid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (groupid == null || Integer.valueOf(groupid) == null) {
                logger.debug((Object)"[AddressBook] Group ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            Expression exp1 = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)Integer.valueOf(groupid));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.andQualifier(exp2);
            List groups = dataContext.performQuery((Query)query);
            if (groups == null || groups.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found Group ID...");
                return null;
            }
            return (EipMAddressGroup)groups.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipMAddressbookCompany getEipMAddressbookCompany(RunData rundata, Context context) {
        String companyid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (companyid == null || Integer.valueOf(companyid) == null) {
                logger.debug((Object)"[AddressBook] Company ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressbookCompany.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"COMPANY_ID", (Object)Integer.valueOf(companyid));
            query.setQualifier(exp);
            List companys = dataContext.performQuery((Query)query);
            if (companys == null || companys.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found Company ID...");
                return null;
            }
            return (EipMAddressbookCompany)companys.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception ", (Throwable)ex);
            return null;
        }
    }

    public static ArrayList getMyGroupNames(RunData rundata, int addressid, int userid) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTAddressbookGroupMap.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"addressId", (Object)addressid);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTAddressGroup.ownerId", (Object)userid);
            query.andQualifier(exp2);
            List groups = dataContext.performQuery((Query)query);
            ArrayList<String> aList = new ArrayList<String>();
            int size = groups.size();
            for (int i = 0; i < size; ++i) {
                aList.add(((EipTAddressbookGroupMap)groups.get(i)).getEipTAddressGroup().getGroupName());
            }
            return aList;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception ", (Throwable)ex);
            return null;
        }
    }

    public static String getMyGroupNamesAsString(RunData rundata, int addressid, int userid) {
        ArrayList aList = AddressBookUtils.getMyGroupNames(rundata, addressid, userid);
        int group_size = aList.size();
        StringBuffer groupNames = new StringBuffer();
        for (int i = 0; i < group_size; ++i) {
            groupNames.append(aList.get(i)).append("\u3001");
        }
        if (groupNames.length() == 0) {
            return "";
        }
        return groupNames.substring(0, groupNames.length() - 1);
    }

    public static EipMAddressbook getEipMAddressbook(RunData rundata, Context context) {
        String addressid = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (addressid == null || Integer.valueOf(addressid) == null) {
                logger.debug((Object)"[AddressBook] Address ID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressbook.class);
            Expression exp11 = ExpressionFactory.matchDbExp((String)"ADDRESS_ID", (Object)Integer.valueOf(addressid));
            query.setQualifier(exp11);
            Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression exp23 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.andQualifier(exp21.orExp(exp22.andExp(exp23)));
            List addresses = dataContext.performQuery((Query)query);
            if (addresses == null || addresses.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found Address ID...");
                return null;
            }
            return (EipMAddressbook)addresses.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception ", (Throwable)ex);
            return null;
        }
    }

    public static EipMAddressbookCompany getDummyEipMAddressbookCompany(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressbookCompany.class);
            Expression exp11 = ExpressionFactory.matchExp((String)"createUserId", (Object)1);
            Expression exp12 = ExpressionFactory.matchExp((String)"companyName", (Object)"\u672a\u5206\u985e");
            query.setQualifier(exp11.andExp(exp12));
            List list = dataContext.performQuery((Query)query);
            if (list == null || list.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found AddressbookCompany ID...");
                return null;
            }
            return (EipMAddressbookCompany)list.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception ", (Throwable)ex);
            return null;
        }
    }

    public static Map getGroupMap(RunData rundata, Context context) {
        try {
            LinkedHashMap<Integer, AddressBookGroup> groupMap = new LinkedHashMap<Integer, AddressBookGroup>();
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List list = dataContext.performQuery((Query)query);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressGroup record = (EipMAddressGroup)list.get(i);
                AddressBookGroup group = new AddressBookGroup();
                group.initField();
                group.setGroupId(record.getGroupId());
                group.setGroupName(record.getGroupName());
                groupMap.put(record.getGroupId(), group);
            }
            return groupMap;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getGroups(int uid) {
        logger.debug((Object)"AddressbookUtils getGroups in");
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)uid);
            query.setQualifier(exp);
            List groups = dataContext.performQuery((Query)query);
            if (groups == null || groups.size() == 0) {
                logger.debug((Object)"[AddressBook] Not found group ID...");
                return null;
            }
            logger.debug((Object)"AddressbookUtils getGroups out");
            return groups;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getGroupMember(String gid) {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT ");
        statement.append(" B.last_name, B.first_name, ");
        statement.append(" C.company_name ");
        statement.append("FROM EIP_T_ADDRESSBOOK_GROUP_MAP as A ");
        statement.append("LEFT JOIN EIP_M_ADDRESSBOOK as B ");
        statement.append(" on A.ADDRESS_ID = B.ADDRESS_ID ");
        statement.append("LEFT JOIN EIP_M_ADDRESSBOOK_COMPANY AS C ");
        statement.append(" on B.COMPANY_ID = C.COMPANY_ID ");
        statement.append("WHERE A.GROUP_ID = '").append(gid).append("' ");
        statement.append("ORDER BY C.company_name_kana, C.company_name, B.last_name_kana");
        String query = statement.toString();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SQLTemplate rawSelect = new SQLTemplate(EipMAddressbook.class, query, true);
            rawSelect.setFetchingDataRows(true);
            List list = dataContext.performQuery((Query)rawSelect);
            int recordNum = list.size();
            for (int i = 0; i < recordNum; ++i) {
                DataRow dataRow = (DataRow)list.get(i);
                StringBuffer strBuf = new StringBuffer();
                strBuf.append((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"LAST_NAME")).append((String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"FIRST_NAME"));
                String companyName = (String)ALEipUtils.getObjFromDataRow((DataRow)dataRow, (String)"COMPANY_NAME");
                if (companyName != null && companyName.trim().length() > 0) {
                    strBuf.append(" (").append(companyName).append(")");
                }
                resultList.add(strBuf.toString());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"[AddressbookUtils]", (Throwable)ex);
        }
        return resultList;
    }

    public static List getPostBeanList(int uid) {
        SelectQuery query = new SelectQuery(TurbineUserGroupRole.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"turbineUser", (Object)uid);
        Expression exp2 = ExpressionFactory.greaterExp((String)"turbineGroup", (Object)3);
        Expression exp3 = ExpressionFactory.matchExp((String)"turbineGroup.ownerId", (Object)1);
        query.setQualifier(exp1);
        query.andQualifier(exp2);
        query.andQualifier(exp3);
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        List list = dataContext.performQuery((Query)query);
        if (list == null || list.size() < 0) {
            return null;
        }
        ArrayList<AddressBookUserGroupLiteBean> resultList = new ArrayList<AddressBookUserGroupLiteBean>();
        TurbineUserGroupRole ugr = null;
        TurbineGroup group = null;
        AddressBookUserGroupLiteBean bean = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ugr = (TurbineUserGroupRole)list.get(i);
            group = ugr.getTurbineGroup();
            bean = new AddressBookUserGroupLiteBean();
            bean.initField();
            bean.setGroupId(Integer.parseInt(group.getId()) - 3);
            bean.setName(group.getGroupAliasName());
            resultList.add(bean);
        }
        return resultList;
    }
}

