/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookWordSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookWordSelectData.class.getName());
    private ALStringField searchWord;
    private String currentTab;
    private ArrayList groupList;
    private List myGroupList = null;
    private DataContext dataContext;
    private String aclPortletFeature = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        if (!rundata.getParameters().containsKey((Object)"start") && !rundata.getParameters().containsKey((Object)"sort")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"AddressBooksword", (String)rundata.getParameters().getString("sword"));
        }
        this.searchWord = new ALStringField();
        this.searchWord.setTrim(true);
        this.searchWord.setValue(ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"AddressBooksword"));
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"syagai");
            this.currentTab = "syagai";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        this.aclPortletFeature = "syagai".equals(this.currentTab) ? "addressbook_address_outside" : "addressbook_address_inside";
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        List list;
        block4: {
            try {
                if ("syagai".equals(this.currentTab)) {
                    SelectQuery query = this.getSelectQuery(rundata, context);
                    this.buildSelectQueryForListView(query);
                    this.buildSelectQueryForListViewSort(query, rundata, context);
                    list = this.dataContext.performQuery((Query)query);
                    break block4;
                }
                if ("corp".equals(this.currentTab)) {
                    SelectQuery query = this.getSelectQuery(rundata, context);
                    this.buildSelectQueryForListView(query);
                    this.buildSelectQueryForListViewSort(query, rundata, context);
                    list = this.dataContext.performQuery((Query)query);
                    break block4;
                }
                logger.info((Object)"unknown_addressTab_selected");
                return new ArrayList();
            }
            catch (Exception ex) {
                logger.error((Object)"Exception", (Throwable)ex);
                return null;
            }
        }
        return this.buildPaginatedList(list);
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(Object obj) {
        try {
            AddressBookResultData rd = new AddressBookResultData();
            if ("syagai".equals(this.currentTab)) {
                EipMAddressbook record = (EipMAddressbook)obj;
                rd.initField();
                rd.setAddressId(record.getAddressId());
                rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
                EipMAddressbookCompany company = record.getEipMAddressbookCompany();
                if (company.getCompanyId() > 1) {
                    rd.setCompanyId(company.getCompanyId().toString());
                    rd.setCompanyName(ALCommonUtils.compressString((String)company.getCompanyName(), (int)this.getStrLength()));
                    rd.setPostName(ALCommonUtils.compressString((String)company.getPostName(), (int)this.getStrLength()));
                }
                rd.setPositionName(ALCommonUtils.compressString((String)record.getPositionName(), (int)this.getStrLength()));
                rd.setEmail(ALCommonUtils.compressString((String)record.getEmail(), (int)this.getStrLength()));
                rd.setTelephone(record.getTelephone());
                rd.setCellularPhone(record.getCellularPhone());
                rd.setCellularMail(record.getCellularMail());
                rd.setPublicFlag(record.getPublicFlag());
            } else {
                TurbineUser record = (TurbineUser)obj;
                rd.initField();
                rd.setAddressId(record.getUserId());
                rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
                if (record.getCompanyId() > 0) {
                    rd.setCompanyName(ALCommonUtils.compressString((String)ALEipUtils.getCompanyName((int)record.getCompanyId()), (int)this.getStrLength()));
                }
                rd.setPostList((ArrayList)AddressBookUtils.getPostBeanList(record.getUserId()));
                if (record.getPositionId() > 0) {
                    rd.setPositionName(ALCommonUtils.compressString((String)ALEipUtils.getPositionName((int)record.getPositionId()), (int)this.getStrLength()));
                }
                rd.setEmail(ALCommonUtils.compressString((String)record.getEmail(), (int)this.getStrLength()));
                rd.setTelephone(record.getOutTelephone());
                rd.setCellularPhone(record.getCellularPhone());
                rd.setCellularMail(record.getCellularMail());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        String currentTab = this.getCurrentTab();
        if (currentTab == null || currentTab.trim().length() == 0 || "syagai".equals(currentTab)) {
            map.putValue("group", "eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID");
            map.putValue("name_kana", "lastNameKana");
            map.putValue("company_name_kana", "eipMAddressbookCompany.companyNameKana");
        } else {
            map.putValue("corp_group", "turbineUserGroupRole.turbineGroup.GROUP_NAME");
            map.putValue("name_kana", "lastNameKana");
        }
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = null;
        String word = this.searchWord.getValue();
        String transWord = ALStringUtil.convertHiragana2Katakana((String)ALStringUtil.convertH2ZKana((String)this.searchWord.getValue()));
        if ("syagai".equals(this.currentTab)) {
            query = new SelectQuery(EipMAddressbook.class);
            Expression exp01 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
            Expression exp02 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            Expression exp03 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
            query.setQualifier(exp01.orExp(exp02.andExp(exp03)));
            Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + word + "%"));
            Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + word + "%"));
            Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + word + "%"));
            Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + word + "%"));
            Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + word + "%"));
            Expression exp16 = ExpressionFactory.likeExp((String)"telephone", (Object)("%" + word + "%"));
            Expression exp17 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyName", (Object)("%" + word + "%"));
            Expression exp18 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyNameKana", (Object)("%" + word + "%"));
            Expression exp19 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.telephone", (Object)("%" + word + "%"));
            Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWord + "%"));
            Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWord + "%"));
            Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWord + "%"));
            Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWord + "%"));
            Expression exp35 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyName", (Object)("%" + transWord + "%"));
            Expression exp36 = ExpressionFactory.likeExp((String)"eipMAddressbookCompany.companyNameKana", (Object)("%" + transWord + "%"));
            query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp17).orExp(exp18).orExp(exp19).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35).orExp(exp36));
        } else if ("corp".equals(this.currentTab)) {
            query = new SelectQuery(TurbineUser.class);
            Expression exp01 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
            query.setQualifier(exp01);
            Expression exp02 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
            Expression exp03 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
            Expression exp04 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
            query.andQualifier(exp02.andExp(exp03).andExp(exp04));
            Expression exp11 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + word + "%"));
            Expression exp12 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + word + "%"));
            Expression exp13 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + word + "%"));
            Expression exp14 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + word + "%"));
            Expression exp15 = ExpressionFactory.likeExp((String)"email", (Object)("%" + word + "%"));
            Expression exp16 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + word + "%"));
            Expression exp31 = ExpressionFactory.likeExp((String)"firstName", (Object)("%" + transWord + "%"));
            Expression exp32 = ExpressionFactory.likeExp((String)"lastName", (Object)("%" + transWord + "%"));
            Expression exp33 = ExpressionFactory.likeExp((String)"firstNameKana", (Object)("%" + transWord + "%"));
            Expression exp34 = ExpressionFactory.likeExp((String)"lastNameKana", (Object)("%" + transWord + "%"));
            Expression exp35 = ExpressionFactory.likeExp((String)"turbineUserGroupRole.turbineGroup.groupAliasName", (Object)("%" + transWord + "%"));
            query.andQualifier(exp11.orExp(exp12).orExp(exp13).orExp(exp14).orExp(exp15).orExp(exp16).orExp(exp31).orExp(exp32).orExp(exp33).orExp(exp34).orExp(exp35));
        }
        return query;
    }

    public void loadGroups(RunData rundata, Context context) {
        this.groupList = new ArrayList();
        try {
            if ("syagai".equals(this.currentTab)) {
                SelectQuery query = new SelectQuery(EipMAddressGroup.class);
                Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
                query.setQualifier(exp);
                List aList = this.dataContext.performQuery((Query)query);
                int size = aList.size();
                for (int i = 0; i < size; ++i) {
                    EipMAddressGroup record = (EipMAddressGroup)aList.get(i);
                    AddressBookGroupResultData rd = new AddressBookGroupResultData();
                    rd.initField();
                    rd.setGroupId(record.getGroupId().longValue());
                    rd.setGroupName(record.getGroupName());
                    this.groupList.add(rd);
                }
            } else if ("corp".equals(this.currentTab)) {
                List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
                this.myGroupList = new ArrayList();
                int length = myGroups.size();
                for (int i = 0; i < length; ++i) {
                    this.myGroupList.add(myGroups.get(i));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public ALStringField getSearchWord() {
        return this.searchWord;
    }

    public ArrayList getGroupList() {
        return this.groupList;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    public String getAclPortletFeature() {
        return this.aclPortletFeature;
    }
}

