/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookGroupSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookGroupSelectData.class.getName());

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"group_name");
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return AddressBookUtils.getEipMAddressGroup(rundata, context);
    }

    protected Object getResultData(Object obj) {
        try {
            EipMAddressGroup record = (EipMAddressGroup)obj;
            AddressBookGroupResultData rd = new AddressBookGroupResultData();
            rd.initField();
            rd.setGroupId(record.getGroupId().longValue());
            rd.setGroupName(record.getGroupName());
            rd.setPublicFlag(record.getPublicFlag());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        return this.getResultData(obj);
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group_name", "groupName");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipMAddressGroup.class);
        Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
        query.setQualifier(exp);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public List getGroupMemberList(String gid) {
        return AddressBookUtils.getGroupMember(gid);
    }

    public String getAclPortletFeature() {
        return "addressbook_company_group";
    }
}

