/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipTAddressbookGroupMap;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookGroupMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookGroupMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            Expression exp1 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.inDbExp((String)"GROUP_ID", (Collection)values);
            query.andQualifier(exp2);
            List groups = dataContext.performQuery((Query)query);
            int grouplistsize = groups.size();
            for (int i = 0; i < grouplistsize; ++i) {
                EipMAddressGroup group = (EipMAddressGroup)groups.get(i);
                Integer entityId = group.getGroupId();
                String groupName = group.getGroupName();
                dataContext.deleteObject((Persistent)group);
                dataContext.commitChanges();
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 162, groupName);
            }
            SelectQuery mapquery = new SelectQuery(EipTAddressbookGroupMap.class);
            Expression mapexp = ExpressionFactory.matchDbExp((String)"GROUP_ID", (Object)ALEipUtils.getUserId((RunData)rundata));
            mapquery.setQualifier(mapexp);
            List maps = dataContext.performQuery((Query)mapquery);
            dataContext.deleteObjects((Collection)maps);
            dataContext.commitChanges();
            String filtername = AddressBookFilterdSelectData.class.getName() + "filter";
            ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)filtername);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "addressbook_company_group";
    }
}

