/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.addressbook.AddressBookGroupResultData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressGroup;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookFilterdSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookFilterdSelectData.class.getName());
    private String currentTab;
    private ArrayList groupList;
    private String index;
    private String syagaiGroup;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"syagai");
            this.currentTab = "syagai";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        try {
            return AddressBookUtils.getEipMAddressbook(rundata, context);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(Object obj) {
        try {
            EipMAddressbook record = (EipMAddressbook)obj;
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            rd.setAddressId(record.getAddressId());
            rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
            EipMAddressbookCompany company = record.getEipMAddressbookCompany();
            if (company.getCompanyId() > 1) {
                rd.setCompanyName(ALCommonUtils.compressString((String)company.getCompanyName(), (int)this.getStrLength()));
                rd.setCompanyId(company.getCompanyId().toString());
                rd.setPostName(ALCommonUtils.compressString((String)company.getPostName(), (int)this.getStrLength()));
            }
            rd.setPositionName(ALCommonUtils.compressString((String)record.getPositionName(), (int)this.getStrLength()));
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPublicFlag(record.getPublicFlag());
            rd.setIndex(this.index);
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            String updatedUserName;
            EipMAddressbook record = (EipMAddressbook)obj;
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            ALEipUser createdUser = ALEipUtils.getALEipUser((int)record.getCreateUserId());
            String createdUserName = createdUser.getAliasName().getValue();
            rd.setCreatedUser(createdUserName);
            if (record.getCreateUserId().equals(record.getUpdateUserId())) {
                updatedUserName = createdUserName;
            } else {
                ALEipUser updatedUser = ALEipUtils.getALEipUser((int)record.getUpdateUserId());
                updatedUserName = updatedUser.getAliasName().getValue();
            }
            rd.setUpdatedUser(updatedUserName);
            int addressId = record.getAddressId();
            rd.setAddressId(addressId);
            rd.setName(new StringBuffer().append(record.getLastName()).append(' ').append(record.getFirstName()).toString());
            rd.setNameKana(new StringBuffer().append(record.getLastNameKana()).append(' ').append(record.getFirstNameKana()).toString());
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPositionName(record.getPositionName());
            rd.setPublicFlag(record.getPublicFlag());
            EipMAddressbookCompany company = record.getEipMAddressbookCompany();
            if (company.getCompanyId() > 1) {
                rd.setCompanyName(company.getCompanyName());
                rd.setCompanyNameKana(company.getCompanyNameKana());
                rd.setPostName(company.getPostName());
                rd.setZipcode(company.getZipcode());
                rd.setCompanyAddress(company.getAddress());
                rd.setCompanyTelephone(company.getTelephone());
                rd.setCompanyFaxNumber(company.getFaxNumber());
                rd.setCompanyUrl(company.getUrl());
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getUpdateDate(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("group", "eipTAddressbookGroupMap.eipTAddressGroup.GROUP_ID");
        map.putValue("name_kana", "lastNameKana");
        map.putValue("company_name_kana", "eipMAddressbookCompany.companyNameKana");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipMAddressbook.class);
        Expression exp21 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"T");
        Expression exp22 = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
        Expression exp23 = ExpressionFactory.matchExp((String)"publicFlag", (Object)"F");
        query.setQualifier(exp21.orExp(exp22.andExp(exp23)));
        String index_session = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR);
        String index_rundata = rundata.getParameters().getString("idx");
        if (index_rundata != null) {
            if (index_rundata == "-1") {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR, null);
                context.put("idx", (Object)"-1");
            } else {
                this.index = index_rundata;
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR, (String)this.index);
                this.buildSelectQueryForAddressbookIndex(query, "lastNameKana", Integer.parseInt(this.index));
                context.put("idx", (Object)this.index);
            }
        } else if (index_session != null) {
            this.buildSelectQueryForAddressbookIndex(query, "lastNameKana", Integer.parseInt(index_session));
            context.put("idx", (Object)this.index);
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public ArrayList getGroupList() {
        return this.groupList;
    }

    public String getIndex() {
        return this.index;
    }

    public void loadGroups(RunData rundata, Context context) {
        this.groupList = new ArrayList();
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipMAddressGroup.class);
            Expression exp = ExpressionFactory.matchExp((String)"ownerId", (Object)ALEipUtils.getUserId((RunData)rundata));
            query.setQualifier(exp);
            List aList = dataContext.performQuery((Query)query);
            int size = aList.size();
            for (int i = 0; i < size; ++i) {
                EipMAddressGroup record = (EipMAddressGroup)aList.get(i);
                AddressBookGroupResultData rd = new AddressBookGroupResultData();
                rd.initField();
                rd.setGroupId(record.getGroupId().intValue());
                rd.setGroupName(record.getGroupName());
                this.groupList.add(rd);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    private void buildSelectQueryForAddressbookIndex(SelectQuery query, String lastNameKana, int idx) {
        switch (idx) {
            case 1: {
                Expression exp01 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30a2");
                Expression exp02 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ab");
                query.andQualifier(exp01.andExp(exp02));
                break;
            }
            case 6: {
                Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ab");
                Expression exp12 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30b5");
                query.andQualifier(exp11.andExp(exp12));
                break;
            }
            case 11: {
                Expression exp21 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30b5");
                Expression exp22 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30bf");
                query.andQualifier(exp21.andExp(exp22));
                break;
            }
            case 16: {
                Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30bf");
                Expression exp32 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ca");
                query.andQualifier(exp31.andExp(exp32));
                break;
            }
            case 21: {
                Expression exp41 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ca");
                Expression exp42 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30cf");
                query.andQualifier(exp41.andExp(exp42));
                break;
            }
            case 26: {
                Expression exp51 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30cf");
                Expression exp52 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30de");
                query.andQualifier(exp51.andExp(exp52));
                break;
            }
            case 31: {
                Expression exp61 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30de");
                Expression exp62 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30e4");
                query.andQualifier(exp61.andExp(exp62));
                break;
            }
            case 36: {
                Expression exp71 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30e4");
                Expression exp72 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30e9");
                query.andQualifier(exp71.andExp(exp72));
                break;
            }
            case 41: {
                Expression exp81 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30e9");
                Expression exp82 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ef");
                query.andQualifier(exp81.andExp(exp82));
                break;
            }
            case 46: {
                Expression exp91 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ef");
                Expression exp92 = ExpressionFactory.lessOrEqualExp((String)lastNameKana, (Object)"\u30f4");
                query.andQualifier(exp91.andExp(exp92));
                break;
            }
            case 52: {
                Expression exp100 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30a2");
                Expression exp101 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30f4");
                query.andQualifier(exp100.orExp(exp101));
            }
        }
    }

    public String getAclPortletFeature() {
        return "addressbook_address_outside";
    }
}

