/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.commons.utils.ALDateUtil;
import com.aimluck.eip.addressbook.AddressBookFilterdSelectData;
import com.aimluck.eip.addressbook.AddressBookResultData;
import com.aimluck.eip.addressbook.util.AddressBookUtils;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCorpFilterdSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookFilterdSelectData.class.getName());
    private String currentTab;
    private String index;
    private String corpGroup;
    private List myGroupList = null;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"name_kana");
        }
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"corp");
            this.currentTab = "corp";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
        super.init(action, rundata, context);
    }

    public void loadMygroupList(RunData rundata, Context context) {
        try {
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add(myGroups.get(i));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
        }
    }

    protected List selectList(RunData rundata, Context context) {
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        try {
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        try {
            String userId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (userId == null || Integer.valueOf(userId) == null) {
                return null;
            }
            return ALEipUtils.getBaseUser((int)Integer.valueOf(userId));
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(Object obj) {
        try {
            TurbineUser record = (TurbineUser)obj;
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            rd.setAddressId(record.getUserId());
            rd.setName(new StringBuffer().append(record.getLastName()).append(" ").append(record.getFirstName()).toString());
            if (record.getCompanyId() > 0) {
                rd.setCompanyName(ALCommonUtils.compressString((String)ALEipUtils.getCompanyName((int)record.getCompanyId()), (int)this.getStrLength()));
            }
            rd.setPostList((ArrayList)AddressBookUtils.getPostBeanList(record.getUserId()));
            if (record.getPositionId() > 0) {
                rd.setPositionName(ALCommonUtils.compressString((String)ALEipUtils.getPositionName((int)record.getPositionId()), (int)this.getStrLength()));
            }
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getOutTelephone());
            rd.setInTelephone(record.getInTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            ALBaseUser record = (ALBaseUser)obj;
            AddressBookResultData rd = new AddressBookResultData();
            rd.initField();
            int userId = Integer.valueOf(record.getUserId());
            rd.setAddressId(userId);
            rd.setName(new StringBuffer().append(record.getLastName()).append(' ').append(record.getFirstName()).toString());
            rd.setNameKana(new StringBuffer().append(record.getLastNameKana()).append(' ').append(record.getFirstNameKana()).toString());
            rd.setEmail(record.getEmail());
            rd.setTelephone(record.getOutTelephone());
            rd.setInTelephone(record.getInTelephone());
            rd.setCellularPhone(record.getCellularPhone());
            rd.setCellularMail(record.getCellularMail());
            rd.setPostList((ArrayList)AddressBookUtils.getPostBeanList(userId));
            if (record.getPositionId() > 0) {
                rd.setPositionName(ALCommonUtils.compressString((String)ALEipUtils.getPositionName((int)record.getPositionId()), (int)this.getStrLength()));
            }
            rd.setCreateDate(ALDateUtil.format((Date)record.getCreated(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            rd.setUpdateDate(ALDateUtil.format((Date)record.getModified(), (String)"yyyy\u5e74M\u6708d\u65e5"));
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("corp_group", "turbineUserGroupRole.turbineGroup.GROUP_NAME");
        map.putValue("name_kana", "lastNameKana");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(TurbineUser.class);
        Expression exp11 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.setQualifier(exp11);
        Expression exp21 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp22 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp23 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.andQualifier(exp21.andExp(exp22).andExp(exp23));
        if (rundata.getParameters().getString("idx") != null) {
            this.index = rundata.getParameters().getString("idx");
            this.buildSelectQueryForAddressbookUserIndex(query, "lastNameKana", Integer.parseInt(rundata.getParameters().getString("idx")));
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    public String getIndex() {
        return this.index;
    }

    private void buildSelectQueryForAddressbookUserIndex(SelectQuery query, String lastNameKana, int idx) {
        switch (idx) {
            case 1: {
                Expression exp01 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30a2");
                Expression exp02 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ab");
                query.andQualifier(exp01.andExp(exp02));
                break;
            }
            case 6: {
                Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ab");
                Expression exp12 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30b5");
                query.andQualifier(exp11.andExp(exp12));
                break;
            }
            case 11: {
                Expression exp21 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30b5");
                Expression exp22 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30bf");
                query.andQualifier(exp21.andExp(exp22));
                break;
            }
            case 16: {
                Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30bf");
                Expression exp32 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ca");
                query.andQualifier(exp31.andExp(exp32));
                break;
            }
            case 21: {
                Expression exp41 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ca");
                Expression exp42 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30cf");
                query.andQualifier(exp41.andExp(exp42));
                break;
            }
            case 26: {
                Expression exp51 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30cf");
                Expression exp52 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30de");
                query.andQualifier(exp51.andExp(exp52));
                break;
            }
            case 31: {
                Expression exp61 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30de");
                Expression exp62 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30e4");
                query.andQualifier(exp61.andExp(exp62));
                break;
            }
            case 36: {
                Expression exp71 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30e4");
                Expression exp72 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30e9");
                query.andQualifier(exp71.andExp(exp72));
                break;
            }
            case 41: {
                Expression exp81 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30e9");
                Expression exp82 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30ef");
                query.andQualifier(exp81.andExp(exp82));
                break;
            }
            case 46: {
                Expression exp91 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30ef");
                Expression exp92 = ExpressionFactory.lessOrEqualExp((String)lastNameKana, (Object)"\u30f4");
                query.andQualifier(exp91.andExp(exp92));
                break;
            }
            case 52: {
                Expression exp100 = ExpressionFactory.lessExp((String)lastNameKana, (Object)"\u30a2");
                Expression exp101 = ExpressionFactory.greaterOrEqualExp((String)lastNameKana, (Object)"\u30f4");
                query.andQualifier(exp100.orExp(exp101));
            }
        }
    }

    public String getAclPortletFeature() {
        return "addressbook_address_inside";
    }
}

