/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.addressbook.AddressBookCompanyResultData;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCompanySelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookCompanySelectData.class.getName());
    private String index;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)"company_name_kana");
        }
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        try {
            String companyId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
            if (companyId == null || Integer.valueOf(companyId) == null) {
                return null;
            }
            AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
            rd.initField();
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            EipMAddressbookCompany record = (EipMAddressbookCompany)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipMAddressbookCompany.class, (Object)Integer.valueOf(companyId));
            return record;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultData(Object obj) {
        try {
            EipMAddressbookCompany record = (EipMAddressbookCompany)obj;
            AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
            rd.initField();
            rd.setCompanyId(record.getCompanyId().intValue());
            rd.setCompanyName(ALCommonUtils.compressString((String)record.getCompanyName(), (int)this.getStrLength()));
            rd.setCompanyNameKana(record.getCompanyNameKana());
            rd.setPostName(ALCommonUtils.compressString((String)record.getPostName(), (int)this.getStrLength()));
            rd.setZipcode(record.getZipcode());
            rd.setAddress(ALCommonUtils.compressString((String)record.getAddress(), (int)this.getStrLength()));
            rd.setTelephone(record.getTelephone());
            rd.setFaxNumber(record.getFaxNumber());
            rd.setUrl(record.getUrl());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        try {
            EipMAddressbookCompany record = (EipMAddressbookCompany)obj;
            AddressBookCompanyResultData rd = new AddressBookCompanyResultData();
            rd.initField();
            rd.setCompanyId(record.getCompanyId().intValue());
            rd.setCompanyName(record.getCompanyName());
            rd.setCompanyNameKana(record.getCompanyNameKana());
            rd.setPostName(record.getPostName());
            rd.setZipcode(record.getZipcode());
            rd.setAddress(record.getAddress());
            rd.setTelephone(record.getTelephone());
            rd.setFaxNumber(record.getFaxNumber());
            rd.setUrl(record.getUrl());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("company_name_kana", "companyNameKana");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipMAddressbookCompany.class);
        Expression exp12 = ExpressionFactory.noMatchExp((String)"companyName", (Object)"\u672a\u5206\u985e");
        query.setQualifier(exp12);
        String index_session = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR);
        String index_rundata = rundata.getParameters().getString("idx");
        if (index_rundata != null) {
            this.index = index_rundata;
            if (index_rundata != "-1") {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR, (String)this.index);
                this.buildSelectQueryForAddressbookIndex(query, "companyNameKana", Integer.parseInt(this.index));
            } else {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_INDEX_STR, null);
            }
            context.put("idx", (Object)this.index);
        } else if (index_session != null) {
            this.buildSelectQueryForAddressbookIndex(query, "companyNameKana", Integer.parseInt(index_session));
            context.put("idx", (Object)index_session);
        } else {
            context.put("idx", (Object)"-1");
        }
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    public String getIndex() {
        return this.index;
    }

    private void buildSelectQueryForAddressbookIndex(SelectQuery query, String companyNameKana, int idx) {
        switch (idx) {
            case 1: {
                Expression exp01 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30a2");
                Expression exp02 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30ab");
                query.andQualifier(exp01.andExp(exp02));
                break;
            }
            case 6: {
                Expression exp11 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30ab");
                Expression exp12 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30b5");
                query.andQualifier(exp11.andExp(exp12));
                break;
            }
            case 11: {
                Expression exp21 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30b5");
                Expression exp22 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30bf");
                query.andQualifier(exp21.andExp(exp22));
                break;
            }
            case 16: {
                Expression exp31 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30bf");
                Expression exp32 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30ca");
                query.andQualifier(exp31.andExp(exp32));
                break;
            }
            case 21: {
                Expression exp41 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30ca");
                Expression exp42 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30cf");
                query.andQualifier(exp41.andExp(exp42));
                break;
            }
            case 26: {
                Expression exp51 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30cf");
                Expression exp52 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30de");
                query.andQualifier(exp51.andExp(exp52));
                break;
            }
            case 31: {
                Expression exp61 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30de");
                Expression exp62 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30e4");
                query.andQualifier(exp61.andExp(exp62));
                break;
            }
            case 36: {
                Expression exp71 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30e4");
                Expression exp72 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30e9");
                query.andQualifier(exp71.andExp(exp72));
                break;
            }
            case 41: {
                Expression exp81 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30e9");
                Expression exp82 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30ef");
                query.andQualifier(exp81.andExp(exp82));
                break;
            }
            case 46: {
                Expression exp91 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30ef");
                Expression exp92 = ExpressionFactory.lessOrEqualExp((String)companyNameKana, (Object)"\u30f4");
                query.andQualifier(exp91.andExp(exp92));
                break;
            }
            case 52: {
                Expression exp100 = ExpressionFactory.lessExp((String)companyNameKana, (Object)"\u30a2");
                Expression exp101 = ExpressionFactory.greaterOrEqualExp((String)companyNameKana, (Object)"\u30f4");
                query.andQualifier(exp100.orExp(exp101));
            }
        }
    }

    public String getAclPortletFeature() {
        return "addressbook_company";
    }
}

