/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.addressbook;

import com.aimluck.eip.cayenne.om.portlet.EipMAddressbook;
import com.aimluck.eip.cayenne.om.portlet.EipMAddressbookCompany;
import com.aimluck.eip.common.ALAbstractCheckList;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.DataObjectUtils;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class AddressBookCompanyMultiDelete
extends ALAbstractCheckList {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)AddressBookCompanyMultiDelete.class.getName());

    protected boolean action(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery addrquery = new SelectQuery(EipMAddressbook.class);
            Expression addrexp = ExpressionFactory.inDbExp((String)"eipMAddressbookCompany.COMPANY_ID", (Collection)values);
            addrquery.setQualifier(addrexp);
            List addresses = dataContext.performQuery((Query)addrquery);
            if (addresses != null && addresses.size() > 0) {
                EipMAddressbook addressbook = null;
                EipMAddressbookCompany company = (EipMAddressbookCompany)DataObjectUtils.objectForPK((ObjectContext)dataContext, EipMAddressbookCompany.class, (Object)1);
                int addrsize = addresses.size();
                for (int i = 0; i < addrsize; ++i) {
                    addressbook = (EipMAddressbook)addresses.get(i);
                    addressbook.setEipMAddressbookCompany(company);
                }
            }
            SelectQuery query = new SelectQuery(EipMAddressbookCompany.class);
            Expression exp = ExpressionFactory.inDbExp((String)"COMPANY_ID", (Collection)values);
            query.setQualifier(exp);
            List groups = dataContext.performQuery((Query)query);
            int grouplistsize = groups.size();
            for (int i = 0; i < grouplistsize; ++i) {
                EipMAddressbookCompany group = (EipMAddressbookCompany)groups.get(i);
                Integer entityId = group.getCompanyId();
                String groupName = group.getCompanyName();
                dataContext.deleteObject((Persistent)group);
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(entityId.intValue(), 161, groupName);
            }
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    protected int getDefineAclType() {
        return 16;
    }

    public String getAclPortletFeature() {
        return "addressbook_company";
    }
}

