/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note.util;

import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.security.TurbineGroup;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.profile.Portlets;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.util.template.JetspeedLink;
import org.apache.jetspeed.util.template.JetspeedLinkFactory;
import org.apache.turbine.util.DynamicURI;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteUtils.class.getName());
    public static final String DATE_TIME_FORMAT = "yyyy/MM/dd HH:mm";
    public static final String CREATED_DATE_FORMAT = "yyyy/MM/dd";
    public static final String TARGET_GROUP_NAME = "target_group_name";
    public static final String TARGET_USER_ID = "target_user_id";
    public static final String NOTE_VIEW_TYPE = "note_view_type";
    public static final String NOTE_VIEW_TYPE_LIST = "note_view_list";
    public static final String NOTE_VIEW_TYPE_GROUP = "note_view_group";
    public static final String NOTE_STAT_NEW = "1";
    public static final String NOTE_STAT_UNREAD = "2";
    public static final String NOTE_STAT_READ = "3";
    public static final String NOTE_STAT_DELETED = "4";

    public static EipTNote getEipTNoteDetail(RunData rundata, Context context, SelectQuery query) {
        String noteId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        int uid = ALEipUtils.getUserId((RunData)rundata);
        try {
            WhatsNewUtils.shiftWhatsNewReadFlag((int)5, (int)Integer.parseInt(noteId), (int)uid);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
        SelectQuery query1 = new SelectQuery(EipTNoteMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"noteId", (Object)Integer.valueOf(noteId));
        Expression exp2 = ExpressionFactory.matchExp((String)"userId", (Object)uid);
        query1.setQualifier(exp1.andExp(exp2));
        List maps = dataContext.performQuery((Query)query1);
        if (maps == null || maps.size() == 0) {
            logger.debug((Object)"[Note] Invalid user access...");
            return null;
        }
        try {
            if (noteId == null || noteId.equals("") || Integer.valueOf(noteId) == null) {
                logger.debug((Object)"[Note] Empty NoteID...");
                return null;
            }
            Expression exp = ExpressionFactory.matchDbExp((String)"NOTE_ID", (Object)Integer.valueOf(noteId));
            query.andQualifier(exp);
            List notes = dataContext.performQuery((Query)query);
            if (notes == null || notes.size() == 0) {
                logger.debug((Object)"[Note] Not found NoteID...");
                return null;
            }
            return (EipTNote)notes.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static EipTNoteMap getEipTNoteMap(RunData rundata, Context context, SelectQuery query) {
        String noteId = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (noteId == null || noteId.equals("") || Integer.valueOf(noteId) == null) {
                logger.debug((Object)"[Note] Empty NoteID...");
                return null;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            Expression exp1 = ExpressionFactory.matchDbExp((String)"NOTE_ID", (Object)noteId);
            query.andQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"delFlg", (Object)"F");
            query.andQualifier(exp2);
            List maps = dataContext.performQuery((Query)query);
            if (maps == null || maps.size() == 0) {
                logger.debug((Object)"[Note] Not found NoteID...");
                return null;
            }
            return (EipTNoteMap)maps.get(0);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static List getEipTNoteMapList(RunData rundata, Context context, boolean tabReceive, String[] nodeIds) {
        if (nodeIds == null) {
            return null;
        }
        try {
            Expression exp2;
            Integer userid = ALEipUtils.getUserId((RunData)rundata);
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(EipTNoteMap.class);
            Expression exp1 = ExpressionFactory.inDbExp((String)"NOTE_ID", (Object[])nodeIds);
            query.setQualifier(exp1);
            if (tabReceive) {
                exp2 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)userid);
                query.andQualifier(exp3);
            } else {
                exp2 = ExpressionFactory.matchExp((String)"userId", (Object)userid);
                query.andQualifier(exp2);
                Expression exp3 = ExpressionFactory.matchExp((String)"eipTNote.ownerId", (Object)userid);
                query.andQualifier(exp3);
            }
            List noteMaps = dataContext.performQuery((Query)query);
            if (noteMaps == null || noteMaps.size() == 0) {
                logger.debug((Object)"[Note] Not found NoteIDs...");
                return null;
            }
            return noteMaps;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getUserId(String userLoginName) {
        if (userLoginName == null || userLoginName.equals("")) {
            return null;
        }
        String userId = null;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(TurbineUser.class);
            Expression exp = ExpressionFactory.matchExp((String)"loginName", (Object)userLoginName);
            query.setQualifier(exp);
            List destUserList = dataContext.performQuery((Query)query);
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            userId = ((TurbineUser)destUserList.get(0)).getUserId().toString();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return userId;
    }

    public static String getUserName(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        String userName = null;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = new SelectQuery(TurbineUser.class);
            Expression exp = ExpressionFactory.matchDbExp((String)"USER_ID", (Object)Integer.valueOf(userId));
            query.setQualifier(exp);
            List destUserList = dataContext.performQuery((Query)query);
            if (destUserList == null || destUserList.size() <= 0) {
                return null;
            }
            userName = ((TurbineUser)destUserList.get(0)).getLoginName();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return userName;
    }

    public static TurbineGroup getGroup(RunData rundata, Context context) {
        String id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"entityid");
        try {
            if (id == null) {
                logger.debug((Object)"Empty ID...");
                return null;
            }
            return (TurbineGroup)JetspeedSecurity.getGroup((String)id);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static Integer string2integer(String str) {
        Integer integ = null;
        try {
            integ = Integer.valueOf(str);
        }
        catch (NumberFormatException ex) {
            integ = null;
        }
        return integ;
    }

    public static String getTargetGroupName(RunData rundata, Context context) {
        String target_group_name = null;
        String idParam = rundata.getParameters().getString(TARGET_GROUP_NAME);
        target_group_name = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME);
        if (idParam == null && target_group_name == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)"all");
            target_group_name = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_GROUP_NAME, (String)idParam);
            target_group_name = idParam;
        }
        return target_group_name;
    }

    public static String getTargetUserId(RunData rundata, Context context) {
        String target_user_id = null;
        String idParam = rundata.getParameters().getString(TARGET_USER_ID);
        target_user_id = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID);
        if (idParam == null && target_user_id == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)"all");
            target_user_id = "all";
        } else if (idParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)TARGET_USER_ID, (String)idParam);
            target_user_id = idParam;
        }
        return target_user_id;
    }

    public static boolean deleteNotes(RunData rundata, Context context, ArrayList values, ArrayList msgList) {
        boolean tabReceive = true;
        String currentTab = NoteUtils.getCurrentTab(rundata, context);
        tabReceive = "received_notes".equals(currentTab);
        try {
            String user_id = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            if (user_id == null) {
                return false;
            }
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            String[] noteIds = new String[values.size()];
            List eipTNoteMaps = NoteUtils.getEipTNoteMapList(rundata, context, tabReceive, noteIds = values.toArray(noteIds));
            if (eipTNoteMaps == null) {
                return false;
            }
            int length = eipTNoteMaps.size();
            for (int i = 0; i < length; ++i) {
                EipTNoteMap noteMap = (EipTNoteMap)eipTNoteMaps.get(i);
                EipTNote tmpnote = noteMap.getEipTNote();
                SelectQuery mapquery = new SelectQuery(EipTNoteMap.class);
                Expression mapexp = ExpressionFactory.matchExp((String)"noteId", (Object)tmpnote.getNoteId());
                mapquery.setQualifier(mapexp);
                List maplist = dataContext.performQuery((Query)mapquery);
                if (maplist == null || maplist.size() <= 0) continue;
                int count = 0;
                int size = maplist.size();
                for (int j = 0; j < size; ++j) {
                    EipTNoteMap tmpmap = (EipTNoteMap)maplist.get(j);
                    if (!"T".equals(tmpmap.getDelFlg())) continue;
                    ++count;
                }
                if (count == size - 1) {
                    dataContext.deleteObject((Persistent)noteMap.getEipTNote());
                } else {
                    noteMap.setDelFlg("T");
                }
                ALEventlogFactoryService.getInstance().getEventlogHandler().log(noteMap.getEipTNote().getNoteId().intValue(), 140, NoteUtils.getNoteSubject(noteMap.getEipTNote()));
            }
            dataContext.commitChanges();
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static String getNoteSubject(EipTNote note) {
        String subject = "";
        if (note.getSubjectType().equals("0")) {
            subject = note.getCustomSubject();
        } else if (note.getSubjectType().equals(NOTE_STAT_NEW)) {
            subject = "\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059";
        } else if (note.getSubjectType().equals(NOTE_STAT_UNREAD)) {
            subject = "\u96fb\u8a71\u3092\u3057\u3066\u304f\u3060\u3055\u3044";
        } else if (note.getSubjectType().equals(NOTE_STAT_READ)) {
            subject = "\u96fb\u8a71\u304c\u3042\u308a\u307e\u3057\u305f";
        } else if (note.getSubjectType().equals(NOTE_STAT_DELETED)) {
            subject = "\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059";
        }
        return subject + " (" + note.getClientName() + ")";
    }

    public static String getCurrentTab(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        String currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
            currentTab = "received_notes";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            currentTab = tabParam;
        }
        return currentTab;
    }

    public static SelectQuery getSelectQueryNoteList(RunData rundata, Context context) {
        String userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        SelectQuery query = new SelectQuery(EipTNoteMap.class);
        Expression exp01 = ExpressionFactory.matchExp((String)"noteStat", (Object)NOTE_STAT_NEW);
        Expression exp02 = ExpressionFactory.matchExp((String)"noteStat", (Object)NOTE_STAT_UNREAD);
        query.setQualifier(exp01.orExp(exp02));
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(userId));
        query.andQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"delFlg", (Object)"F");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)Integer.valueOf(userId));
        query.andQualifier(exp3);
        return query;
    }

    public static int getNewReceivedNoteAllSum(RunData rundata, String userId) {
        int newNoteAllSum = 0;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = NoteUtils.getSelectQueryForNewReceivedNoteCount(userId);
            List list = dataContext.performQuery((Query)query);
            newNoteAllSum = list != null && list.size() > 0 ? list.size() : 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
        return newNoteAllSum;
    }

    private static SelectQuery getSelectQueryForNewReceivedNoteCount(String srcUserId) {
        try {
            SelectQuery query = new SelectQuery(EipTNote.class);
            Expression exp1 = ExpressionFactory.noMatchExp((String)"ownerId", (Object)Integer.valueOf(srcUserId));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTNoteMaps.userId", (Object)Integer.valueOf(srcUserId));
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTNoteMaps.delFlg", (Object)"F");
            query.andQualifier(exp3);
            Expression exp4 = ExpressionFactory.matchExp((String)"eipTNoteMaps.noteStat", (Object)NOTE_STAT_NEW);
            query.andQualifier(exp4);
            return query;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static int getUnreadReceivedNotesAllSum(RunData rundata, String userId) {
        int unreadNotesAllSum = 0;
        try {
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery query = NoteUtils.getSelectQueryForUnreadReceivedNoteCount(userId);
            List list = dataContext.performQuery((Query)query);
            unreadNotesAllSum = list != null && list.size() > 0 ? list.size() : 0;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return 0;
        }
        return unreadNotesAllSum;
    }

    private static SelectQuery getSelectQueryForUnreadReceivedNoteCount(String srcUserId) {
        try {
            SelectQuery query = new SelectQuery(EipTNote.class);
            Expression exp1 = ExpressionFactory.noMatchExp((String)"ownerId", (Object)Integer.valueOf(srcUserId));
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.matchExp((String)"eipTNoteMaps.userId", (Object)Integer.valueOf(srcUserId));
            query.andQualifier(exp2);
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTNoteMaps.delFlg", (Object)"F");
            query.andQualifier(exp3);
            Expression exp4 = ExpressionFactory.matchExp((String)"eipTNoteMaps.noteStat", (Object)NOTE_STAT_UNREAD);
            query.andQualifier(exp4);
            return query;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    public static String getPortletURIinPersonalConfigPane(RunData rundata, String portletEntryName) {
        try {
            Portlets portlets = ((JetspeedRunData)rundata).getProfile().getDocument().getPortlets();
            if (portlets == null) {
                return null;
            }
            Portlets[] portletList = portlets.getPortletsArray();
            if (portletList == null) {
                return null;
            }
            int length = portletList.length;
            for (int i = 0; i < length; ++i) {
                Entry[] entries = portletList[i].getEntriesArray();
                if (entries == null || entries.length <= 0) continue;
                int ent_length = entries.length;
                for (int j = 0; j < ent_length; ++j) {
                    if (!entries[j].getParent().equals(portletEntryName)) continue;
                    JetspeedLink jsLink = JetspeedLinkFactory.getInstance((RunData)rundata);
                    DynamicURI duri = jsLink.getLink(101, null, null, 101, null);
                    duri = duri.addPathInfo("js_pane", portletList[i].getId() + "," + entries[j].getId()).addQueryData("action", "controls.Restore");
                    return duri.toString();
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
        return null;
    }
}

