/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.NoteResultData;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteSelectData
extends ALAbstractSelectData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteSelectData.class.getName());
    private String currentTab;
    private String userId;
    private String target_group_name;
    private String target_user_id;
    private List myGroupList = null;
    private int unreadNotesAllSum = 0;
    private int newNoteAllSum = 0;
    private Map statusList;
    private List members;
    private String mailAccountURI;
    private String userAccountURI;
    private int uid;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        this.setCurrentTab(rundata, context);
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            String sortkey = null;
            sortkey = "received_notes".equals(this.getCurrentTab()) ? "p2a-sort" : "p2b-sort";
            sort = ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter(sortkey);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sort);
            logger.debug((Object)("Init Parameter (Note) : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter(sortkey)));
        } else if ("received_notes".equals(this.getCurrentTab())) {
            if ("create_date".equals(sort)) {
                sort = "note_stat";
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sort);
            }
        } else if ("accept_date".equals(sort) || "note_stat".equals(sort)) {
            sort = "create_date";
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)sort);
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_TYPE_STR, (String)"desc");
        }
        this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.statusList = new HashMap();
        this.mailAccountURI = NoteUtils.getPortletURIinPersonalConfigPane(rundata, "WebMailAccountEdit");
        this.userAccountURI = NoteUtils.getPortletURIinPersonalConfigPane(rundata, "AccountEdit");
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.uid = ALEipUtils.getUserId((RunData)rundata);
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            this.target_group_name = NoteUtils.getTargetGroupName(rundata, context);
            this.target_user_id = NoteUtils.getTargetUserId(rundata, context);
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add(myGroups.get(i));
            }
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = this.dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) throws ALPageNotFoundException {
        EipTNote note;
        this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        this.setCurrentTab(rundata, context);
        if ("received_notes".equals(this.currentTab)) {
            this.unreadNotesAllSum = NoteUtils.getUnreadReceivedNotesAllSum(rundata, this.userId);
            this.newNoteAllSum = NoteUtils.getNewReceivedNoteAllSum(rundata, this.userId);
        }
        if ((note = NoteUtils.getEipTNoteDetail(rundata, context, this.getSelectQueryForDetail(rundata, context))) == null) {
            logger.debug((Object)"[NoteSelectData] This page cannot be loaded.");
            throw new ALPageNotFoundException();
        }
        return note;
    }

    protected Object getResultData(Object obj) {
        try {
            EipTNoteMap map = (EipTNoteMap)obj;
            EipTNote record = map.getEipTNote();
            String destUserNames = this.getDestUserNamesLimit(record);
            NoteResultData rd = new NoteResultData();
            rd.initField();
            rd.setNoteId(record.getNoteId().longValue());
            rd.setSrcUserId(record.getOwnerId());
            rd.setDestUserId(map.getUserId());
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(record.getOwnerId()));
            rd.setSrcUserFullName(user.getAliasName().getValue());
            rd.setDestUserFullName(destUserNames);
            rd.setClientName(ALCommonUtils.compressString((String)record.getClientName(), (int)this.getStrLength()));
            rd.setCompanyName(ALCommonUtils.compressString((String)record.getCompanyName(), (int)this.getStrLength()));
            rd.setTelephone(record.getTelephone());
            rd.setEmailAddress(record.getEmailAddress());
            if (record.getAddDestType().equals("1")) {
                rd.setAddDestTypePc("1");
            } else if (record.getAddDestType().equals("2")) {
                rd.setAddDestTypeCellphone("1");
            } else if (record.getAddDestType().equals("3")) {
                rd.setAddDestTypePc("1");
                rd.setAddDestTypeCellphone("1");
            }
            rd.setSubjectType(record.getSubjectType());
            if ("0".equals(record.getSubjectType())) {
                rd.setCustomSubject(ALCommonUtils.compressString((String)record.getCustomSubject(), (int)this.getStrLength()));
            }
            rd.setMessage(record.getMessage());
            rd.setAcceptDate(record.getAcceptDate());
            rd.setConfirmDate(map.getConfirmDate());
            rd.setCreateDate(record.getCreateDate());
            rd.setUpdateDate(record.getUpdateDate());
            if ("1".equals(map.getNoteStat())) {
                rd.setNoteStat("1");
                rd.setNoteStatImage("images/note/note_new_message.gif");
                rd.setNoteStatImageDescription("\u65b0\u7740");
            } else if ("2".equals(map.getNoteStat())) {
                rd.setNoteStat("2");
                rd.setNoteStatImage("images/note/note_unread_message.gif");
                rd.setNoteStatImageDescription("\u672a\u8aad");
                ++this.unreadNotesAllSum;
            } else if ("3".equals(map.getNoteStat())) {
                rd.setNoteStat("3");
                rd.setNoteStatImage("images/note/note_read_message.gif");
                rd.setNoteStatImageDescription("\u65e2\u8aad");
            } else {
                rd.setNoteStat("4");
                rd.setNoteStatImage("images/note/note_deleted_message.gif");
                rd.setNoteStatImageDescription("\u524a\u9664\u6e08\u307f");
            }
            if (record.getMessage() == null || record.getMessage().equals("")) {
                rd.setHasMemo(false);
            } else {
                rd.setHasMemo(true);
            }
            if (map.getUserId().equals(this.userId) && !record.getOwnerId().equals(this.userId) && map.getNoteStat().equals("1")) {
                map.setNoteStat("2");
            }
            this.dataContext.commitChanges();
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            Date nowDate = Calendar.getInstance().getTime();
            EipTNoteMap map = null;
            EipTNote record = (EipTNote)obj;
            DataContext dataContext = DatabaseOrmService.getInstance().getDataContext();
            SelectQuery mapquery = new SelectQuery(EipTNoteMap.class);
            Expression mapexp = ExpressionFactory.matchExp((String)"noteId", (Object)record.getNoteId());
            mapquery.setQualifier(mapexp);
            List list = dataContext.performQuery((Query)mapquery);
            ArrayList<Integer> users = new ArrayList<Integer>();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                EipTNoteMap notemap = (EipTNoteMap)list.get(i);
                if (this.userId.equals(notemap.getUserId())) {
                    map = notemap;
                }
                if ("T".equals(notemap.getDelFlg())) {
                    this.statusList.put(Integer.valueOf(notemap.getUserId()), "4");
                } else {
                    this.statusList.put(Integer.valueOf(notemap.getUserId()), notemap.getNoteStat());
                }
                users.add(Integer.valueOf(notemap.getUserId()));
            }
            SelectQuery query = new SelectQuery(TurbineUser.class);
            Expression exp = ExpressionFactory.inDbExp((String)"USER_ID", users);
            query.setQualifier(exp);
            this.members = ALEipUtils.getUsersFromSelectQuery((SelectQuery)query);
            String destUserNames = "";
            NoteResultData rd = new NoteResultData();
            rd.initField();
            rd.setNoteId(record.getNoteId().longValue());
            rd.setSrcUserId(record.getOwnerId());
            rd.setDestUserId(map.getUserId());
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(record.getOwnerId()));
            rd.setSrcUserFullName(user.getAliasName().getValue());
            rd.setDestUserFullName(destUserNames);
            rd.setClientName(record.getClientName());
            rd.setCompanyName(record.getCompanyName());
            rd.setTelephone(record.getTelephone());
            rd.setEmailAddress(record.getEmailAddress());
            if (record.getAddDestType().equals("1")) {
                rd.setAddDestTypePc("1");
            } else if (record.getAddDestType().equals("2")) {
                rd.setAddDestTypeCellphone("1");
            } else if (record.getAddDestType().equals("3")) {
                rd.setAddDestTypePc("1");
                rd.setAddDestTypeCellphone("1");
            }
            rd.setSubjectType(record.getSubjectType());
            if ("0".equals(record.getSubjectType())) {
                rd.setCustomSubject(record.getCustomSubject());
            }
            rd.setMessage(record.getMessage());
            rd.setAcceptDate(record.getAcceptDate());
            rd.setCreateDate(record.getCreateDate());
            if (map.getUserId().equals(this.userId) && !record.getOwnerId().equals(this.userId)) {
                if (map.getConfirmDate() == null) {
                    map.setConfirmDate(nowDate);
                    rd.setConfirmDate(nowDate);
                } else {
                    rd.setConfirmDate(map.getConfirmDate());
                }
                if (map.getNoteStat().equals("3")) {
                    rd.setNoteStat(map.getNoteStat());
                } else {
                    map.setNoteStat("3");
                    rd.setNoteStat("3");
                }
                record.setUpdateDate(nowDate);
                rd.setUpdateDate(nowDate);
                dataContext.commitChanges();
            } else {
                rd.setConfirmDate(map.getConfirmDate());
                rd.setNoteStat(map.getNoteStat());
                rd.setUpdateDate(record.getUpdateDate());
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("client_name", "eipTNote.clientName");
        map.putValue("company_name", "eipTNote.companyName");
        map.putValue("subject_type", "eipTNote.subjectType");
        map.putValue("create_date", "eipTNote.createDate");
        map.putValue("confirm_date", "confirmDate");
        map.putValue("accept_date", "eipTNote.acceptDate");
        map.putValue("note_stat", "noteStat");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTNoteMap.class);
        Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)Integer.valueOf(this.userId));
        query.setQualifier(exp1);
        Expression exp2 = ExpressionFactory.matchExp((String)"delFlg", (Object)"F");
        query.andQualifier(exp2);
        if ("received_notes".equals(this.getCurrentTab())) {
            Expression exp3 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)Integer.valueOf(this.userId));
            query.andQualifier(exp3);
        } else {
            Expression exp3 = ExpressionFactory.matchExp((String)"eipTNote.ownerId", (Object)Integer.valueOf(this.userId));
            query.andQualifier(exp3);
        }
        return query;
    }

    private SelectQuery getSelectQueryForDetail(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(EipTNote.class);
        return query;
    }

    private String getDestUserNamesLimit(EipTNote note) throws ALDBErrorException {
        ALEipUser user;
        StringBuffer destUserNames = new StringBuffer();
        List mapList = note.getEipTNoteMaps();
        if (mapList == null || mapList.size() == 0) {
            logger.error((Object)"[NoteSelectData] DatabaseException");
            throw new ALDBErrorException();
        }
        int mapListSize = mapList.size();
        for (int i = 0; i < mapListSize; ++i) {
            EipTNoteMap tmpmap = (EipTNoteMap)mapList.get(i);
            if (!tmpmap.getUserId().equals(this.userId)) continue;
            mapList.remove(i);
            break;
        }
        if ((mapListSize = mapList.size()) >= 2) {
            EipTNoteMap tmpmap = (EipTNoteMap)mapList.get(0);
            user = ALEipUtils.getALEipUser((int)Integer.valueOf(tmpmap.getUserId()));
            destUserNames.append(user.getAliasName());
            destUserNames.append("\u3001\u30fb\u30fb\u30fb");
        } else {
            EipTNoteMap tmpmap = (EipTNoteMap)mapList.get(0);
            user = ALEipUtils.getALEipUser((int)Integer.valueOf(tmpmap.getUserId()));
            destUserNames.append(user.getAliasName());
        }
        return destUserNames.toString();
    }

    private void setCurrentTab(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
            this.currentTab = "received_notes";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public String getTargetUserId() {
        return this.target_user_id;
    }

    public String getUserName(String userId) {
        return NoteUtils.getUserName(userId);
    }

    public String getUserFullName(String userId) {
        try {
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(userId));
            return user.getAliasName().getValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getUserId(String userName) {
        return NoteUtils.getUserId(userName);
    }

    public List getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public int getNewNoteAllSum() {
        return this.newNoteAllSum;
    }

    public int getUnreadNotesAllSum() {
        return this.unreadNotesAllSum;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    public String getStatus(long id) {
        return (String)this.statusList.get((int)id);
    }

    public List getMemberList() {
        return this.members;
    }

    public String getMailAccountURI() {
        return this.mailAccountURI;
    }

    public String getUserAccountURI() {
        return this.userAccountURI;
    }
}

