/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.NoteGroupResultData;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteGroupSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteGroupSelectData.class.getName());
    private String currentTab;
    private String userId = null;
    private String userAliasName = null;
    private List myGroupList = null;
    private int unreadReceivedNotesAllSum = 0;
    private int newNoteAllSum = 0;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        super.init(action, rundata, context);
        try {
            VelocityPortlet portlet;
            String groupName;
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            if ((filter == null || filter.equals("")) && (groupName = (portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context)).getPortletConfig().getInitParameter("p3b-group")) != null) {
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR, (String)groupName);
                ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR, (String)"group");
            }
        }
        catch (Exception ex) {
            logger.debug((Object)"Exception", (Throwable)ex);
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
    }

    protected List selectList(RunData rundata, Context context) {
        this.setCurrentTab(rundata, context);
        try {
            this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            this.userAliasName = ALEipUtils.getALEipUser((RunData)rundata).getAliasName().toString();
            NoteUtils.getTargetGroupName(rundata, context);
            List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
            this.myGroupList = new ArrayList();
            int length = myGroups.size();
            for (int i = 0; i < length; ++i) {
                this.myGroupList.add(myGroups.get(i));
            }
            List list = this.dataContext.performQuery((Query)NoteUtils.getSelectQueryNoteList(rundata, context));
            if (list != null && list.size() > 0) {
                String stat = null;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    EipTNoteMap map = (EipTNoteMap)list.get(i);
                    stat = map.getNoteStat();
                    if ("1".equals(stat)) {
                        ++this.newNoteAllSum;
                        continue;
                    }
                    if (!"2".equals(stat)) continue;
                    ++this.unreadReceivedNotesAllSum;
                }
            }
            String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
            String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
            if (filter == null || filter_type == null || filter.equals("")) {
                return new ArrayList();
            }
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List ulist = this.dataContext.performQuery((Query)query);
            return this.buildPaginatedList(ulist);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        this.setCurrentTab(rundata, context);
        return null;
    }

    protected Object getResultData(Object obj) {
        try {
            TurbineUser user = (TurbineUser)obj;
            NoteGroupResultData rd = new NoteGroupResultData();
            rd.initField();
            rd.setUserId(user.getUserId());
            rd.setUserName(user.getLastName() + " " + user.getFirstName());
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("src_user", "lastNameKana");
        map.putValue("group", "turbineUserGroupRole.turbineGroup.groupName");
        map.putValue("userposition", "eipMUserPosition.position");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        SelectQuery query = new SelectQuery(TurbineUser.class);
        Expression exp11 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)1);
        Expression exp12 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)2);
        Expression exp13 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)3);
        query.setQualifier(exp11.andExp(exp12).andExp(exp13));
        Expression exp2 = ExpressionFactory.matchExp((String)"disabled", (Object)"F");
        query.andQualifier(exp2);
        Expression exp3 = ExpressionFactory.noMatchDbExp((String)"USER_ID", (Object)Integer.valueOf(this.userId));
        query.andQualifier(exp3);
        return this.buildSelectQueryForFilter(query, rundata, context);
    }

    protected SelectQuery buildSelectQueryForFilter(SelectQuery query, RunData rundata, Context context) {
        String filter = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_STR);
        String filter_type = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_FILTER_TYPE_STR);
        String crt_key = null;
        Attributes map = this.getColumnMap();
        if (filter == null || filter_type == null || filter.equals("")) {
            return query;
        }
        crt_key = map.getValue(filter_type);
        if (crt_key == null) {
            return query;
        }
        Expression exp = ExpressionFactory.matchExp((String)crt_key, (Object)filter);
        query.andQualifier(exp);
        this.current_filter = filter;
        this.current_filter_type = filter_type;
        return query;
    }

    private void setCurrentTab(RunData rundata, Context context) {
        String tabParam = rundata.getParameters().getString("tab");
        this.currentTab = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)"tab");
        if (tabParam == null && this.currentTab == null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
            this.currentTab = "received_notes";
        } else if (tabParam != null) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)tabParam);
            this.currentTab = tabParam;
        }
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserAliasName() {
        return this.userAliasName;
    }

    public int getNewNoteAllSum() {
        return this.newNoteAllSum;
    }

    public int getUnreadReceivedNotesAllSum() {
        return this.unreadReceivedNotesAllSum;
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }
}

