/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipManager;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.services.eventlog.ALEventlogFactoryService;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteFormData
extends ALAbstractFormData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteFormData.class.getName());
    private final int MSG_TYPE_NON_ADDR_PC = 1;
    private final int MSG_TYPE_NON_ADDR_CELL = 2;
    private final int MSG_TYPE_NON_ADDR_PC_CELL = 3;
    private final int MSG_TYPE_NON_RECIPIENT = 4;
    private final int MSG_TYPE_NON_MAILACCOUNT = 5;
    private ALNumberField note_id;
    private ALStringField src_user_id;
    private ALStringField dest_user_id;
    private ALStringField dest_user_name;
    private ALNumberField dest_post_id;
    private ALStringField client_name;
    private ALStringField company_name;
    private ALStringField telephone1;
    private ALStringField telephone2;
    private ALStringField telephone3;
    private ALStringField email_address;
    private ALStringField add_dest_type_pc;
    private ALStringField add_dest_type_cellphone;
    private ALStringField subject_type;
    private ALStringField custom_subject;
    private ALStringField note_stat;
    private ALStringField message;
    private ALDateTimeField accept_date;
    private ALDateTimeField confirm_date;
    private ALDateTimeField create_date;
    private ALDateTimeField update_date;
    private int currentYear;
    private ALStringField view_type = null;
    private List myGroupList = null;
    private String target_group_name;
    private int msg_type = 0;
    private List memberList;
    private ALEipUser loginUser;
    private DataContext dataContext;
    private String org_id;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        super.init(action, rundata, context);
        this.target_group_name = NoteUtils.getTargetGroupName(rundata, context);
        this.loginUser = ALEipUtils.getALEipUser((RunData)rundata);
        List myGroups = ALEipUtils.getMyGroups((RunData)rundata);
        this.myGroupList = new ArrayList();
        int length = myGroups.size();
        for (int i = 0; i < length; ++i) {
            this.myGroupList.add(myGroups.get(i));
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        this.org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        ParameterParser parser = rundata.getParameters();
        String dest_user_id_string = parser.getString("dest_user_id");
        if (dest_user_id_string != null) {
            this.dest_user_id.setValue(dest_user_id_string);
        } else {
            this.dest_user_id.setValue("");
        }
    }

    protected void setValidator() {
        this.dest_user_id.setNotNull(true);
        this.dest_user_id.limitMaxLength(50);
        this.dest_user_name.setNotNull(true);
        this.dest_user_name.limitMaxLength(50);
        this.client_name.setNotNull(true);
        this.client_name.limitMaxLength(50);
        this.company_name.setNotNull(false);
        this.company_name.limitMaxLength(50);
        this.telephone1.setCharacterType(2);
        this.telephone1.limitMaxLength(5);
        this.telephone2.setCharacterType(2);
        this.telephone2.limitMaxLength(4);
        this.telephone3.setCharacterType(2);
        this.telephone3.limitMaxLength(4);
        this.email_address.setNotNull(false);
        this.email_address.limitMaxLength(50);
        this.add_dest_type_pc.setNotNull(false);
        this.add_dest_type_pc.limitMaxLength(1);
        this.add_dest_type_cellphone.setNotNull(false);
        this.add_dest_type_cellphone.limitMaxLength(1);
        this.subject_type.setNotNull(true);
        this.subject_type.limitMaxLength(1);
        this.custom_subject.setNotNull(true);
        this.custom_subject.limitMaxLength(50);
        this.note_stat.setNotNull(true);
        this.note_stat.limitMaxLength(1);
        this.message.setNotNull(false);
        this.message.limitMaxLength(1000);
        this.accept_date.setNotNull(true);
        this.confirm_date.setNotNull(true);
        this.confirm_date.setValue(Calendar.getInstance().getTime());
    }

    protected boolean validate(ArrayList msgList) {
        ArrayList dummy = new ArrayList();
        this.dest_post_id.validate(msgList);
        this.dest_user_id.validate(msgList);
        if (this.dest_user_id.getValue() == null || this.dest_user_id.getValue().equals("") || this.dest_user_id.getValue().equals("all")) {
            if (this.memberList == null || this.memberList.size() <= 1) {
                msgList.add("\u30e6\u30fc\u30b6\u30fc\u304c\u767b\u9332\u3055\u308c\u3066\u3044\u308b\u300e <span class='em'> \u5b9b\u5148\u306e\u30b0\u30eb\u30fc\u30d7 </span> \u300f\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
        } else if (this.memberList == null || this.memberList.size() <= 1) {
            msgList.add("\u300e <span class='em'> \u5b9b\u5148\u306e\u30e6\u30fc\u30b6\u30fc </span> \u300f\u3092\u6b63\u3057\u304f\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.client_name.validate(msgList);
        this.company_name.validate(msgList);
        if (!(this.telephone1.getValue().equals("") && this.telephone2.getValue().equals("") && this.telephone3.getValue().equals("") || this.telephone1.validate(dummy) && this.telephone2.validate(dummy) && this.telephone3.validate(dummy))) {
            msgList.add("\u300e <span class='em'> \u4f9d\u983c\u8005\u96fb\u8a71\u756a\u53f7 </span> \u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.email_address.validate(msgList);
        if (this.email_address.getValue().trim().length() > 0 && !ALStringUtil.isCellPhoneMailAddress((String)this.email_address.getValue())) {
            msgList.add("\u300e <span class='em'> \u4f9d\u983c\u8005\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9 </span>\u300f\u3092\u6b63\u3057\u304f\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
        }
        this.add_dest_type_pc.validate(msgList);
        this.add_dest_type_cellphone.validate(msgList);
        if ("0".equals(this.subject_type.getValue())) {
            this.custom_subject.validate(msgList);
        } else {
            this.subject_type.validate(msgList);
        }
        this.message.validate(msgList);
        this.accept_date.validate(msgList);
        return msgList.size() == 0;
    }

    protected boolean loadFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean insertFormData(RunData rundata, Context context, ArrayList msgList) {
        int add_dest_type_int = 0;
        try {
            ALEipUser user;
            int i;
            int size;
            Date nowDate = Calendar.getInstance().getTime();
            EipTNote note = (EipTNote)this.dataContext.createAndRegisterNewObject(EipTNote.class);
            note.setOwnerId(Integer.toString(ALEipUtils.getUserId((RunData)rundata)));
            note.setClientName(this.client_name.getValue());
            note.setCompanyName(this.company_name.getValue());
            if (!(this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
                note.setTelephone(new StringBuffer().append(this.telephone1.getValue()).append("-").append(this.telephone2.getValue()).append("-").append(this.telephone3.getValue()).toString());
            } else {
                note.setTelephone("");
            }
            note.setEmailAddress(this.email_address.getValue());
            String add_dest_type_pc_str = this.add_dest_type_pc.getValue();
            String add_dest_type_cellphone_str = this.add_dest_type_cellphone.getValue();
            if (add_dest_type_pc_str != null && !add_dest_type_pc_str.equals("")) {
                ++add_dest_type_int;
            }
            if (add_dest_type_cellphone_str != null && !add_dest_type_cellphone_str.equals("")) {
                add_dest_type_int += 2;
            }
            note.setAddDestType(Integer.toString(add_dest_type_int));
            note.setSubjectType(this.subject_type.getValue());
            if ("0".equals(this.subject_type.getValue())) {
                note.setCustomSubject(this.custom_subject.getValue());
            }
            note.setMessage(this.message.getValue());
            note.setAcceptDate(this.accept_date.getValue());
            note.setCreateDate(nowDate);
            note.setUpdateDate(nowDate);
            if (this.memberList != null) {
                size = this.memberList.size();
                for (i = 0; i < size; ++i) {
                    user = (ALEipUser)this.memberList.get(i);
                    this.saveNoteMap(rundata, note, user.getUserId().toString(), "1");
                }
            }
            this.dataContext.commitChanges();
            ALEventlogFactoryService.getInstance().getEventlogHandler().log(note.getNoteId().intValue(), 140, NoteUtils.getNoteSubject(note));
            if (this.memberList != null) {
                size = this.memberList.size();
                for (i = 0; i < size; ++i) {
                    user = (ALEipUser)this.memberList.get(i);
                    if (user.getUserId().getValue() == this.loginUser.getUserId().getValue()) continue;
                    WhatsNewUtils.insertWhatsNew((DataContext)this.dataContext, (int)5, (int)note.getNoteId(), (int)((int)user.getUserId().getValue()));
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        if (add_dest_type_int > 0) {
            try {
                String subject = "[Aipo]\u4f1d\u8a00\u30e1\u30e2";
                List destMemberList = ALMailUtils.getALEipUserAddrs((List)this.memberList, (int)((int)this.loginUser.getUserId().getValue()), (boolean)false);
                ALMailUtils.sendMailDelegate((String)this.org_id, (int)ALEipUtils.getUserId((RunData)rundata), (List)destMemberList, (String)subject, (String)subject, (String)this.createMsgForPc(), (String)this.createMsgForCellPhone(), (int)add_dest_type_int, (ArrayList)msgList);
            }
            catch (Exception ex) {
                msgList.add("\u30e1\u30fc\u30eb\u3092\u9001\u4fe1\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
                logger.error((Object)"Exception", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    protected boolean updateFormData(RunData rundata, Context context, ArrayList msgList) {
        return false;
    }

    protected boolean deleteFormData(RunData rundata, Context context, ArrayList msgList) {
        try {
            EipTNoteMap map = NoteUtils.getEipTNoteMap(rundata, context, this.getSelectQueryForDelete(rundata, context));
            if (map == null) {
                return false;
            }
            ArrayList<String> delNoteIdList = new ArrayList<String>();
            delNoteIdList.add(map.getEipTNote().getNoteId().toString());
            return NoteUtils.deleteNotes(rundata, context, delNoteIdList, msgList);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
    }

    private SelectQuery getSelectQueryForDelete(RunData rundata, Context context) {
        String userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
        SelectQuery query = new SelectQuery(EipTNoteMap.class);
        if ("received_notes".equals(NoteUtils.getCurrentTab(rundata, context))) {
            Expression exp1 = ExpressionFactory.matchExp((String)"userId", (Object)userId);
            query.setQualifier(exp1);
            Expression exp2 = ExpressionFactory.noMatchExp((String)"eipTNote.ownerId", (Object)userId);
            query.setQualifier(exp2);
        } else {
            Expression exp = ExpressionFactory.matchExp((String)"eipTNote.ownerId", (Object)userId);
            query.setQualifier(exp);
        }
        return query;
    }

    public void initField() {
        this.note_id = new ALNumberField();
        this.note_id.setFieldName("\u4f1d\u8a00\u30e1\u30e2ID");
        this.src_user_id = new ALStringField();
        this.src_user_id.setFieldName("\u9001\u4fe1\u8005");
        this.src_user_id.setTrim(true);
        this.dest_user_id = new ALStringField();
        this.dest_user_id.setFieldName("\u5b9b\u5148");
        this.dest_user_id.setTrim(true);
        this.dest_user_name = new ALStringField();
        this.dest_user_name.setFieldName("\u5b9b\u5148\u30e6\u30fc\u30b6\u540d");
        this.dest_user_name.setTrim(true);
        this.dest_post_id = new ALNumberField();
        this.dest_post_id.setFieldName("\u5b9b\u5148\u90e8\u7f72 ID");
        this.client_name = new ALStringField();
        this.client_name.setFieldName("\u4f9d\u983c\u8005\u540d");
        this.client_name.setTrim(true);
        this.company_name = new ALStringField();
        this.company_name.setFieldName("\u4f9d\u983c\u8005\u6240\u5c5e");
        this.company_name.setTrim(true);
        this.telephone1 = new ALStringField();
        this.telephone1.setFieldName("\u4f9d\u983c\u8005\u96fb\u8a71\u756a\u53f7");
        this.telephone1.setTrim(true);
        this.telephone2 = new ALStringField();
        this.telephone2.setFieldName("\u4f9d\u983c\u8005\u96fb\u8a71\u756a\u53f7");
        this.telephone2.setTrim(true);
        this.telephone3 = new ALStringField();
        this.telephone3.setFieldName("\u4f9d\u983c\u8005\u96fb\u8a71\u756a\u53f7");
        this.telephone3.setTrim(true);
        this.email_address = new ALStringField();
        this.email_address.setFieldName("\u4f9d\u983c\u8005\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9");
        this.email_address.setTrim(true);
        this.add_dest_type_pc = new ALStringField();
        this.add_dest_type_pc.setFieldName("\u8ffd\u52a0\u9001\u4fe1\u5148");
        this.add_dest_type_pc.setTrim(true);
        this.add_dest_type_cellphone = new ALStringField();
        this.add_dest_type_cellphone.setFieldName("\u8ffd\u52a0\u9001\u4fe1\u5148");
        this.add_dest_type_cellphone.setTrim(true);
        this.subject_type = new ALStringField();
        this.subject_type.setFieldName("\u7528\u4ef6");
        this.subject_type.setTrim(true);
        this.custom_subject = new ALStringField();
        this.custom_subject.setFieldName("\u7528\u4ef6");
        this.custom_subject.setTrim(true);
        this.note_stat = new ALStringField();
        this.note_stat.setFieldName("\u72b6\u614b");
        this.note_stat.setTrim(true);
        this.message = new ALStringField();
        this.message.setFieldName("\u672c\u6587");
        this.message.setTrim(false);
        this.accept_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.accept_date.setFieldName("\u53d7\u4ed8\u65e5\u6642");
        this.confirm_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.confirm_date.setFieldName("\u78ba\u8a8d\u65e5\u6642");
        this.create_date = new ALDateTimeField("yyyy/MM/dd");
        this.create_date.setFieldName("\u4f5c\u6210\u65e5\u6642");
        this.update_date = new ALDateTimeField("yyyy/MM/dd HH:mm");
        this.update_date.setFieldName("\u66f4\u65b0\u65e5\u6642");
        this.currentYear = Calendar.getInstance().get(1);
        this.view_type = new ALStringField();
        this.view_type.setFieldName("\u8868\u793a\u30bf\u30a4\u30d7");
        this.view_type.setTrim(true);
    }

    protected boolean setFormData(RunData rundata, Context context, ArrayList msgList) throws ALPageNotFoundException, ALDBErrorException {
        boolean success = super.setFormData(rundata, context, msgList);
        this.src_user_id.setValue(Integer.toString(ALEipUtils.getUserId((RunData)rundata)));
        if (this.accept_date.toString().equals("")) {
            this.accept_date.setValue(Calendar.getInstance().getTime());
        }
        if (this.subject_type.getValue() == null) {
            this.subject_type.setValue("3");
        }
        if (this.dest_user_id.getValue() == null || this.dest_user_id.getValue().equals("") || this.dest_user_id.getValue().equals("all")) {
            if (this.target_group_name == null || this.target_group_name.equals("") || this.target_group_name.equals("all")) {
                this.memberList = this.getUsers("LoginUser");
            } else {
                this.memberList = this.getUsers(this.target_group_name);
                if (!this.containtsUser(this.memberList, this.loginUser)) {
                    this.memberList.add(this.loginUser);
                }
            }
        } else {
            Integer destid = Integer.valueOf(this.dest_user_id.getValue());
            this.memberList = new ArrayList();
            this.memberList.add(ALEipUtils.getALEipUser((int)destid));
            if (!this.containtsUser(this.memberList, this.loginUser)) {
                this.memberList.add(this.loginUser);
            }
        }
        return success;
    }

    private String createMsgForPc() {
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer();
        if (this.company_name.getValue() != null && !this.company_name.getValue().equals("")) {
            body.append(this.company_name);
        }
        body.append(this.client_name).append("\u69d8\u304b\u3089\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059\u3002").append(CR).append(CR);
        body.append("[\u53d7\u4ed8\u6642\u9593]").append(CR);
        body.append(this.accept_date.getMonth()).append("\u6708").append(this.accept_date.getDay()).append("\u65e5").append(this.accept_date.getHour()).append("\u6642").append(this.accept_date.getMinute()).append("\u5206").append(CR);
        body.append("[\u7528\u4ef6]").append(CR);
        if ("0".equals(this.subject_type.getValue())) {
            body.append(this.custom_subject.getValue()).append(CR);
        } else if ("1".equals(this.subject_type.getValue())) {
            body.append("\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059").append(CR);
        } else if ("2".equals(this.subject_type.getValue())) {
            body.append("\u96fb\u8a71\u3092\u3057\u3066\u304f\u3060\u3055\u3044").append(CR);
        } else if ("3".equals(this.subject_type.getValue())) {
            body.append("\u96fb\u8a71\u304c\u3042\u308a\u307e\u3057\u305f").append(CR);
        } else if ("4".equals(this.subject_type.getValue())) {
            body.append("\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059").append(CR);
        }
        body.append("[\u4f9d\u983c\u8005\u60c5\u5831]").append(CR).append("\u540d\u524d\uff1a").append(this.client_name);
        if (this.company_name.getValue() != null && !this.company_name.getValue().equals("")) {
            body.append(CR).append("\u6240\u5c5e\uff1a").append(this.company_name);
        }
        if (!(this.telephone1 == null || this.telephone2 == null || this.telephone3 == null || this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
            body.append(CR).append("[\u96fb\u8a71\u756a\u53f7]").append(CR).append(this.telephone1).append("-").append(this.telephone2).append("-").append(this.telephone3);
        }
        if (this.email_address.getValue() != null && !this.email_address.getValue().equals("")) {
            body.append(CR).append("[\u30e1\u30fc\u30eb]").append(CR).append(this.email_address);
        }
        if (this.message.getValue() != null && !this.message.getValue().equals("")) {
            body.append(CR).append("[\u672c\u6587]").append(CR).append(this.message.getValue());
        }
        ALBaseUser user = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(this.src_user_id.getValue()));
        }
        catch (Exception e) {
            return "";
        }
        String username = new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString();
        body.append(CR).append("[\u9001\u4fe1\u8005]").append(CR).append(username);
        String e_mail_addr = user.getEmail();
        if (!e_mail_addr.equals("")) {
            body.append("(").append(e_mail_addr).append(")");
        }
        body.append(CR);
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        body.append("\u30fb\u793e\u5916").append(CR);
        body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        body.append("\u30fb\u793e\u5185").append(CR);
        body.append("\u3000").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    private String createMsgForCellPhone() {
        String CR = System.getProperty("line.separator");
        StringBuffer body = new StringBuffer();
        if (this.company_name.getValue() != null && !this.company_name.getValue().equals("")) {
            body.append(this.company_name);
        }
        body.append(this.client_name).append("\u69d8\u304b\u3089\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059\u3002").append(CR).append(CR);
        body.append("[\u53d7\u4ed8\u6642\u9593]").append(CR);
        body.append(this.accept_date.getMonth()).append("\u6708").append(this.accept_date.getDay()).append("\u65e5").append(this.accept_date.getHour()).append("\u6642").append(this.accept_date.getMinute()).append("\u5206").append(CR);
        body.append("[\u7528\u4ef6]").append(CR);
        if ("0".equals(this.subject_type.getValue())) {
            body.append(this.custom_subject.getValue()).append(CR);
        } else if ("1".equals(this.subject_type.getValue())) {
            body.append("\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059").append(CR);
        } else if ("2".equals(this.subject_type.getValue())) {
            body.append("\u96fb\u8a71\u3092\u3057\u3066\u304f\u3060\u3055\u3044").append(CR);
        } else if ("3".equals(this.subject_type.getValue())) {
            body.append("\u96fb\u8a71\u304c\u3042\u308a\u307e\u3057\u305f").append(CR);
        } else if ("4".equals(this.subject_type.getValue())) {
            body.append("\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059").append(CR);
        }
        body.append("[\u4f9d\u983c\u8005\u60c5\u5831]").append(CR).append("\u540d\u524d\uff1a").append(this.client_name);
        if (this.company_name.getValue() != null && !this.company_name.getValue().equals("")) {
            body.append(CR).append("\u6240\u5c5e\uff1a").append(this.company_name);
        }
        if (!(this.telephone1 == null || this.telephone2 == null || this.telephone3 == null || this.telephone1.getValue().equals("") || this.telephone2.getValue().equals("") || this.telephone3.getValue().equals(""))) {
            body.append(CR).append("[\u96fb\u8a71\u756a\u53f7]").append(CR).append(this.telephone1).append("-").append(this.telephone2).append("-").append(this.telephone3);
        }
        if (this.email_address.getValue() != null && !this.email_address.getValue().equals("")) {
            body.append(CR).append("[\u30e1\u30fc\u30eb]").append(CR).append(this.email_address);
        }
        if (this.message.getValue() != null && !this.message.getValue().equals("")) {
            body.append(CR).append("[\u672c\u6587]").append(CR).append(this.message.getValue());
        }
        ALBaseUser user = null;
        try {
            user = (ALBaseUser)JetspeedSecurity.getUser((Principal)new UserIdPrincipal(this.src_user_id.getValue()));
        }
        catch (Exception e) {
            return "";
        }
        String username = new StringBuffer().append(user.getLastName()).append(" ").append(user.getFirstName()).toString();
        body.append(CR).append("[\u9001\u4fe1\u8005]").append(CR).append(username);
        String e_mail_addr = user.getEmail();
        if (e_mail_addr != null && !e_mail_addr.equals("")) {
            body.append("(").append(e_mail_addr).append(")");
        }
        body.append(CR);
        body.append(CR);
        body.append("[Aipo\u3078\u306e\u30a2\u30af\u30bb\u30b9]").append(CR);
        body.append("\u3000").append(ALMailUtils.getGlobalurl()).append(CR);
        body.append("---------------------").append(CR);
        body.append("Aipo").append(CR);
        return body.toString();
    }

    private void saveNoteMap(RunData rundata, EipTNote note, String userId, String stat) throws ALDBErrorException {
        EipTNoteMap map = (EipTNoteMap)this.dataContext.createAndRegisterNewObject(EipTNoteMap.class);
        map.setEipTNote(note);
        map.setUserId(userId);
        map.setDelFlg("F");
        map.setNoteStat(stat);
    }

    private boolean containtsUser(List list, ALEipUser user) {
        if (user == null || list == null || list.size() <= 0) {
            return false;
        }
        long userid = user.getUserId().getValue();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            user = (ALEipUser)list.get(i);
            if (user.getUserId().getValue() != userid) continue;
            return true;
        }
        return false;
    }

    public void enableAddDestTypes() {
        this.add_dest_type_pc.setValue("1");
        this.add_dest_type_cellphone.setValue("1");
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public ALDateTimeField getAcceptDate() {
        return this.accept_date;
    }

    public ALStringField getAddDestTypePc() {
        return this.add_dest_type_pc;
    }

    public ALStringField getAddDestTypeCellphone() {
        return this.add_dest_type_cellphone;
    }

    public ALStringField getClientName() {
        return this.client_name;
    }

    public ALStringField getCompanyName() {
        return this.company_name;
    }

    public ALDateTimeField getConfirmDate() {
        return this.confirm_date;
    }

    public ALDateTimeField getCreateDate() {
        return this.create_date;
    }

    public ALStringField getDestUserId() {
        return this.dest_user_id;
    }

    public ALStringField getEmailAddress() {
        return this.email_address;
    }

    public ALStringField getMessage() {
        return this.message;
    }

    public ALNumberField getNoteId() {
        return this.note_id;
    }

    public ALStringField getSrcUserId() {
        return this.src_user_id;
    }

    public ALStringField getSubjectType() {
        return this.subject_type;
    }

    public ALStringField getCustomSubject() {
        return this.custom_subject;
    }

    public ALStringField getTelephone1() {
        return this.telephone1;
    }

    public ALStringField getTelephone2() {
        return this.telephone2;
    }

    public ALStringField getTelephone3() {
        return this.telephone3;
    }

    public ALDateTimeField getUpdateDate() {
        return this.update_date;
    }

    public void setNoteStat(String value) {
        this.note_stat.setValue(value);
    }

    public ALStringField getNoteStat() {
        return this.note_stat;
    }

    public List getUsers(String groupname) {
        return ALEipUtils.getUsers((String)groupname);
    }

    public Map getPostMap() {
        return ALEipManager.getInstance().getPostMap();
    }

    public ALStringField getViewType() {
        return this.view_type;
    }

    public void setViewType(String string) {
        this.view_type.setValue(string);
    }

    public ALStringField getDestUserName() {
        return this.dest_user_name;
    }

    public ALNumberField getDestPostId() {
        return this.dest_post_id;
    }

    public String getUserId(String userName) {
        return NoteUtils.getUserId(userName);
    }

    public String getTargetGroupName() {
        return this.target_group_name;
    }

    public List getMyGroupList() {
        return this.myGroupList;
    }

    public int getMsgType() {
        return this.msg_type;
    }
}

