/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.note;

import com.aimluck.eip.cayenne.om.portlet.EipTNote;
import com.aimluck.eip.cayenne.om.portlet.EipTNoteMap;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.note.NoteClientResultData;
import com.aimluck.eip.note.util.NoteUtils;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import java.util.List;
import java.util.jar.Attributes;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteClientSelectData
extends ALAbstractSelectData
implements ALData {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteClientSelectData.class.getName());
    private String userId;
    private int newNoteAllSum = 0;
    private int unreadReceivedNotesAllSum = 0;
    private DataContext dataContext;

    public void init(ALAction action, RunData rundata, Context context) throws ALPageNotFoundException, ALDBErrorException {
        String sort = ALEipUtils.getTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR);
        if (sort == null || sort.equals("")) {
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)this.LIST_SORT_STR, (String)ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort"));
            logger.debug((Object)("Init Parameter (Note) : " + ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p2a-sort")));
        }
        this.dataContext = DatabaseOrmService.getInstance().getDataContext();
        super.init(action, rundata, context);
    }

    protected List selectList(RunData rundata, Context context) {
        try {
            this.userId = Integer.toString(ALEipUtils.getUserId((RunData)rundata));
            this.newNoteAllSum = NoteUtils.getNewReceivedNoteAllSum(rundata, this.userId);
            this.unreadReceivedNotesAllSum = NoteUtils.getUnreadReceivedNotesAllSum(rundata, this.userId);
            SelectQuery query = this.getSelectQuery(rundata, context);
            this.buildSelectQueryForListView(query);
            this.buildSelectQueryForListViewSort(query, rundata, context);
            List list = this.dataContext.performQuery((Query)query);
            return this.buildPaginatedList(list);
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object selectDetail(RunData rundata, Context context) {
        return null;
    }

    protected Object getResultData(Object obj) {
        try {
            EipTNoteMap map = (EipTNoteMap)obj;
            EipTNote record = map.getEipTNote();
            NoteClientResultData rd = new NoteClientResultData();
            rd.initField();
            rd.setNoteId(record.getNoteId().intValue());
            rd.setClientName(ALCommonUtils.compressString((String)record.getClientName(), (int)this.getStrLength()));
            rd.setNoteStat(map.getNoteStat());
            rd.setAcceptDate(record.getAcceptDate());
            String subject = "";
            if (record.getSubjectType().equals("0")) {
                subject = ALCommonUtils.compressString((String)record.getCustomSubject(), (int)this.getStrLength());
            } else if (record.getSubjectType().equals("1")) {
                subject = "\u518d\u5ea6\u96fb\u8a71\u3057\u307e\u3059";
            } else if (record.getSubjectType().equals("2")) {
                subject = "\u96fb\u8a71\u3092\u3057\u3066\u304f\u3060\u3055\u3044";
            } else if (record.getSubjectType().equals("3")) {
                subject = "\u96fb\u8a71\u304c\u3042\u308a\u307e\u3057\u305f";
            } else if (record.getSubjectType().equals("4")) {
                subject = "\u4f1d\u8a00\u304c\u3042\u308a\u307e\u3059";
            }
            rd.setSubject(subject);
            if ("1".equals(map.getNoteStat())) {
                rd.setNoteStat("1");
                rd.setNoteStatImage("images/note/note_new_message.gif");
                rd.setNoteStatImageDescription("\u65b0\u7740");
            } else if ("2".equals(map.getNoteStat())) {
                rd.setNoteStat("2");
                rd.setNoteStatImage("images/note/note_unread_message.gif");
                rd.setNoteStatImageDescription("\u672a\u8aad");
            } else {
                rd.setNoteStat("3");
                rd.setNoteStatImage("images/note/note_read_message.gif");
                rd.setNoteStatImageDescription("\u65e2\u8aad");
            }
            return rd;
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return null;
        }
    }

    protected Object getResultDataDetail(Object obj) {
        return null;
    }

    protected Attributes getColumnMap() {
        Attributes map = new Attributes();
        map.putValue("client_name", "eipTNote.clientName");
        map.putValue("subject_type", "eipTNote.subjectType");
        map.putValue("accept_date", "eipTNote.acceptDate");
        map.putValue("note_stat", "noteStat");
        return map;
    }

    private SelectQuery getSelectQuery(RunData rundata, Context context) {
        return NoteUtils.getSelectQueryNoteList(rundata, context);
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName(String userId) {
        return NoteUtils.getUserName(userId);
    }

    public String getUserFullName(String userId) {
        try {
            ALEipUser user = ALEipUtils.getALEipUser((int)Integer.valueOf(userId));
            return user.getAliasName().getValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getUserId(String userName) {
        return NoteUtils.getUserId(userName);
    }

    public int getNewNoteAllSum() {
        return this.newNoteAllSum;
    }

    public int getUnreadReceivedNotesAllSum() {
        return this.unreadReceivedNotesAllSum;
    }
}

