/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.modules.actions.note;

import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.note.NoteClientSelectData;
import com.aimluck.eip.note.NoteFormData;
import com.aimluck.eip.note.NoteMultiDelete;
import com.aimluck.eip.note.NoteMultiStateUpdate;
import com.aimluck.eip.note.NoteSelectData;
import com.aimluck.eip.util.ALEipUtils;
import java.util.ArrayList;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

public class NoteAction
extends ALBaseAction {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)NoteAction.class.getName());

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata) throws Exception {
        this.clearNoteSession(rundata, context);
        ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"received_notes");
        this.doNote_normal(rundata, context);
    }

    protected void buildMaximizedContext(VelocityPortlet portlet, Context context, RunData rundata) {
        String mode = rundata.getParameters().getString("mode");
        try {
            if ("form".equals(mode)) {
                this.doNote_create_note(rundata, context);
            } else if ("detail".equals(mode)) {
                this.doNote_show_note(rundata, context);
            } else if ("list".equals(mode)) {
                this.doNote_list(rundata, context);
            }
            if (this.getMode() == null) {
                this.doNote_list(rundata, context);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void doNote_normal(RunData rundata, Context context) throws Exception {
        VelocityPortlet portlet = ALEipUtils.getPortlet((RunData)rundata, (Context)context);
        NoteClientSelectData listData = new NoteClientSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(portlet.getPortletConfig().getInitParameter("p1a-rows")));
        listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-strlen")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "note");
    }

    public void doNote_create_note(RunData rundata, Context context) throws Exception {
        context.put("note_view_type", (Object)"note_view_list");
        NoteFormData formData = new NoteFormData();
        formData.initField();
        formData.enableAddDestTypes();
        formData.doViewForm((ALAction)this, rundata, context);
        this.setTemplate(rundata, "note-form");
    }

    public void doNote_insert(RunData rundata, Context context) throws Exception {
        NoteFormData formData = new NoteFormData();
        formData.initField();
        if (formData.doInsert((ALAction)this, rundata, context)) {
            int msgType = formData.getMsgType();
            context.put("msg_type", (Object)("" + msgType));
            ALEipUtils.setTemp((RunData)rundata, (Context)context, (String)"tab", (String)"sent_notes");
            this.doNote_list(rundata, context);
        } else {
            this.setTemplate(rundata, "note-form");
        }
    }

    public void doNote_list(RunData rundata, Context context) throws Exception {
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, (String)"target_user_id");
        NoteSelectData listData = new NoteSelectData();
        listData.initField();
        listData.setRowsNum(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p1b-rows")));
        listData.setStrLength(Integer.parseInt(ALEipUtils.getPortlet((RunData)rundata, (Context)context).getPortletConfig().getInitParameter("p3a-strlen")));
        listData.doViewList((ALAction)this, rundata, context);
        this.setTemplate(rundata, "note-list");
    }

    public void doNote_list2(RunData rundata, Context context) throws Exception {
        String msgType = rundata.getParameters().getString("msg_type");
        context.put("msg_type", (Object)msgType);
        this.doNote_list(rundata, context);
    }

    public void doNote_show_note(RunData rundata, Context context) throws Exception {
        NoteSelectData listData = new NoteSelectData();
        listData.initField();
        listData.doViewDetail((ALAction)this, rundata, context);
        this.setTemplate(rundata, "note-detail");
    }

    public void doNote_delete(RunData rundata, Context context) throws Exception {
        NoteFormData formData = new NoteFormData();
        formData.initField();
        if (formData.doDelete((ALAction)this, rundata, context)) {
            this.doNote_list(rundata, context);
        } else {
            this.setTemplate(rundata, "note-detail");
        }
    }

    public void doNote_multi_delete(RunData rundata, Context context) throws Exception {
        NoteMultiDelete delete = new NoteMultiDelete();
        if (delete.doMultiAction((ALAction)this, rundata, context)) {
            this.doNote_list(rundata, context);
        } else {
            this.setTemplate(rundata, "note-list");
        }
    }

    public void doNote_multi_read(RunData rundata, Context context) throws Exception {
        NoteMultiStateUpdate data = new NoteMultiStateUpdate();
        data.doMultiAction((ALAction)this, rundata, context);
        this.doNote_normal(rundata, context);
    }

    public void doNote_multi_read_max(RunData rundata, Context context) throws Exception {
        NoteMultiStateUpdate data = new NoteMultiStateUpdate();
        data.doMultiAction((ALAction)this, rundata, context);
        this.doNote_list(rundata, context);
    }

    private void clearNoteSession(RunData rundata, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("target_user_id");
        list.add("target_group_name");
        list.add("com.aimluck.eip.note.NoteSelectDatasort");
        list.add("com.aimluck.eip.note.NoteSelectDatasorttype");
        list.add("com.aimluck.eip.note.NoteClientSelectDatasort");
        ALEipUtils.removeTemp((RunData)rundata, (Context)context, list);
    }
}

