/*
 * Decompiled with CFR 0.152.
 */
package com.aimluck.eip.fileupload.util;

import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.orm.DatabaseOrmService;
import com.aimluck.eip.util.ALEipUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.util.RunData;

public class FileuploadUtils {
    private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger((String)FileuploadUtils.class.getName());
    public static final String KEY_FILEUPLOAD_ID_LIST = "attachments";
    public static final String KEY_FILEUPLOAD_FODLER_NAME = "folderName";
    public static final String EXT_FILENAME = ".txt";
    public static final String ATTACHMENT_TEMP_FILENAME = "file";
    public static final String ATTACHMENT_TEMP_FILENAME_REMAIND = "file.txt";
    public static final String DEFAULT_FILENAME_DATE_FORMAT = "yyyyMMddHHmmssSSS";
    public static final int DEF_THUMBNAIL_WIDTH = 86;
    public static final int DEF_THUMBNAIL_HEIGTH = 86;
    public static final String KEY_NOW_SIZE = "nsize";
    public static final String KEY_MAX_SIZE = "msize";
    public static final String FILE_ENCODING = JetspeedResources.getString((String)"content.defaultencoding", (String)"UTF-8");
    public static final String FOLDER_TMP_FOR_ATTACHMENT_FILES = JetspeedResources.getString((String)"aipo.tmp.fileupload.attachment.directory", (String)"");
    private static int MAP_MAX = 0x100000;

    public static File getRootFolder(String org_id, int userId) {
        String rootPath = FOLDER_TMP_FOR_ATTACHMENT_FILES + File.separator + org_id + File.separator + userId + File.separator;
        File folder = new File(rootPath);
        if (!folder.exists() && !folder.mkdirs()) {
            return null;
        }
        return folder;
    }

    public static File getFolder(String org_id, int userId, String folderName) {
        String path = FOLDER_TMP_FOR_ATTACHMENT_FILES + File.separator + org_id + File.separator + userId + File.separator + folderName;
        File folder = new File(path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public static File getAbsolutePath(String org_id, int userId, String folderName, int fileid) {
        File folder = FileuploadUtils.getFolder(org_id, userId, folderName);
        return new File(folder.getAbsolutePath() + File.separator + fileid);
    }

    public static String getNewFileName(String folderPath) {
        int count = 0;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_FILENAME_DATE_FORMAT);
        Date date = new Date();
        String tmpname = simpleDateFormat.format(date);
        String path = folderPath + File.separator;
        File folderpath = new File(path);
        if (!folderpath.exists()) {
            folderpath.mkdirs();
        }
        File file = null;
        String newFileName = null;
        String newFilePath = null;
        while (true) {
            newFileName = tmpname + count;
            newFilePath = path + newFileName;
            file = new File(newFilePath);
            if (!file.exists()) break;
            ++count;
        }
        return newFileName;
    }

    public static String getNewAttachmentFolderName(File folder) {
        int maxNum = 1;
        String[] filenames = folder.list();
        File file = null;
        int tmpInt = 1;
        int length = filenames.length;
        for (int i = 0; i < length; ++i) {
            file = new File(folder.getAbsolutePath() + File.separator + filenames[i]);
            if (!file.isDirectory()) continue;
            try {
                tmpInt = Integer.parseInt(file.getName());
                if (maxNum > tmpInt) continue;
                maxNum = tmpInt + 1;
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return Integer.toString(maxNum);
    }

    public static String getRealFileName(String name) {
        String filename = null;
        int index = name.lastIndexOf("/");
        if (index < 0) {
            index = name.lastIndexOf("\\");
        }
        filename = index > 0 ? name.substring(index + 1, name.length()) : name;
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getFileuploadList(RunData rundata) {
        String folderName;
        String[] fileids = rundata.getParameters().getStrings(KEY_FILEUPLOAD_ID_LIST);
        if (fileids == null) {
            return null;
        }
        ArrayList<FileuploadLiteBean> fileNameList = new ArrayList<FileuploadLiteBean>();
        FileuploadLiteBean filebean = null;
        int fileid = 0;
        int length = fileids.length;
        if (length == 1 && fileids[0] != null && !"".equals(fileids[0])) {
            try {
                fileid = Integer.parseInt(fileids[0]);
            }
            catch (Exception e) {
                return null;
            }
            if (fileid == 0) {
                filebean = new FileuploadLiteBean();
                filebean.initField();
                filebean.setFolderName("photo");
                filebean.setFileName("\u4ee5\u524d\u306e\u5199\u771f\u30d5\u30a1\u30a4\u30eb");
                fileNameList.add(filebean);
                return fileNameList;
            }
        }
        if ((folderName = rundata.getParameters().getString(KEY_FILEUPLOAD_FODLER_NAME)) == null || folderName.equals("")) {
            return null;
        }
        String org_id = DatabaseOrmService.getInstance().getOrgId(rundata);
        File folder = FileuploadUtils.getFolder(org_id, ALEipUtils.getUserId((RunData)rundata), folderName);
        String folderpath = folder.getAbsolutePath();
        for (int i = 0; i < length; ++i) {
            if (fileids[i] == null || fileids[i].equals("")) continue;
            try {
                fileid = Integer.parseInt(fileids[i]);
            }
            catch (Exception e) {
                continue;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(folderpath + File.separator + fileids[i] + EXT_FILENAME), FILE_ENCODING));
                String line = reader.readLine();
                if (line == null || line.length() <= 0) continue;
                filebean = new FileuploadLiteBean();
                filebean.initField();
                filebean.setFolderName(fileids[i]);
                filebean.setFileId(fileid);
                filebean.setFileName(line);
                fileNameList.add(filebean);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
                continue;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Exception", (Throwable)e);
                }
            }
        }
        return fileNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to) {
        boolean res = true;
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            srcChannel = new FileInputStream(from).getChannel();
            destChannel = new FileOutputStream(to).getChannel();
            ((FileChannel)destChannel).transferFrom(srcChannel, 0L, srcChannel.size());
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            res = false;
        }
        finally {
            if (destChannel != null) {
                try {
                    destChannel.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                    res = false;
                }
            }
            if (srcChannel != null) {
                try {
                    srcChannel.close();
                }
                catch (IOException ex) {
                    logger.error((Object)"Exception", (Throwable)ex);
                    res = false;
                }
            }
        }
        return res;
    }

    public static long getFolderSize(String folderPath) {
        if (folderPath == null || folderPath.equals("")) {
            return 0L;
        }
        File folder = new File(folderPath);
        if (!folder.exists()) {
            return 0L;
        }
        if (folder.isFile()) {
            return FileuploadUtils.getFileSize(folder);
        }
        int fileSizeSum = 0;
        File file = null;
        String[] files = folder.list();
        int length = files.length;
        for (int i = 0; i < length; ++i) {
            file = new File(folderPath + File.separator + files[i]);
            if (file.isFile()) {
                fileSizeSum += FileuploadUtils.getFileSize(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileSizeSum = (int)((long)fileSizeSum + FileuploadUtils.getFolderSize(file.getAbsolutePath()));
        }
        return fileSizeSum;
    }

    public static int getFileSize(File file) {
        if (file == null) {
            return -1;
        }
        FileInputStream fileInputStream = null;
        int size = -1;
        try {
            fileInputStream = new FileInputStream(file);
            BufferedInputStream input = new BufferedInputStream(fileInputStream);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] b = new byte[512];
            int len = -1;
            while ((len = input.read(b)) != -1) {
                output.write(b, 0, len);
                output.flush();
            }
            input.close();
            fileInputStream.close();
            byte[] fileArray = output.toByteArray();
            size = fileArray != null ? fileArray.length : -1;
            output.close();
        }
        catch (FileNotFoundException e) {
            return -1;
        }
        catch (IOException ioe) {
            return -1;
        }
        return size;
    }

    public static boolean deleteFolder(File folder) {
        if (folder == null) {
            return true;
        }
        String[] files = folder.list();
        if (files == null) {
            folder.delete();
            return true;
        }
        int length = files.length;
        if (length <= 0) {
            folder.delete();
            return true;
        }
        String folderPath = folder.getAbsolutePath() + File.separator;
        File tmpfile = null;
        for (int i = 0; i < length; ++i) {
            tmpfile = new File(folderPath + files[i]);
            if (!tmpfile.exists()) continue;
            if (tmpfile.isFile()) {
                tmpfile.delete();
                continue;
            }
            if (!tmpfile.isDirectory()) continue;
            FileuploadUtils.deleteFolder(tmpfile);
        }
        folder.delete();
        return true;
    }

    public static boolean deleteAttachments(String org_id, int userId, String folderName, List attachmentFileNameList) {
        File folder = null;
        try {
            String folderpath = FOLDER_TMP_FOR_ATTACHMENT_FILES + File.separator + org_id + File.separator + userId + File.separator + folderName;
            folder = new File(folderpath);
            if (!folder.exists()) {
                return true;
            }
            String[] uploadedFolders = folder.list();
            int uploadedfolders_length = uploadedFolders.length;
            int length = attachmentFileNameList.size();
            FileuploadBean attachmentFile = null;
            String uploadedFolderName = null;
            File uploadedFolder = null;
            boolean isDelete = true;
            for (int i = 0; i < uploadedfolders_length; ++i) {
                isDelete = true;
                uploadedFolder = new File(folderpath + File.separator + uploadedFolders[i]);
                if (!uploadedFolder.isDirectory()) continue;
                uploadedFolderName = uploadedFolder.getName();
                for (int j = 0; j < length; ++j) {
                    attachmentFile = (FileuploadBean)attachmentFileNameList.get(j);
                    if (!uploadedFolderName.equals(attachmentFile.getFolderName())) continue;
                    isDelete = false;
                    break;
                }
                if (!isDelete) continue;
                FileuploadUtils.deleteFolder(uploadedFolder);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Exception", (Throwable)ex);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFilebean(String org_id, String folderName, int uid, FileuploadLiteBean fileBean, String[] acceptExts, ArrayList msgList) {
        byte[] result = null;
        try {
            File folder = FileuploadUtils.getFolder(org_id, uid, folderName);
            String file_name = fileBean.getFileName();
            if (acceptExts != null && acceptExts.length > 0) {
                boolean isAccept = false;
                String tmpExt = null;
                int len = acceptExts.length;
                for (int i = 0; i < len; ++i) {
                    if (!acceptExts[i].startsWith(".")) {
                        tmpExt = "." + acceptExts[i];
                    }
                    if (!file_name.toLowerCase().endsWith(tmpExt)) continue;
                    isAccept = true;
                }
                if (!isAccept) {
                    return null;
                }
            }
            StringBuffer srcfilepath = new StringBuffer(folder.getAbsolutePath());
            srcfilepath.append(File.separator).append(fileBean.getFileId());
            FileInputStream fileinput = null;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                fileinput = new FileInputStream(srcfilepath.toString());
                byte[] b = new byte[512];
                int len = -1;
                while ((len = fileinput.read(b, 0, b.length)) != -1) {
                    output.write(b, 0, len);
                }
                output.flush();
            }
            finally {
                if (fileinput != null) {
                    fileinput.close();
                }
            }
            result = output.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesShrinkFilebean(String org_id, String folderName, int uid, FileuploadLiteBean fileBean, String[] acceptExts, int width, int height, ArrayList msgList) {
        byte[] result = null;
        FileInputStream fileinput = null;
        try {
            File folder = FileuploadUtils.getFolder(org_id, uid, folderName);
            String file_name = fileBean.getFileName();
            if (acceptExts != null && acceptExts.length > 0) {
                boolean isAccept = false;
                String tmpExt = null;
                int len = acceptExts.length;
                for (int i = 0; i < len; ++i) {
                    if (!acceptExts[i].startsWith(".")) {
                        tmpExt = "." + acceptExts[i];
                    }
                    if (!file_name.toLowerCase().endsWith(tmpExt)) continue;
                    isAccept = true;
                    break;
                }
                if (!isAccept) {
                    byte[] i = null;
                    return i;
                }
            }
            StringBuffer srcfilepath = new StringBuffer(folder.getAbsolutePath());
            srcfilepath.append(File.separator).append(fileBean.getFileId());
            fileinput = new FileInputStream(srcfilepath.toString());
            BufferedImage orgImage = ImageIO.read(fileinput);
            BufferedImage shrinkImage = FileuploadUtils.shrinkImage(orgImage, width, height);
            Iterator<ImageWriter> writers = ImageIO.getImageWritersBySuffix("jpg");
            ImageWriter writer = writers.next();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageOutputStream ios = ImageIO.createImageOutputStream(out);
            writer.setOutput(ios);
            writer.write(shrinkImage);
            result = out.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
            result = null;
        }
        finally {
            try {
                if (fileinput != null) {
                    fileinput.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Exception", (Throwable)e);
                result = null;
            }
        }
        return result;
    }

    public static boolean isImage(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return false;
        }
        int index = fileName.lastIndexOf(".");
        if (index < 1) {
            return false;
        }
        String fileType = FileuploadUtils.getFileTypeName(fileName);
        String[] format = ImageIO.getWriterFormatNames();
        int len = format.length;
        for (int i = 0; i < len; ++i) {
            if (!format[i].equals(fileType)) continue;
            return true;
        }
        return false;
    }

    public static String getFileTypeName(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        if (index < 1) {
            return null;
        }
        return fileName.substring(index + 1, fileName.length());
    }

    public static BufferedImage shrinkImage(BufferedImage imgfile, int width, int height) {
        int iwidth = imgfile.getWidth();
        int iheight = imgfile.getHeight();
        double ratio = Math.min((double)width / (double)iwidth, (double)height / (double)iheight);
        int shrinkedWidth = (int)((double)iwidth * ratio);
        int shrinkedHeight = (int)((double)iheight * ratio);
        Image targetImage = imgfile.getScaledInstance(shrinkedWidth, shrinkedHeight, 16);
        BufferedImage tmpImage = new BufferedImage(targetImage.getWidth(null), targetImage.getHeight(null), 1);
        Graphics2D g = tmpImage.createGraphics();
        g.drawImage(targetImage, 0, 0, null);
        return tmpImage;
    }
}

